/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.arrow;

import com.milamber_brass.brass_armory.client.render.SpecialArrowRenderer;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractSpecialArrowEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.SpecialArrowItem;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class FireArrowEntity
extends AbstractSpecialArrowEntity {
    public FireArrowEntity(EntityType<? extends FireArrowEntity> entityType, Level level) {
        super(entityType, level);
    }

    public FireArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.FIRE_ARROW.get()), level, shooter);
        this.m_36781_(2.5);
    }

    public FireArrowEntity(Level level, double x, double y, double z) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.FIRE_ARROW.get()), level, x, y, z);
        this.m_36781_(2.5);
    }

    protected void m_7761_(LivingEntity living) {
        super.m_7761_(living);
        if (!this.dealtDamage) {
            living.m_20254_(16);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.dealtDamage) {
            ArmoryUtil.blockHitSetOnFire(result, this.f_19853_, this.m_37282_());
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ((SpecialArrowItem)((Object)BrassArmoryItems.FIRE_ARROW.get())).m_7968_();
    }

    @Override
    protected void spawnArrowParticles(int particleCount) {
        for (int j = 0; j < particleCount; ++j) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return SpecialArrowRenderer.FIRE_ARROW_TEXTURE;
    }
}

