/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.arrow;

import com.milamber_brass.brass_armory.client.render.SpecialArrowRenderer;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractSpecialArrowEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.SpecialArrowItem;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class TorchArrowEntity
extends AbstractSpecialArrowEntity
implements ItemSupplier {
    protected static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(TorchArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public TorchArrowEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public TorchArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.TORCH_ARROW.get()), level, shooter);
        this.m_36781_(0.5);
        if (shooter instanceof Player) {
            this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
    }

    public TorchArrowEntity(Level level, double x, double y, double z) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.TORCH_ARROW.get()), level, x, y, z);
        this.m_36781_(0.5);
        this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        BlockState torchState;
        super.m_8060_(blockHitResult);
        Direction direction = blockHitResult.m_82434_();
        BlockPos relative = blockHitResult.m_82425_().m_121945_(direction);
        boolean flag = this.f_19853_.m_8055_(relative).m_60767_().m_76336_();
        if (direction.equals((Object)Direction.UP) && flag) {
            BlockState torchState2 = this.getTorch().m_40614_().m_49966_();
            if (torchState2.m_60710_((LevelReader)this.f_19853_, relative)) {
                this.f_19853_.m_7731_(relative, torchState2, 11);
                this.f_19853_.m_142346_(this.m_37282_(), GameEvent.f_157797_, relative);
                this.m_146870_();
            }
        } else if (!direction.equals((Object)Direction.DOWN) && flag && (torchState = (BlockState)this.getTorch().f_43246_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction)).m_60710_((LevelReader)this.f_19853_, relative)) {
            this.f_19853_.m_7731_(relative, torchState, 11);
            this.f_19853_.m_142346_(this.m_37282_(), GameEvent.f_157797_, relative);
            this.m_146870_();
        }
    }

    @Override
    protected void spawnArrowParticles(int particleCount) {
        Block block = this.getTorch().m_40614_();
        if (block instanceof TorchBlock) {
            TorchBlock torchBlock = (TorchBlock)block;
            torchBlock.m_214162_(torchBlock.m_49966_(), this.f_19853_, this.m_20183_(), this.f_19796_);
        }
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return SpecialArrowRenderer.TORCH_ARROW_TEXTURE;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ((SpecialArrowItem)((Object)BrassArmoryItems.DIRT_ARROW.get())).m_7968_();
    }

    public void m_7380_(CompoundTag tag) {
        ArmoryUtil.addStack(tag, this.getItemRaw(), "BATorch");
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        this.setTorch(tag);
        super.m_7378_(tag);
    }

    public void setTorch(CompoundTag tag) {
        this.setItem(ArmoryUtil.loadStack(tag, "BATorch", Items.f_42000_.m_7968_()));
    }

    public void setItem(ItemStack stack) {
        this.f_19804_.m_135381_(DATA_ITEM_STACK, (Object)stack.m_41777_());
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ITEM_STACK);
    }

    @Nonnull
    public ItemStack m_7846_() {
        ItemStack itemstack = this.getItemRaw();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)Items.f_42000_) : itemstack;
    }

    @Nonnull
    protected StandingAndWallBlockItem getTorch() {
        StandingAndWallBlockItem torch;
        Item item = this.m_7846_().m_41720_();
        if (item instanceof StandingAndWallBlockItem && (torch = (StandingAndWallBlockItem)item).m_40614_() instanceof TorchBlock) {
            return torch;
        }
        return (StandingAndWallBlockItem)Items.f_42000_;
    }
}

