/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.cannon_balls;

import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractBulletEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryAdvancements;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.CarcassRoundItem;
import com.milamber_brass.brass_armory.util.Impact;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class CarcassRoundEntity
extends AbstractBulletEntity {
    public static final int LEVEL_EVENT_CONSTANT = 801682224;

    public CarcassRoundEntity(EntityType<? extends AbstractBulletEntity> entityType, Level level) {
        super(entityType, level);
    }

    public CarcassRoundEntity(Level level, LivingEntity livingEntity) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.CARCASS_ROUND.get()), livingEntity, level);
    }

    public CarcassRoundEntity(double x, double y, double z, Level level) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.CARCASS_ROUND.get()), x, y, z, level);
    }

    public void m_37251_(Entity shooter, float xRot, float yRot, float v, float speed, float accuracy) {
        super.m_37251_(shooter, xRot, yRot, v, speed * 0.5f, accuracy);
    }

    @Override
    @NotNull
    public ItemStack m_7846_() {
        if (!this.f_19853_.m_5776_()) {
            return super.m_7846_();
        }
        return (ItemStack)Util.m_137469_((Object)super.m_7846_(), stack -> PotionUtils.m_43549_((ItemStack)stack, (Potion)Potions.f_43596_));
    }

    public void m_8119_() {
        super.m_8119_();
        if (CarcassRoundItem.isADragonRound(this.m_7846_())) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_(), this.m_20188_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected void m_6532_(HitResult onHit) {
        Vec3 pos = onHit.m_82450_();
        Impact impact = new Impact(this.f_19853_, (Entity)this, pos, 1.0f, this.m_6060_(), Explosion.BlockInteraction.DESTROY);
        if (!this.f_19853_.f_46443_) {
            impact.m_46061_();
            impact.m_46075_(true);
            ItemStack stack = this.m_7846_();
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            List list = PotionUtils.m_43547_((ItemStack)stack);
            Vec3 diff = pos.m_82546_(this.m_20182_());
            if (potion.equals(Potions.f_43599_) && list.isEmpty()) {
                this.applyWater(diff);
            } else if (!list.isEmpty()) {
                Entity entity;
                if (onHit instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)onHit;
                    entity = entityHitResult.m_82443_();
                } else {
                    entity = null;
                }
                this.applySplash(list, entity, diff);
                this.makeAreaOfEffectCloud(stack, potion, pos);
            }
            if (CarcassRoundItem.isADragonRound(stack)) {
                this.f_19853_.m_46796_(2006, this.m_20183_(), -1);
            } else {
                this.f_19853_.m_46796_(801682224, this.m_20183_(), PotionUtils.m_43575_((ItemStack)stack));
            }
            Entity entity = this.m_37282_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                BrassArmoryAdvancements.DRAGON_ROUND.trigger(player);
            }
        }
        this.m_146852_(GameEvent.f_157777_, this.m_37282_());
        super.m_6532_(onHit);
        this.m_146870_();
    }

    protected void applyWater(Vec3 diff) {
        AABB boundingBox = this.m_20191_().m_82377_(4.0, 2.0, 4.0).m_82383_(diff);
        List livingEntities = this.f_19853_.m_6443_(LivingEntity.class, boundingBox, LivingEntity::m_6126_);
        if (!livingEntities.isEmpty()) {
            for (LivingEntity livingentity : livingEntities) {
                if (!(this.m_20280_((Entity)livingentity) < 16.0) || !livingentity.m_6126_()) continue;
                livingentity.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)this.m_37282_()), 1.0f);
            }
        }
        for (Axolotl axolotl : this.f_19853_.m_45976_(Axolotl.class, boundingBox)) {
            axolotl.m_149177_();
        }
    }

    protected void applySplash(List<MobEffectInstance> mobEffectInstances, @Nullable Entity victim, Vec3 diff) {
        List livingEntities = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(4.0, 2.0, 4.0).m_82383_(diff));
        if (!livingEntities.isEmpty()) {
            Entity effectSource = this.m_150173_();
            for (LivingEntity livingentity : livingEntities) {
                double distanceToSqr;
                if (!livingentity.m_5801_() || !((distanceToSqr = this.m_20280_((Entity)livingentity)) < 16.0)) continue;
                double durationMultiplier = 1.0 - Math.sqrt(distanceToSqr) / 4.0;
                if (livingentity.equals((Object)victim)) {
                    durationMultiplier = 1.0;
                }
                for (MobEffectInstance mobeffectinstance : mobEffectInstances) {
                    MobEffect mobeffect = mobeffectinstance.m_19544_();
                    if (mobeffect.m_8093_()) {
                        mobeffect.m_19461_((Entity)this, this.m_37282_(), livingentity, mobeffectinstance.m_19564_(), durationMultiplier);
                        continue;
                    }
                    int duration = (int)(durationMultiplier * (double)mobeffectinstance.m_19557_() + 0.5);
                    if (duration <= 20) continue;
                    livingentity.m_147207_(new MobEffectInstance(mobeffect, duration, mobeffectinstance.m_19564_(), mobeffectinstance.m_19571_(), mobeffectinstance.m_19572_()), effectSource);
                }
            }
        }
    }

    protected void makeAreaOfEffectCloud(ItemStack itemStack, Potion potion, Vec3 pos) {
        AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.f_19853_, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        Entity entity = this.m_37282_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            areaeffectcloud.m_19718_(living);
        }
        areaeffectcloud.m_19712_(3.0f);
        if (CarcassRoundItem.isADragonRound(itemStack)) {
            areaeffectcloud.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
            areaeffectcloud.m_19734_(600);
            areaeffectcloud.m_19738_((7.0f - areaeffectcloud.m_19743_()) / (float)areaeffectcloud.m_19748_());
            areaeffectcloud.m_19716_(new MobEffectInstance(MobEffects.f_19602_, 1, 1));
        } else {
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            areaeffectcloud.m_19722_(potion);
            for (MobEffectInstance mobeffectinstance : PotionUtils.m_43571_((ItemStack)itemStack)) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            CompoundTag compoundtag = itemStack.m_41783_();
            if (compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99)) {
                areaeffectcloud.m_19714_(compoundtag.m_128451_("CustomPotionColor"));
            }
        }
        this.f_19853_.m_7967_((Entity)areaeffectcloud);
    }

    @Override
    @NotNull
    protected Item getDefaultItem() {
        return (Item)BrassArmoryItems.CARCASS_ROUND.get();
    }
}

