/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.event;

import com.milamber_brass.brass_armory.client.sound.CannonSoundInstance;
import com.milamber_brass.brass_armory.entity.CannonEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryCapabilities;
import com.milamber_brass.brass_armory.item.FlintlockItem;
import com.milamber_brass.brass_armory.item.LongBowItem;
import com.milamber_brass.brass_armory.item.MaceItem;
import com.milamber_brass.brass_armory.item.WarpCrystalItem;
import com.milamber_brass.brass_armory.item.abstracts.AbstractThrownWeaponItem;
import com.milamber_brass.brass_armory.item.interfaces.ICustomAnimationItem;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber(modid="brass_armory", value={Dist.CLIENT})
public class ClientEventSubscriber {
    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && player.m_6117_()) {
            ItemStack eventItem = event.getItemStack();
            if (eventItem.m_41720_() instanceof ICustomAnimationItem || eventItem.m_41720_() instanceof LongBowItem || eventItem.m_41720_() instanceof AbstractThrownWeaponItem && eventItem.m_41720_().m_6164_(player.m_21211_()) == UseAnim.SPEAR) {
                boolean doubleMace;
                event.setCanceled(true);
                boolean bl = doubleMace = player.m_21205_().m_41720_() instanceof MaceItem && player.m_21206_().m_41720_() instanceof MaceItem;
                if (player.m_7655_() == event.getHand() || doubleMace) {
                    boolean mainHandFlag = event.getHand() == InteractionHand.MAIN_HAND;
                    HumanoidArm humanoidarm = mainHandFlag ? player.m_5737_() : player.m_5737_().m_20828_();
                    boolean rightHandFlag = humanoidarm == HumanoidArm.RIGHT;
                    float k = rightHandFlag ? 1.0f : -1.0f;
                    ItemTransforms.TransformType transformType = rightHandFlag ? ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
                    PoseStack poseStack = event.getPoseStack();
                    ItemStack itemStack = event.getItemStack();
                    if (doubleMace) {
                        poseStack.m_85836_();
                    }
                    float f8 = (float)itemStack.m_41779_() - (float)player.m_21212_();
                    float f9 = f8 + event.getPartialTick();
                    poseStack.m_85837_((double)(k * 0.56f), (double)-0.52f, (double)-0.72f);
                    Item item = itemStack.m_41720_();
                    if (item instanceof ICustomAnimationItem) {
                        ICustomAnimationItem animationItem = (ICustomAnimationItem)item;
                        float maxCharge = animationItem.getChargeDuration(itemStack);
                        float v = Math.min(f9, maxCharge);
                        event.setCanceled(true);
                        float m = v / (maxCharge * 10.0f);
                        double sineWave = Math.sin((double)f8 * 75.0) * 0.004;
                        poseStack.m_85837_(0.0, sineWave + (double)m, (double)m);
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-13.935f + m * 200.0f));
                        poseStack.m_85845_(Vector3f.f_122224_.m_122240_(k * 9.7f));
                        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(k * -9.785f));
                        poseStack.m_85841_(1.0f + (float)sineWave, 1.0f + (float)sineWave, 1.0f + (float)sineWave);
                    } else if (itemStack.m_41720_() instanceof LongBowItem) {
                        poseStack.m_85837_((double)(k * -0.2785682f), 0.18344387412071228, 0.15731531381607056);
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-13.935f));
                        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(k * 35.3f));
                        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(k * -9.785f));
                        float f12 = f9 / 30.0f;
                        f12 = (f12 * f12 + f12 * 2.0f) / 3.0f;
                        if (f12 > 1.0f) {
                            f12 = 1.0f;
                        }
                        if (f12 > 0.1f) {
                            float f15 = Mth.m_14031_((float)((f8 - 0.1f) * 1.3f));
                            float f18 = f12 - 0.1f;
                            float f20 = f15 * f18;
                            poseStack.m_85837_((double)(f20 * 0.0f), (double)(f20 * 0.004f), (double)(f20 * 0.0f));
                        }
                        poseStack.m_85837_((double)(f12 * 0.0f), (double)(f12 * 0.0f), (double)(f12 * 0.04f));
                        poseStack.m_85841_(1.0f, 1.0f, 1.0f + f12 * 0.2f);
                        poseStack.m_85845_(Vector3f.f_122224_.m_122240_(k * 45.0f));
                    } else {
                        float f;
                        poseStack.m_85837_((double)(k * -0.5f), (double)0.7f, (double)0.1f);
                        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-55.0f));
                        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(k * 35.3f));
                        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(k * -9.785f));
                        Item f18 = eventItem.m_41720_();
                        if (f18 instanceof AbstractThrownWeaponItem) {
                            AbstractThrownWeaponItem item2 = (AbstractThrownWeaponItem)f18;
                            f = item2.chargeDuration;
                        } else {
                            f = 10.0f;
                        }
                        float f11 = f9 / f;
                        if (f11 > 1.0f) {
                            f11 = 1.0f;
                        }
                        if (f11 > 0.1f) {
                            float f14 = Mth.m_14031_((float)((f8 - 0.1f) * 1.3f));
                            float f17 = f11 - 0.1f;
                            float f19 = f14 * f17;
                            poseStack.m_85837_((double)(f19 * 0.0f), (double)(f19 * 0.004f), (double)(f19 * 0.0f));
                        }
                        poseStack.m_85837_(0.0, 0.0, (double)(f11 * 0.2f));
                        poseStack.m_85841_(1.0f, 1.0f, 1.0f + f11 * 0.2f);
                        poseStack.m_85845_(Vector3f.f_122224_.m_122240_(k * 45.0f));
                    }
                    mc.m_91290_().m_234586_().m_109322_((LivingEntity)player, itemStack, transformType, !rightHandFlag, poseStack, event.getMultiBufferSource(), event.getPackedLight());
                    if (doubleMace) {
                        poseStack.m_85849_();
                    }
                }
            } else if (eventItem.m_41720_() instanceof WarpCrystalItem) {
                event.setCanceled(true);
                PoseStack poseStack = event.getPoseStack();
                boolean mainHandFlag = event.getHand() == InteractionHand.MAIN_HAND;
                HumanoidArm humanoidarm = mainHandFlag ? player.m_5737_() : player.m_5737_().m_20828_();
                boolean rightHandFlag = humanoidarm == HumanoidArm.RIGHT;
                float f1 = ((float)player.m_21252_() + event.getPartialTick()) / 40.0f;
                f1 = f1 > 1.0f ? 1.0f + (float)Math.sin(f1 * 7.0f) * 0.0035f : (float)Math.pow(f1, 1.6);
                poseStack.m_85837_(0.0, 0.0, (double)(-1.0f - f1 / 4.0f));
                Lighting.m_84931_();
                mc.m_91290_().m_234586_().m_109322_((LivingEntity)player, eventItem.m_41777_(), ItemTransforms.TransformType.FIXED, rightHandFlag, poseStack, event.getMultiBufferSource(), 0xF000F0);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (player.m_21205_().m_41720_() instanceof FlintlockItem && FlintlockItem.getLoad(player.m_21205_()) == 2) {
            if (player.m_5737_() == HumanoidArm.RIGHT) {
                ((PlayerModel)event.getRenderer().m_7200_()).f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                ((PlayerModel)event.getRenderer().m_7200_()).f_102815_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        } else if (player.m_21206_().m_41720_() instanceof FlintlockItem && FlintlockItem.getLoad(player.m_21206_()) == 2) {
            if (player.m_5737_() == HumanoidArm.LEFT) {
                ((PlayerModel)event.getRenderer().m_7200_()).f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                ((PlayerModel)event.getRenderer().m_7200_()).f_102815_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
    }

    @SubscribeEvent
    public static void onFOVModifier(ComputeFovModifierEvent event) {
        Player player = event.getPlayer();
        if (player.m_6117_()) {
            ItemStack useStack = player.m_21211_();
            Item useItem = useStack.m_41720_();
            if (useItem instanceof LongBowItem || useItem instanceof ICustomAnimationItem || useItem instanceof AbstractThrownWeaponItem) {
                float f9;
                if (useItem instanceof AbstractThrownWeaponItem) {
                    AbstractThrownWeaponItem thrownWeaponItem = (AbstractThrownWeaponItem)useItem;
                    f9 = thrownWeaponItem.chargeDuration;
                } else if (useItem instanceof ICustomAnimationItem) {
                    ICustomAnimationItem customAnimationItem = (ICustomAnimationItem)useItem;
                    f9 = customAnimationItem.getChargeDuration(useStack);
                } else {
                    f9 = 30.0f;
                }
                float f1 = (float)player.m_21252_() / f9;
                f1 = f1 > 1.0f ? 1.0f : (float)Math.pow(f1, 1.6);
                event.setNewFovModifier(event.getFovModifier() * (1.0f - f1 * (useItem instanceof LongBowItem ? 0.15f : 0.075f)));
            } else if (useItem instanceof WarpCrystalItem) {
                float f1 = (float)player.m_21252_() / 40.0f;
                f1 = f1 > 1.0f ? 1.0f + (float)Math.sin(f1 * 7.0f) * 0.0035f : f1 * f1;
                event.setNewFovModifier(event.getFovModifier() * (1.0f - f1 * 0.75f));
            }
        }
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        Minecraft minecraft = Minecraft.m_91087_();
        Entity entity = minecraft.m_91288_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!minecraft.m_91104_()) {
                player.getCapability(BrassArmoryCapabilities.EFFECT_CAPABILITY).ifPresent(iShakeCapability -> {
                    float intensity = (float)iShakeCapability.getShake() * 1.5f;
                    if (intensity > 0.0f) {
                        float partialTicks = (float)event.getPartialTick();
                        event.setYaw(Mth.m_14179_((float)partialTicks, (float)event.getYaw(), (float)(event.getYaw() + (player.m_217043_().m_188501_() * 2.0f - 1.0f) * intensity)));
                        event.setPitch(Mth.m_14179_((float)partialTicks, (float)event.getPitch(), (float)(event.getPitch() + (player.m_217043_().m_188501_() * 2.0f - 1.0f) * intensity)));
                        event.setRoll(Mth.m_14179_((float)partialTicks, (float)event.getRoll(), (float)(event.getRoll() + (player.m_217043_().m_188501_() * 2.0f - 1.0f) * intensity)));
                        iShakeCapability.reduceShake(iShakeCapability.getShake() * 0.1);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof CannonEntity) {
            CannonEntity cannonEntity = (CannonEntity)entity;
            if (cannonEntity.f_19853_.f_46443_) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new CannonSoundInstance(cannonEntity));
            }
        }
    }
}

