/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.init;

import com.milamber_brass.brass_armory.BrassArmory;
import com.milamber_brass.brass_armory.behaviour.GunBehaviours;
import com.milamber_brass.brass_armory.data.BrassArmoryTags;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.BombItem;
import com.milamber_brass.brass_armory.item.CannonItem;
import com.milamber_brass.brass_armory.item.CarcassRoundItem;
import com.milamber_brass.brass_armory.item.FlintlockItem;
import com.milamber_brass.brass_armory.item.GliderItem;
import com.milamber_brass.brass_armory.item.KatanaItem;
import com.milamber_brass.brass_armory.item.SpecialArrowItem;
import com.milamber_brass.brass_armory.item.WarpCrystalItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class BrassArmoryItemGroups {
    public static final CreativeModeTab BRASS_ARMORY = new CreativeModeTab("brass_armory"){

        @Nonnull
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)BrassArmoryItems.GOLDEN_BATTLEAXE.get());
        }

        public boolean hasSearchBar() {
            return true;
        }

        public int getSearchbarWidth() {
            return 79;
        }

        @Nonnull
        public ResourceLocation getBackgroundImage() {
            return BrassArmory.locate("textures/gui/creative_tab.png");
        }

        public int getLabelColor() {
            return 0xFFAA00;
        }

        @ParametersAreNonnullByDefault
        public void m_6151_(NonNullList<ItemStack> itemStacks) {
            ArrayList katanaItems = new ArrayList();
            ArrayList tieredItems = new ArrayList();
            ArrayList bowItems = new ArrayList();
            ArrayList gunItems = new ArrayList();
            ArrayList ammoItems = new ArrayList();
            ArrayList bombItems = new ArrayList();
            ArrayList arrowItems = new ArrayList();
            ArrayList blockItems = new ArrayList();
            ArrayList warpCrystalItems = new ArrayList();
            ArrayList gliderItems = new ArrayList();
            ArrayList cannonStuff = new ArrayList();
            List<Item> allItems = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.getCreativeTabs().contains((Object)this)).filter(item -> {
                if (item instanceof KatanaItem) {
                    KatanaItem katanaItem = (KatanaItem)((Object)item);
                    katanaItems.add(katanaItem);
                    return false;
                }
                if (item instanceof TieredItem) {
                    TieredItem tieredItem = (TieredItem)item;
                    tieredItems.add(tieredItem);
                    return false;
                }
                if (item instanceof BowItem) {
                    BowItem bowItem = (BowItem)item;
                    bowItems.add(bowItem);
                    return false;
                }
                if (item instanceof CannonItem || item.m_7968_().m_204117_(BrassArmoryTags.Items.CANNON_AMMO) && !item.m_7968_().m_204117_(BrassArmoryTags.Items.BOMB)) {
                    cannonStuff.add(item);
                    return false;
                }
                if (item instanceof FlintlockItem) {
                    FlintlockItem gunItem = (FlintlockItem)item;
                    gunItems.add(gunItem);
                    return false;
                }
                if (item instanceof BombItem) {
                    BombItem bombItem = (BombItem)((Object)item);
                    bombItems.add(bombItem);
                    return false;
                }
                if (item instanceof SpecialArrowItem) {
                    SpecialArrowItem arrowItem = (SpecialArrowItem)((Object)item);
                    arrowItems.add(arrowItem);
                    return false;
                }
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    blockItems.add(blockItem);
                    return false;
                }
                if (item instanceof WarpCrystalItem) {
                    WarpCrystalItem warpCrystalItem = (WarpCrystalItem)((Object)item);
                    warpCrystalItems.add(warpCrystalItem);
                    return false;
                }
                if (item instanceof GliderItem) {
                    GliderItem gliderItem = (GliderItem)((Object)item);
                    gliderItems.add(gliderItem);
                    return false;
                }
                if (GunBehaviours.itemHasAmmoBehaviour(item)) {
                    ammoItems.add(item);
                    return false;
                }
                return true;
            }).toList();
            tieredItems.stream().sorted(Comparator.comparingDouble(tieredItem -> {
                Tier tier = tieredItem.m_43314_();
                if (tier == Tiers.WOOD) {
                    return 0.1;
                }
                if (tier == Tiers.STONE) {
                    return 0.2;
                }
                if (tier == Tiers.GOLD) {
                    return 0.3;
                }
                if (tier == Tiers.IRON) {
                    return 0.4;
                }
                if (tier == Tiers.DIAMOND) {
                    return 0.5;
                }
                if (tier == Tiers.NETHERITE) {
                    return 0.6;
                }
                return tieredItem.m_43314_().m_6631_();
            })).forEach(item -> item.m_6787_((CreativeModeTab)this, itemStacks));
            katanaItems.forEach(item -> item.m_6787_(this, itemStacks));
            allItems.forEach(item -> item.m_6787_((CreativeModeTab)this, itemStacks));
            blockItems.forEach(item -> item.m_6787_((CreativeModeTab)this, itemStacks));
            warpCrystalItems.stream().sorted(Comparator.comparingInt(WarpCrystalItem::getMaxDistance)).forEach(item -> item.m_6787_(this, itemStacks));
            gliderItems.forEach(item -> item.m_6787_(this, itemStacks));
            gunItems.stream().sorted(Comparator.comparingDouble(FlintlockItem::getDamageMultiplier)).forEach(item -> item.m_6787_(this, itemStacks));
            ammoItems.forEach(item -> item.m_6787_((CreativeModeTab)this, itemStacks));
            bombItems.forEach(item -> item.m_6787_(this, itemStacks));
            bowItems.forEach(item -> item.m_6787_((CreativeModeTab)this, itemStacks));
            arrowItems.forEach(item -> item.m_6787_(this, itemStacks));
            cannonStuff.remove(BrassArmoryItems.CARCASS_ROUND.get());
            cannonStuff.forEach(item -> item.m_6787_((CreativeModeTab)this, itemStacks));
            ((CarcassRoundItem)((Object)BrassArmoryItems.CARCASS_ROUND.get())).m_6787_(this, itemStacks);
        }
    };
}

