/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item;

import com.milamber_brass.brass_armory.behaviour.GunBehaviours;
import com.milamber_brass.brass_armory.behaviour.iGun;
import com.milamber_brass.brass_armory.behaviour.powder.AbstractPowderBehaviour;
import com.milamber_brass.brass_armory.data.BrassArmoryTags;
import com.milamber_brass.brass_armory.init.BrassArmoryAdvancements;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import com.milamber_brass.brass_armory.inventory.GunContainer;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
public class FlintlockItem
extends ProjectileWeaponItem
implements Vanishable,
iGun {
    protected final boolean oneHanded;
    public final double damageMultiplier;
    protected final float loadSpeed;
    protected final float accuracy;
    protected final double recoil;

    public FlintlockItem(Item.Properties properties, boolean oneHanded, double damageMultiplier, float loadSpeed, float accuracy, double recoil) {
        super(properties);
        this.oneHanded = oneHanded;
        this.damageMultiplier = damageMultiplier;
        this.loadSpeed = loadSpeed;
        this.accuracy = accuracy;
        this.recoil = recoil;
    }

    public double getDamageMultiplier() {
        return this.damageMultiplier;
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack gunStack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        int load = FlintlockItem.getLoad(stack);
        if (load == 0 && !ArmoryUtil.loadStack(stack.m_41784_(), "BAAmmo", ItemStack.f_41583_).m_41619_() && !ArmoryUtil.loadStack(stack.m_41784_(), "BAPowder", ItemStack.f_41583_).m_41619_()) {
            load = 1;
            FlintlockItem.setLoad(stack, 1);
        }
        switch (load) {
            case 0: {
                if (level.f_46443_) break;
                ArmoryUtil.addStack(stack.m_41784_(), this.m_7968_(), "BAGunIcon");
                SimpleMenuProvider container = new SimpleMenuProvider(GunContainer.getServerContainer(this, stack.m_41784_()), (Component)Component.m_237119_());
                player.m_5893_((MenuProvider)container);
                break;
            }
            case 1: {
                ArmoryUtil.clearStack(stack.m_41784_(), "BAGunIcon");
                player.m_6672_(interactionHand);
                break;
            }
            default: {
                GunBehaviours.getPowderBehaviour(ArmoryUtil.loadStack(stack.m_41784_(), "BAPowder", ItemStack.f_41583_)).ifPresent(powderBehaviour -> {
                    Vec3 view = player.m_20252_(ArmoryUtil.frameTime(level)).m_82490_(-this.recoil);
                    player.m_5997_(view.f_82479_, view.f_82480_, view.f_82481_);
                    ItemStack ammo = ArmoryUtil.loadStack(stack.m_41784_(), "BAAmmo", ItemStack.f_41583_);
                    GunBehaviours.getAmmoBehavior(ammo).ifPresent(ammoBehaviour -> {
                        if (ammoBehaviour.onShoot(level, (LivingEntity)player, (Entity)player, ammo, (AbstractPowderBehaviour)powderBehaviour, this)) {
                            stack.m_41622_(1, (LivingEntity)player, living -> player.m_21190_(player.m_7655_()));
                        }
                    });
                    if (!level.f_46443_) {
                        level.m_6269_(null, (Entity)player, this.getGunShootSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        FlintlockItem.setLoad(stack, 0);
                        ArmoryUtil.clearStack(stack.m_41784_(), "BAAmmo");
                        ArmoryUtil.clearStack(stack.m_41784_(), "BAPowder");
                        FlintlockItem.setLoadProgress(stack, 0.0f);
                        player.m_36335_().m_41524_(stack.m_41720_(), 10);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    }
                });
            }
        }
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(interactionHand));
    }

    protected SoundEvent getGunShootSound() {
        return (SoundEvent)BrassArmorySounds.GUN_SHOOT.get();
    }

    public void onUsingTick(ItemStack stack, LivingEntity entityLiving, int count) {
        FlintlockItem.setLoadProgress(stack, FlintlockItem.getLoadProgress(stack) + this.loadSpeed);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (FlintlockItem.getLoadProgress(stack) < 20.0f) {
                FlintlockItem.setLoadProgress(stack, 0.0f);
            } else {
                FlintlockItem.setLoad(stack, 2);
                player.m_36335_().m_41524_(stack.m_41720_(), 5);
                player.f_19853_.m_6269_(player, (Entity)player, this.getGunLoadSound(), SoundSource.PLAYERS, 1.0f, level.m_213780_().m_188501_() * 0.25f + 0.75f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    BrassArmoryAdvancements.LOAD_GUN.trigger(serverPlayer);
                }
            }
        }
    }

    public SoundEvent getGunLoadSound() {
        return (SoundEvent)BrassArmorySounds.GUN_LOAD.get();
    }

    public boolean isOneHanded() {
        return this.oneHanded;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_41720_().equals(newStack.m_41720_()) || slotChanged;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public static void setLoadProgress(ItemStack gunStack, float progress) {
        if (gunStack.m_41783_() != null) {
            gunStack.m_41751_((CompoundTag)Util.m_137469_((Object)gunStack.m_41784_().m_6426_(), tag -> tag.m_128350_("LoadProgress", Math.min(progress, 20.0f))));
        }
    }

    public static float getLoadProgress(ItemStack gunStack) {
        if (gunStack.m_41782_() && gunStack.m_41783_() != null) {
            return gunStack.m_41783_().m_128457_("LoadProgress");
        }
        gunStack.m_41751_((CompoundTag)Util.m_137469_((Object)new CompoundTag(), tag -> tag.m_128350_("LoadProgress", 0.0f)));
        return 0.0f;
    }

    public static void setLoad(ItemStack gunStack, int load) {
        CompoundTag tag = gunStack.m_41783_() != null ? gunStack.m_41783_().m_6426_() : new CompoundTag();
        tag.m_128405_("BAGunLoaded", load);
        gunStack.m_41751_(tag);
    }

    public static int getLoad(ItemStack gunStack) {
        if (gunStack.m_41782_() && gunStack.m_41783_() != null) {
            return gunStack.m_41783_().m_128451_("BAGunLoaded");
        }
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128405_("BAGunLoaded", 0);
        gunStack.m_41751_(new CompoundTag());
        return 0;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if ((double)state.m_60800_((BlockGetter)worldIn, pos) != 0.0) {
            stack.m_41622_(2, entityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    @Nonnull
    public Predicate<ItemStack> m_6437_() {
        return Optional.ofNullable(this.getAmmoType()).map(itemTag -> stack -> stack.m_204117_(itemTag)).orElseGet(() -> stack -> false);
    }

    @Nullable
    protected TagKey<Item> getAmmoType() {
        return BrassArmoryTags.Items.FLINTLOCK_AMMO;
    }

    public int m_6615_() {
        return 0;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        if (FlintlockItem.getLoad(stack) == 2) {
            for (ItemStack ammoStack : ArmoryUtil.loadStackList(stack.m_41784_(), "BAAmmo")) {
                components.add((Component)Component.m_237115_((String)"item.minecraft.crossbow.projectile").m_130946_(" ").m_7220_(ammoStack.m_41611_()));
            }
        }
    }

    @Override
    public void onOpen(Player owner, CompoundTag tag) {
        owner.f_19853_.m_6269_(null, (Entity)owner, (SoundEvent)BrassArmorySounds.GUN_OPEN.get(), SoundSource.PLAYERS, 0.3f, owner.f_19853_.m_213780_().m_188501_() * 0.05f + 0.6f);
    }

    @Override
    public void onLoad(Player owner, CompoundTag tag) {
        owner.f_19853_.m_6269_(null, (Entity)owner, (SoundEvent)BrassArmorySounds.GUN_CLOSE.get(), SoundSource.PLAYERS, 0.5f, owner.f_19853_.m_213780_().m_188501_() * 0.06f + 0.2f);
    }

    @Override
    public Predicate<ItemStack> ammoPredicate() {
        return this.m_6437_();
    }

    @Override
    public Predicate<ItemStack> powderPredicate() {
        return itemStack -> itemStack.m_204117_(BrassArmoryTags.Items.FLINTLOCK_POWDER);
    }

    @Override
    public double damage() {
        return this.damageMultiplier;
    }

    @Override
    public float accuracy() {
        return this.accuracy;
    }

    @Override
    public float speed() {
        return 5.0f;
    }

    @Override
    public float particleMultiplier() {
        return this.isOneHanded() ? 0.5f : 1.0f;
    }

    @Override
    public double particleOffset() {
        return 0.05;
    }
}

