/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item;

import com.milamber_brass.brass_armory.capabilities.EffectCapabilityHandler;
import com.milamber_brass.brass_armory.init.BrassArmoryAdvancements;
import com.milamber_brass.brass_armory.init.BrassArmoryPackets;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import com.milamber_brass.brass_armory.item.abstracts.AbstractTieredWeaponItem;
import com.milamber_brass.brass_armory.item.interfaces.ICustomAnimationItem;
import com.milamber_brass.brass_armory.packets.ParticlePacket;
import com.milamber_brass.brass_armory.util.ArmoryCooldownCache;
import com.milamber_brass.brass_armory.util.ArmoryUtil;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class MaceItem
extends AbstractTieredWeaponItem
implements ICustomAnimationItem {
    public static final DustParticleOptions DUST = new DustParticleOptions(new Vector3f(new Vec3(0.98, 0.94, 0.9)), 0.8f);
    protected float DAMAGE_MULTIPLIER = 0.12f;

    public MaceItem(Tier tier, float attackDamage, float attackSpeed, Item.Properties builderIn) {
        super(tier, attackDamage, attackSpeed, builderIn);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack maceStack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)maceStack);
    }

    public void m_5551_(ItemStack maceStack, Level level, LivingEntity livingEntity, int useDurationLeft) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if ((float)(this.m_8105_(maceStack) - livingEntity.m_21212_()) >= this.getChargeDuration(maceStack)) {
                double pRange = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())).m_22135_() * 1.1;
                Vec3 vec3 = player.m_20299_(ArmoryUtil.frameTime(level));
                Vec3 vec31 = player.m_20252_(ArmoryUtil.frameTime(level));
                Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * pRange, vec31.f_82480_ * pRange, vec31.f_82481_ * pRange);
                BlockHitResult blockHitResult = level.m_45547_(new ClipContext(vec3, vec32, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                double trueDistance = blockHitResult.m_82450_().m_82554_(player.m_146892_());
                double power = Mth.m_14008_((double)((3.5 - trueDistance) * 2.0), (double)0.5, (double)5.0);
                if (!(!(player.f_19789_ > 0.0f) || player.m_20096_() || player.m_6147_() || player.m_20069_() || player.m_21023_(MobEffects.f_19610_) || player.m_20159_())) {
                    power *= 1.2;
                }
                BlockPos blockPos = blockHitResult.m_82425_();
                Vec3 vec = blockHitResult.m_82450_();
                if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
                    return;
                }
                boolean mainHand = player.m_7655_() == InteractionHand.MAIN_HAND;
                ItemStack otherItemStack = player.m_21120_(mainHand ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                if (!level.f_46443_) {
                    Item item = otherItemStack.m_41720_();
                    if (item instanceof MaceItem) {
                        MaceItem otherMace = (MaceItem)item;
                        otherMace.smash((ServerPlayer)player, level, vec, maceStack, otherItemStack, power *= 1.2);
                        maceStack.m_41622_(10, (LivingEntity)player, player1 -> player1.m_21190_(InteractionHand.MAIN_HAND));
                        otherItemStack.m_41622_(10, (LivingEntity)player, player1 -> player1.m_21190_(InteractionHand.OFF_HAND));
                    } else {
                        this.smash((ServerPlayer)player, level, vec, maceStack, null, power);
                        maceStack.m_41622_(10, (LivingEntity)player, player1 -> player1.m_21190_(player.m_7655_()));
                    }
                    this.smashParticles(livingEntity, vec, level, blockPos, power, blockHitResult.m_82434_());
                    level.m_6263_(null, vec.f_82479_, vec.f_82480_, vec.f_82481_, (SoundEvent)BrassArmorySounds.MACE_SMASH.get(), SoundSource.PLAYERS, (float)power * 0.2f, 0.5f - (float)power * 0.1f);
                    EffectCapabilityHandler.setShakePower(player, power * 0.35);
                }
            }
        }
    }

    private void smash(ServerPlayer player, Level level, Vec3 vec, ItemStack maceStack, @Nullable ItemStack otherMaceStack, double power) {
        double x = vec.f_82479_;
        double y = vec.f_82480_;
        double z = vec.f_82481_;
        AABB aabb = new AABB(x, y, z, x + 1.0, y + 1.0, z + 1.0).m_82400_(8.0 + power);
        List entitiesInRange = level.m_6443_(Entity.class, aabb, Entity::m_6084_);
        boolean otherMaceFlag = otherMaceStack != null;
        float maceDamage = ((MaceItem)maceStack.m_41720_()).getAttackDamage() * 1.5f;
        float otherMaceDamage = otherMaceFlag ? ((MaceItem)otherMaceStack.m_41720_()).getAttackDamage() * 1.5f : 0.0f;
        boolean hitAtLeastOne = false;
        for (Entity entity : entitiesInRange) {
            TamableAnimal pet;
            if (entity == player || entity instanceof ItemEntity || entity instanceof TamableAnimal && (pet = (TamableAnimal)entity).m_21826_() == player) continue;
            double entityDistance = entity.m_20182_().m_82554_(vec) * 0.8;
            if (entityDistance <= power) {
                float otherMaceEnchantment;
                float maceEnchantment;
                float seenPercent = Explosion.m_46064_((Vec3)vec, (Entity)entity);
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    maceEnchantment = EnchantmentHelper.m_44833_((ItemStack)maceStack, (MobType)living.m_6336_());
                    otherMaceEnchantment = otherMaceFlag ? EnchantmentHelper.m_44833_((ItemStack)otherMaceStack, (MobType)living.m_6336_()) : 0.0f;
                } else {
                    maceEnchantment = EnchantmentHelper.m_44833_((ItemStack)maceStack, (MobType)MobType.f_21640_);
                    otherMaceEnchantment = otherMaceFlag ? EnchantmentHelper.m_44833_((ItemStack)otherMaceStack, (MobType)MobType.f_21640_) : 0.0f;
                }
                float totalDMG = Math.max(maceDamage + maceEnchantment, otherMaceDamage + otherMaceEnchantment);
                float bonusDMG = Math.min(maceDamage + maceEnchantment, otherMaceDamage + otherMaceEnchantment) * 0.5f;
                float finalDMG = (totalDMG + bonusDMG) * seenPercent * ((float)power * this.DAMAGE_MULTIPLIER) * 3.0f;
                if (finalDMG > 0.0f) {
                    if (entity instanceof Player) {
                        Player p = (Player)entity;
                        EffectCapabilityHandler.setShakePower(p, power);
                    }
                    if (entity.m_6469_((DamageSource)new EntityDamageSource("brass_armory.mace_smash", (Entity)player), entity instanceof LivingEntity ? finalDMG : finalDMG * 0.25f)) {
                        if (entity instanceof LivingEntity) {
                            player.m_5704_(entity);
                        }
                        hitAtLeastOne = true;
                    }
                }
            }
            if (!(entityDistance <= power * 1.2) || !(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            living.m_147240_((double)0.1f * Math.abs(entityDistance - 5.0) + entityDistance > 4.0 ? (double)0.4f : 0.0, vec.f_82479_ - entity.m_20185_(), vec.f_82481_ - entity.m_20189_());
        }
        if (otherMaceFlag && hitAtLeastOne) {
            BrassArmoryAdvancements.MACE_SMASH_TRIGGER.trigger(player);
        }
        ArmoryUtil.addCooldownToList((Player)player, ArmoryCooldownCache.BrassArmoryMaces, 600);
    }

    private void smashParticles(LivingEntity player, Vec3 vec, Level level, BlockPos blockPos, double power, Direction direction) {
        Vec3i dirNormal = direction.m_122436_();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)blockPos.m_7918_(-6, -6, -6), (BlockPos)blockPos.m_7918_(6, 6, 6))) {
            BlockPos relativePos;
            BlockState relativeState;
            BlockState state = level.m_8055_(pos);
            if (!state.m_60783_((BlockGetter)level, pos, direction) || !(relativeState = level.m_8055_(relativePos = pos.m_121945_(direction))).m_60767_().m_76336_() && relativeState.m_60783_((BlockGetter)level, relativePos, direction.m_122424_())) continue;
            ParticlePacket particlePacket = new ParticlePacket();
            for (int i = 0; i < Math.max((int)power, 1); ++i) {
                Vec3 offset = new Vec3((double)(dirNormal.m_123341_() * i), (double)(dirNormal.m_123342_() * i), (double)(dirNormal.m_123343_() * i));
                Vec3 particlePos = Vec3.m_82528_((Vec3i)relativePos).m_82549_(offset);
                for (int j = 0; j < level.f_46441_.m_188503_((int)Math.max(power - Math.sqrt(pos.m_123331_((Vec3i)blockPos)), 8.0)) * 2; ++j) {
                    Vec3 finalPos = particlePos.m_82520_(level.f_46441_.m_188583_(), level.f_46441_.m_188583_(), level.f_46441_.m_188583_());
                    if (!(finalPos.m_82554_(vec) < power * 1.5)) continue;
                    particlePacket.queueParticle((ParticleOptions)DUST, false, finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_, 0.0, 0.0, 0.0);
                }
            }
            Vec3 off = new Vec3(dirNormal.m_123341_() == 0 ? 1.0 : 0.0, dirNormal.m_123342_() == 0 ? 1.0 : 0.0, dirNormal.m_123343_() == 0 ? 1.0 : 0.0);
            for (int i = 0; i < Math.max((int)power, 1) * 5; ++i) {
                Vec3 finalPos = Vec3.m_82512_((Vec3i)pos).m_82520_((double)dirNormal.m_123341_() * 0.5, (double)dirNormal.m_123342_() * 0.5, (double)dirNormal.m_123343_() * 0.5).m_82520_(level.f_46441_.m_188583_() * off.f_82479_, level.f_46441_.m_188583_() * off.f_82480_, level.f_46441_.m_188583_() * off.f_82481_);
                if (!(finalPos.m_82554_(vec) < power * 1.5)) continue;
                particlePacket.queueParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), false, finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_, 0.0, 0.0, 0.0);
            }
            BrassArmoryPackets.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)particlePacket);
        }
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack maceStack) {
        return UseAnim.SPEAR;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return false;
    }

    public int m_8105_(ItemStack maceStack) {
        return 72000;
    }

    @Override
    public float getChargeDuration(ItemStack itemStack) {
        return 20.0f;
    }
}

