/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.util;

import com.google.common.collect.Lists;
import com.milamber_brass.brass_armory.data.BrassArmoryTags;
import com.milamber_brass.brass_armory.effect.BleedEffect;
import com.milamber_brass.brass_armory.item.KatanaItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class ArmoryUtil {
    public static void impaleLivingEntity(LivingEntity living, float damage, RandomSource random) {
        float damageAfterAbsorb = CombatRules.m_19272_((float)damage, (float)living.m_21230_(), (float)((float)living.m_21133_(Attributes.f_22285_)));
        float finalDamage = damage - damageAfterAbsorb;
        finalDamage = Math.min(finalDamage, (float)Math.sqrt(finalDamage * 10.0f) / 10.0f);
        living.m_6469_(new DamageSource("brass_armory.impale").m_19380_(), finalDamage);
        for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            if (random.m_188499_()) break;
            ItemStack slotStack = living.m_6844_(slot);
            if (slotStack.m_41619_()) continue;
            slotStack.m_41622_(random.m_188503_(4), living, livingEntity -> livingEntity.m_21166_(slot));
        }
    }

    public static void bleedLivingEntity(LivingEntity livingTarget, LivingEntity thisLiving) {
        KatanaItem katanaItem;
        Item item;
        ItemStack stack = thisLiving.m_21205_();
        if (stack.m_204117_(BrassArmoryTags.Items.BLEEDING_EDGE)) {
            BleedEffect.bleedHarder(livingTarget, 70, 1);
        }
        if ((item = stack.m_41720_()) instanceof KatanaItem && (katanaItem = (KatanaItem)item).canWither() && KatanaItem.getWither(stack) >= 100) {
            BleedEffect.witherHarder(livingTarget, 70);
        }
    }

    public static void getWitherFromLivingEntity(LivingEntity livingTarget, LivingEntity thisLiving) {
        ItemStack stack = thisLiving.m_21205_();
        Level level = thisLiving.f_19853_;
        if (level instanceof ServerLevel) {
            KatanaItem katanaItem;
            ServerLevel serverLevel = (ServerLevel)level;
            level = stack.m_41720_();
            if (level instanceof KatanaItem && (katanaItem = (KatanaItem)level).canWither() && KatanaItem.getWither(stack) < 100 && livingTarget.m_21224_() && livingTarget.m_6095_().m_204039_(BrassArmoryTags.Entities.WITHER)) {
                KatanaItem.addWither(stack, thisLiving, serverLevel, livingTarget instanceof WitherBoss ? 50 : 2);
            }
        }
    }

    public static void blockHitSetOnFire(BlockHitResult blockHitResult, Level level, @Nullable Entity owner) {
        BlockPos pos = blockHitResult.m_82425_();
        BlockState state = level.m_8055_(pos);
        if (CampfireBlock.m_51321_((BlockState)state) || CandleBlock.m_152845_((BlockState)state) || CandleCakeBlock.m_152910_((BlockState)state)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
            level.m_142346_(owner, GameEvent.f_157797_, pos);
        } else {
            BlockPos relativePos = pos.m_121945_(blockHitResult.m_82434_());
            Material material = level.m_8055_(relativePos).m_60767_();
            if (BaseFireBlock.m_49255_((Level)level, (BlockPos)relativePos, (Direction)blockHitResult.m_82434_()) || material.equals(Material.f_76300_) || material.equals(Material.f_76302_)) {
                BlockState relativeState = BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)relativePos);
                level.m_7731_(relativePos, relativeState, 11);
                level.m_142346_(owner, GameEvent.f_157797_, pos);
            }
        }
    }

    @Nonnull
    public static List<ItemStack> loadStackList(CompoundTag compoundtag, String name) {
        ArrayList list = Lists.newArrayList();
        if (compoundtag.m_128425_(name, 9)) {
            ListTag listtag = compoundtag.m_128437_(name, 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag ammoCompoundTag = listtag.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)ammoCompoundTag));
            }
        }
        return list;
    }

    @Nonnull
    public static ItemStack loadStack(CompoundTag compoundtag, String name, ItemStack ifEmpty) {
        List<ItemStack> list = ArmoryUtil.loadStackList(compoundtag, name);
        if (list.isEmpty()) {
            return ifEmpty;
        }
        return list.get(0);
    }

    public static void addStack(CompoundTag compoundTag, ItemStack itemStack, String name) {
        ListTag listtag = compoundTag.m_128425_(name, 9) ? compoundTag.m_128437_(name, 10) : new ListTag();
        CompoundTag ammoCompoundTag = new CompoundTag();
        itemStack.m_41739_(ammoCompoundTag);
        listtag.add((Object)ammoCompoundTag);
        compoundTag.m_128365_(name, (Tag)listtag);
    }

    public static void clearStack(CompoundTag compoundtag, String name) {
        compoundtag.m_128473_(name);
    }

    @NotNull
    public static Explosion explode(Level level, Entity entity, float power, boolean burn, Explosion.BlockInteraction blockInteraction) {
        return ArmoryUtil.explode(level, entity, entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.5f), 0.0), power, burn, blockInteraction);
    }

    @NotNull
    public static Explosion explode(Level level, @Nullable Entity entity, Vec3 position, float power, boolean burn, Explosion.BlockInteraction blockInteraction) {
        return level.m_46518_(entity, position.f_82479_, position.f_82480_, position.f_82481_, power, burn, blockInteraction);
    }

    public static boolean isFuseLighter(ItemStack stack) {
        return stack.m_204117_(BrassArmoryTags.Items.FUSE_LIGHTER) || stack.m_41793_() && (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)stack) > 0 || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0);
    }

    public static HitResult getHitResult(Entity entity, Vec3 pointA, Vec3 pointB, double inflate, Predicate<Entity> entityPredicate) {
        EntityHitResult entityHitResult;
        Level level = entity.f_19853_;
        BlockHitResult hitResult = level.m_45547_(new ClipContext(pointA, pointB, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        if (hitResult.m_6662_() != HitResult.Type.MISS) {
            pointB = hitResult.m_82450_();
        }
        if ((entityHitResult = ProjectileUtil.m_150175_((Level)level, (Entity)entity, (Vec3)pointA, (Vec3)pointB, (AABB)entity.m_20191_().m_82400_(inflate), entityPredicate, (float)0.0f)) != null) {
            hitResult = entityHitResult;
        }
        return hitResult;
    }

    public static float lookAtSamePointX(float partialTicks, Entity viewer, Entity other) {
        double pRange = 20.0;
        Vec3 pointA = viewer.m_20299_(partialTicks);
        Vec3 pointB = pointA.m_82549_(viewer.m_20252_(partialTicks).m_82490_(pRange));
        HitResult hitResult = ArmoryUtil.getHitResult(viewer, pointA, pointB, 10.0, target -> {
            if (!target.m_5833_() && target.m_6084_() && target.m_6087_()) {
                return !viewer.m_20365_(target);
            }
            return false;
        });
        Vec3 eyePosition = other.m_146892_();
        double x = hitResult.m_82450_().f_82479_ - eyePosition.f_82479_;
        double y = hitResult.m_82450_().f_82480_ - eyePosition.f_82480_;
        double z = hitResult.m_82450_().f_82481_ - eyePosition.f_82481_;
        double v = Math.sqrt(x * x + z * z);
        return Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)y, (double)v) * 57.2957763671875))));
    }

    public static void addCooldownToList(Player player, List<Item> items, int ticks) {
        if (!player.m_150110_().f_35937_) {
            for (Item item : items) {
                player.m_36335_().m_41524_(item, ticks);
            }
        }
    }

    public static float frameTime(Level level) {
        return !level.f_46443_ ? 1.0f : Minecraft.m_91087_().m_91296_();
    }
}

