/*
 * Decompiled with CFR 0.152.
 */
package buzzydrones.content.entity;

import buzzydrones.content.entity.ai.EnterSourceGoal;
import buzzydrones.content.entity.ai.EnterTargetGoal;
import buzzydrones.content.entity.ai.FindIdleGoal;
import buzzydrones.content.entity.ai.FindItemsGoal;
import buzzydrones.content.entity.ai.FindSourceGoal;
import buzzydrones.content.entity.ai.FindTargetGoal;
import buzzydrones.content.entity.ai.FindTargetWithFilterGoal;
import buzzydrones.registry.BuzzyDronesEntities;
import buzzydrones.registry.BuzzyDronesItems;
import buzzydrones.utils.NbtHelper;
import net.minecraft.class_1160;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1331;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7;

public class DroneEntity
extends class_1314 {
    private static final class_2940<Integer> STATUS = class_2945.method_12791(DroneEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2394 BLUE_PARTICLES = new class_2390(new class_1160(0.0f, 0.84f, 0.89f), 1.0f);
    private static final class_2394 GREEN_PARTICLES = new class_2390(new class_1160(0.0f, 0.89f, 0.35f), 1.0f);
    private static final class_2394 ORANGE_PARTICLES = new class_2390(new class_1160(0.89f, 0.35f, 0.0f), 1.0f);
    private static final class_2394 RED_PARTICLES = new class_2390(new class_1160(0.89f, 0.0f, 0.09f), 1.0f);
    public static final int BASIC = 1;
    public static final int PICK_UP = 2;
    private class_1799 carrying = class_1799.field_8037;
    private int type;

    public DroneEntity(class_1299<? extends class_1314> type, class_1937 level) {
        super(type, level);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
    }

    public DroneEntity(class_1937 level, int type) {
        this((class_1299<? extends class_1314>)((class_1299)BuzzyDronesEntities.DRONE.get()), level);
        this.type = type;
        this.method_5959();
    }

    public DroneEntity(DroneEntity copy) {
        this(copy.field_6002, copy.type);
        this.carrying = copy.carrying;
        this.setStatus(copy.getStatus());
    }

    protected void method_5959() {
        if (this.type == 1) {
            this.field_6201.method_6277(1, (class_1352)new FindSourceGoal(this));
            this.field_6201.method_6277(2, (class_1352)new EnterSourceGoal(this));
            this.field_6201.method_6277(3, (class_1352)new FindTargetWithFilterGoal(this));
            this.field_6201.method_6277(4, (class_1352)new FindTargetGoal(this));
            this.field_6201.method_6277(5, (class_1352)new EnterTargetGoal(this));
            this.field_6201.method_6277(6, (class_1352)new FindIdleGoal(this));
        } else if (this.type == 2) {
            this.field_6201.method_6277(1, (class_1352)new FindItemsGoal(this));
            this.field_6201.method_6277(2, (class_1352)new FindTargetWithFilterGoal(this));
            this.field_6201.method_6277(3, (class_1352)new FindTargetGoal(this));
            this.field_6201.method_6277(4, (class_1352)new EnterTargetGoal(this));
            this.field_6201.method_6277(5, (class_1352)new FindIdleGoal(this));
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(STATUS, (Object)Status.ERROR.index);
    }

    public boolean method_5974(double d) {
        return false;
    }

    public boolean isCarryingItems() {
        return !this.carrying.method_7960();
    }

    public boolean pickUpItems(class_1799 itemStack) {
        if (!itemStack.method_7960() && this.carrying.method_7947() < 64) {
            if (this.carrying.method_7960()) {
                this.carrying = new class_1799((class_1935)itemStack.method_7909(), 1);
                itemStack.method_7934(1);
                return true;
            }
            if (this.carrying.method_7909().equals(itemStack.method_7909())) {
                this.carrying.method_7933(1);
                itemStack.method_7934(1);
                return true;
            }
        }
        return false;
    }

    public void pickUpAllItems(class_1799 itemStack) {
        if (!itemStack.method_7960() && this.carrying.method_7960()) {
            this.carrying = new class_1799((class_1935)itemStack.method_7909(), itemStack.method_7947());
            this.field_6002.method_43128(null, this.method_19538().method_10216(), this.method_19538().method_10214(), this.method_19538().method_10215(), class_3417.field_15197, class_3419.field_15254, 1.0f, 1.0f);
            itemStack.method_7939(0);
        }
    }

    public class_1799 getItemCarried() {
        return this.carrying;
    }

    public void setItemCarried(class_1799 itemStack) {
        this.carrying = itemStack;
    }

    public void decreaseItemCarriedCount() {
        this.carrying.method_7939(this.carrying.method_7947() - 1);
    }

    public boolean isFull() {
        return this.carrying.method_7947() == this.carrying.method_7909().method_7882();
    }

    public void setStatus(Status status) {
        this.field_6011.method_12778(STATUS, (Object)status.index);
    }

    public Status getStatus() {
        return Status.values()[(Integer)this.field_6011.method_12789(STATUS)];
    }

    public void method_5670() {
        super.method_5670();
        if (this.field_6002.field_9236) {
            this.field_6002.method_8406(this.getParticles(), this.method_19538().method_10216(), this.method_19538().method_10214() + 0.4, this.method_19538().method_10215(), 0.1, 0.1, 0.1);
        }
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        this.dropItemCarried(this.method_19538());
        if (!cause.method_5530() || this.method_16914()) {
            class_1799 item = new class_1799(this.type == 1 ? (class_1935)BuzzyDronesItems.DRONE.get() : (class_1935)BuzzyDronesItems.DRONE_PICK_UP.get());
            if (this.method_16914()) {
                item.method_7977(this.method_5797());
            }
            class_2248.method_9577((class_1937)this.field_6002, (class_2338)this.method_24515(), (class_1799)item);
        }
    }

    public void dropItemCarried(class_243 pos) {
        if (!this.carrying.method_7960() && !this.field_6002.field_9236) {
            this.field_6002.method_8649((class_1297)new class_1542(this.field_6002, pos.field_1352, pos.field_1351, pos.field_1350, this.carrying));
        }
    }

    public void dropItemCarried(class_2338 pos) {
        this.dropItemCarried(new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5));
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        this.writeInterestingData(compound);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.carrying = NbtHelper.loadSingleItem(compound, "Carrying");
        this.type = compound.method_10550("DroneType");
        this.method_5959();
    }

    public void writeInterestingData(class_2487 compound) {
        NbtHelper.saveSingleItem(compound, this.carrying, "Carrying");
        compound.method_10569("DroneType", this.type);
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return class_3417.field_14897;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15118;
    }

    public boolean method_5747(float f1, float f2, class_1282 source) {
        return false;
    }

    protected class_1408 method_5965(class_1937 level) {
        class_1407 flyingPathNavigation = new class_1407((class_1308)this, level);
        flyingPathNavigation.method_6332(false);
        flyingPathNavigation.method_6354(false);
        flyingPathNavigation.method_6332(true);
        return flyingPathNavigation;
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 3.0).method_26868(class_5134.field_23720, 0.8);
    }

    private class_2394 getParticles() {
        return switch (this.getStatus()) {
            case Status.WORKING -> BLUE_PARTICLES;
            case Status.IDLE -> GREEN_PARTICLES;
            case Status.WARNING -> ORANGE_PARTICLES;
            default -> RED_PARTICLES;
        };
    }

    public static enum Status {
        WORKING(0),
        IDLE(1),
        WARNING(2),
        ERROR(3);

        public int index;

        private Status(int index) {
            this.index = index;
        }
    }
}

