/*
 * Decompiled with CFR 0.152.
 */
package buzzydrones.content.blockentity;

import buzzydrones.content.block.AbstractStationBlock;
import buzzydrones.content.entity.DroneEntity;
import buzzydrones.registry.BuzzyDronesItems;
import buzzydrones.utils.NbtHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractStationBlockEntity
extends RandomizableContainerBlockEntity {
    protected NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    protected DroneData droneInStation;

    public AbstractStationBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.inventory = items;
    }

    public boolean isFree() {
        return this.droneInStation == null;
    }

    public void droneEnter(DroneEntity droneEntity) {
        if (this.isFree() && this.f_58857_ != null) {
            droneEntity.m_8127_();
            droneEntity.m_20153_();
            this.droneInStation = new DroneData(droneEntity);
            this.f_58857_.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_11695_, SoundSource.BLOCKS, 1.0f, 1.0f);
            droneEntity.m_146870_();
        }
    }

    public void droneExit() {
        BlockPos pos;
        if (this.f_58857_ != null && this.f_58857_.m_8055_(pos = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)AbstractStationBlock.FACING))).m_60795_()) {
            DroneEntity droneEntity = (DroneEntity)EntityType.m_20645_((CompoundTag)this.droneInStation.nbtData, (Level)this.f_58857_, entity -> entity);
            if (droneEntity != null) {
                droneEntity.setItemCarried(this.droneInStation.itemCarried);
                droneEntity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                this.f_58857_.m_7967_((Entity)droneEntity);
                this.f_58857_.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_11696_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.droneInStation = null;
        }
    }

    public void dropInventory() {
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (Container)this);
            if (this.droneInStation != null) {
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5, this.droneInStation.itemCarried));
                Containers.m_18992_((Level)this.f_58857_, (double)((double)this.m_58899_().m_123341_() + 0.5), (double)this.m_58899_().m_123342_(), (double)((double)this.m_58899_().m_123343_() + 0.5), (ItemStack)new ItemStack((ItemLike)BuzzyDronesItems.DRONE.get(), 1));
            }
        }
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public Component m_6820_() {
        return Component.m_237113_((String)"Drone Station");
    }

    public int getFullness() {
        int count = 0;
        for (ItemStack itemStack : this.inventory) {
            count += itemStack.m_41613_();
        }
        return count;
    }

    public double getDistance(BlockPos pos) {
        return this.m_58899_().m_123331_((Vec3i)pos);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("Drone")) {
            this.droneInStation = new DroneData(nbt.m_128469_("Drone"), NbtHelper.loadSingleItem(nbt, "DroneItem"));
        }
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.inventory);
        if (this.droneInStation != null) {
            compound.m_128365_("Drone", (Tag)this.droneInStation.nbtData);
            NbtHelper.saveSingleItem(compound, this.droneInStation.itemCarried, "DroneItem");
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, this.m_58903_(), this.m_5995_());
    }

    public CompoundTag m_5995_() {
        this.m_183515_(new CompoundTag());
        return new CompoundTag();
    }

    protected static class DroneData {
        public CompoundTag nbtData;
        public ItemStack itemCarried;

        public DroneData(DroneEntity entity) {
            this.nbtData = new CompoundTag();
            entity.m_20223_(this.nbtData);
            this.itemCarried = entity.getItemCarried();
        }

        public DroneData(CompoundTag nbtData, ItemStack item) {
            this.nbtData = nbtData;
            this.itemCarried = item;
        }
    }
}

