/*
 * Decompiled with CFR 0.152.
 */
package buzzydrones.content.entity;

import buzzydrones.content.entity.ai.EnterSourceGoal;
import buzzydrones.content.entity.ai.EnterTargetGoal;
import buzzydrones.content.entity.ai.FindIdleGoal;
import buzzydrones.content.entity.ai.FindItemsGoal;
import buzzydrones.content.entity.ai.FindSourceGoal;
import buzzydrones.content.entity.ai.FindTargetGoal;
import buzzydrones.content.entity.ai.FindTargetWithFilterGoal;
import buzzydrones.registry.BuzzyDronesEntities;
import buzzydrones.registry.BuzzyDronesItems;
import buzzydrones.utils.NbtHelper;
import com.mojang.math.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class DroneEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Integer> STATUS = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final ParticleOptions BLUE_PARTICLES = new DustParticleOptions(new Vector3f(0.0f, 0.84f, 0.89f), 1.0f);
    private static final ParticleOptions GREEN_PARTICLES = new DustParticleOptions(new Vector3f(0.0f, 0.89f, 0.35f), 1.0f);
    private static final ParticleOptions ORANGE_PARTICLES = new DustParticleOptions(new Vector3f(0.89f, 0.35f, 0.0f), 1.0f);
    private static final ParticleOptions RED_PARTICLES = new DustParticleOptions(new Vector3f(0.89f, 0.0f, 0.09f), 1.0f);
    public static final int BASIC = 1;
    public static final int PICK_UP = 2;
    private ItemStack carrying = ItemStack.f_41583_;
    private int type;

    public DroneEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public DroneEntity(Level level, int type) {
        this((EntityType<? extends PathfinderMob>)((EntityType)BuzzyDronesEntities.DRONE.get()), level);
        this.type = type;
        this.m_8099_();
    }

    public DroneEntity(DroneEntity copy) {
        this(copy.f_19853_, copy.type);
        this.carrying = copy.carrying;
        this.setStatus(copy.getStatus());
    }

    protected void m_8099_() {
        if (this.type == 1) {
            this.f_21345_.m_25352_(1, (Goal)new FindSourceGoal(this));
            this.f_21345_.m_25352_(2, (Goal)new EnterSourceGoal(this));
            this.f_21345_.m_25352_(3, (Goal)new FindTargetWithFilterGoal(this));
            this.f_21345_.m_25352_(4, (Goal)new FindTargetGoal(this));
            this.f_21345_.m_25352_(5, (Goal)new EnterTargetGoal(this));
            this.f_21345_.m_25352_(6, (Goal)new FindIdleGoal(this));
        } else if (this.type == 2) {
            this.f_21345_.m_25352_(1, (Goal)new FindItemsGoal(this));
            this.f_21345_.m_25352_(2, (Goal)new FindTargetWithFilterGoal(this));
            this.f_21345_.m_25352_(3, (Goal)new FindTargetGoal(this));
            this.f_21345_.m_25352_(4, (Goal)new EnterTargetGoal(this));
            this.f_21345_.m_25352_(5, (Goal)new FindIdleGoal(this));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATUS, (Object)Status.ERROR.index);
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public boolean isCarryingItems() {
        return !this.carrying.m_41619_();
    }

    public boolean pickUpItems(ItemStack itemStack) {
        if (!itemStack.m_41619_() && this.carrying.m_41613_() < 64) {
            if (this.carrying.m_41619_()) {
                this.carrying = new ItemStack((ItemLike)itemStack.m_41720_(), 1);
                itemStack.m_41774_(1);
                return true;
            }
            if (this.carrying.m_41720_().equals(itemStack.m_41720_())) {
                this.carrying.m_41769_(1);
                itemStack.m_41774_(1);
                return true;
            }
        }
        return false;
    }

    public void pickUpAllItems(ItemStack itemStack) {
        if (!itemStack.m_41619_() && this.carrying.m_41619_()) {
            this.carrying = new ItemStack((ItemLike)itemStack.m_41720_(), itemStack.m_41613_());
            this.f_19853_.m_6263_(null, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            itemStack.m_41764_(0);
        }
    }

    public ItemStack getItemCarried() {
        return this.carrying;
    }

    public void setItemCarried(ItemStack itemStack) {
        this.carrying = itemStack;
    }

    public void decreaseItemCarriedCount() {
        this.carrying.m_41764_(this.carrying.m_41613_() - 1);
    }

    public boolean isFull() {
        return this.carrying.m_41613_() == this.carrying.m_41720_().m_41459_();
    }

    public void setStatus(Status status) {
        this.f_19804_.m_135381_(STATUS, (Object)status.index);
    }

    public Status getStatus() {
        return Status.values()[(Integer)this.f_19804_.m_135370_(STATUS)];
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_(this.getParticles(), this.m_20182_().m_7096_(), this.m_20182_().m_7098_() + 0.4, this.m_20182_().m_7094_(), 0.1, 0.1, 0.1);
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.dropItemCarried(this.m_20182_());
        if (!cause.m_19390_() || this.m_8077_()) {
            ItemStack item = new ItemStack(this.type == 1 ? (ItemLike)BuzzyDronesItems.DRONE.get() : (ItemLike)BuzzyDronesItems.DRONE_PICK_UP.get());
            if (this.m_8077_()) {
                item.m_41714_(this.m_7770_());
            }
            Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_20183_(), (ItemStack)item);
        }
    }

    public void dropItemCarried(Vec3 pos) {
        if (!this.carrying.m_41619_() && !this.f_19853_.f_46443_) {
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, pos.f_82479_, pos.f_82480_, pos.f_82481_, this.carrying));
        }
    }

    public void dropItemCarried(BlockPos pos) {
        this.dropItemCarried(new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.writeInterestingData(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.carrying = NbtHelper.loadSingleItem(compound, "Carrying");
        this.type = compound.m_128451_("DroneType");
        this.m_8099_();
    }

    public void writeInterestingData(CompoundTag compound) {
        NbtHelper.saveSingleItem(compound, this.carrying, "Carrying");
        compound.m_128405_("DroneType", this.type);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11683_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    public boolean m_142535_(float f1, float f2, DamageSource source) {
        return false;
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, level);
        flyingPathNavigation.m_26440_(false);
        flyingPathNavigation.m_7008_(false);
        flyingPathNavigation.m_26440_(true);
        return flyingPathNavigation;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22280_, 0.8);
    }

    private ParticleOptions getParticles() {
        return switch (this.getStatus()) {
            case Status.WORKING -> BLUE_PARTICLES;
            case Status.IDLE -> GREEN_PARTICLES;
            case Status.WARNING -> ORANGE_PARTICLES;
            default -> RED_PARTICLES;
        };
    }

    public static enum Status {
        WORKING(0),
        IDLE(1),
        WARNING(2),
        ERROR(3);

        public int index;

        private Status(int index) {
            this.index = index;
        }
    }
}

