/*
 * Decompiled with CFR 0.152.
 */
package buzzydrones.content.entity.ai;

import buzzydrones.content.entity.DroneEntity;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.AABB;

public class FindItemsGoal
extends Goal {
    private final DroneEntity droneEntity;

    public FindItemsGoal(DroneEntity droneEntity) {
        this.droneEntity = droneEntity;
    }

    public boolean m_8036_() {
        return !this.droneEntity.isCarryingItems() && this.droneEntity.m_21573_().m_26571_();
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
        this.lookForItems();
        this.pickUpItems();
    }

    private void pickUpItems() {
        this.getClosestItem(1.5).ifPresent(item -> this.droneEntity.pickUpAllItems(item.m_32055_()));
    }

    private void lookForItems() {
        this.getClosestItem(15.0).ifPresentOrElse(item -> {
            this.droneEntity.m_21573_().m_5624_((Entity)item, 1.0);
            this.droneEntity.setStatus(DroneEntity.Status.WORKING);
        }, () -> this.droneEntity.setStatus(DroneEntity.Status.IDLE));
    }

    private Optional<ItemEntity> getClosestItem(double range) {
        AABB box = this.droneEntity.m_20191_().m_82400_(range);
        return this.droneEntity.f_19853_.m_45976_(ItemEntity.class, box).stream().sorted(Comparator.comparingDouble(item -> item.m_20183_().m_123331_((Vec3i)this.droneEntity.m_20183_()))).findFirst();
    }
}

