/*
 * Decompiled with CFR 0.152.
 */
package buzzydrones.content.entity.ai;

import buzzydrones.content.blockentity.AbstractStationBlockEntity;
import buzzydrones.content.blockentity.SourceStationBlockEntity;
import buzzydrones.content.entity.DroneEntity;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;

public class FindSourceGoal
extends Goal {
    private final DroneEntity droneEntity;

    public FindSourceGoal(DroneEntity droneEntity) {
        this.droneEntity = droneEntity;
    }

    public boolean m_8036_() {
        return this.droneEntity.m_21573_().m_26571_() && !this.droneEntity.isCarryingItems();
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
        List<SourceStationBlockEntity> list = this.getNearbySources();
        if (!list.isEmpty()) {
            for (SourceStationBlockEntity blockEntity : list) {
                if (!this.sourceIsValid(blockEntity)) continue;
                this.goTo(blockEntity.m_58899_());
                return;
            }
            this.droneEntity.setStatus(DroneEntity.Status.IDLE);
        } else {
            this.droneEntity.setStatus(DroneEntity.Status.ERROR);
        }
    }

    private List<SourceStationBlockEntity> getNearbySources() {
        BlockPos dronePos = this.droneEntity.m_20183_();
        return BlockPos.m_121990_((BlockPos)dronePos.m_7918_(-15, -15, -15), (BlockPos)dronePos.m_7918_(15, 15, 15)).map(pos -> this.droneEntity.f_19853_.m_7702_(pos)).filter(blockEntity -> blockEntity instanceof SourceStationBlockEntity).map(blockEntity -> (SourceStationBlockEntity)((Object)blockEntity)).sorted(Comparator.comparingInt(AbstractStationBlockEntity::getFullness).reversed()).collect(Collectors.toList());
    }

    private boolean sourceIsValid(SourceStationBlockEntity blockEntity) {
        return blockEntity.isFree() && !blockEntity.m_7983_();
    }

    private void goTo(BlockPos pos) {
        PathNavigation navigation = this.droneEntity.m_21573_();
        navigation.m_26536_(navigation.m_7864_(pos, 1), 1.0);
        this.droneEntity.setStatus(DroneEntity.Status.WORKING);
    }
}

