/*
 * Decompiled with CFR 0.152.
 */
package buzzydrones.content.entity.ai;

import buzzydrones.content.blockentity.TargetStationBlockEntity;
import buzzydrones.content.entity.DroneEntity;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;

public class FindTargetGoal
extends Goal {
    private final DroneEntity droneEntity;

    public FindTargetGoal(DroneEntity droneEntity) {
        this.droneEntity = droneEntity;
    }

    public boolean m_8036_() {
        return this.droneEntity.m_21573_().m_26571_() && this.droneEntity.isCarryingItems();
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
        List<TargetStationBlockEntity> list = this.getNearbyTargets();
        if (!list.isEmpty()) {
            for (TargetStationBlockEntity blockEntity : list) {
                if (!this.targetIsValid(blockEntity)) continue;
                this.goTo(blockEntity.m_58899_());
                return;
            }
            this.droneEntity.setStatus(DroneEntity.Status.WARNING);
        } else {
            this.droneEntity.setStatus(DroneEntity.Status.ERROR);
        }
    }

    private List<TargetStationBlockEntity> getNearbyTargets() {
        BlockPos dronePos = this.droneEntity.m_20183_();
        return BlockPos.m_121990_((BlockPos)dronePos.m_7918_(-15, -15, -15), (BlockPos)dronePos.m_7918_(15, 15, 15)).map(arg_0 -> ((Level)this.droneEntity.f_19853_).m_7702_(arg_0)).filter(TargetStationBlockEntity.class::isInstance).map(TargetStationBlockEntity.class::cast).sorted(Comparator.comparingDouble(blockEntity -> blockEntity.getDistance(this.droneEntity.m_20183_()))).toList();
    }

    private boolean targetIsValid(TargetStationBlockEntity blockEntity) {
        return blockEntity.isFree() && !blockEntity.hasFilter() && blockEntity.hasRoomFor(this.droneEntity.getItemCarried());
    }

    private void goTo(BlockPos pos) {
        PathNavigation navigation = this.droneEntity.m_21573_();
        navigation.m_26536_(navigation.m_7864_(pos, 1), 1.0);
        this.droneEntity.setStatus(DroneEntity.Status.WORKING);
    }
}

