/*
 * Decompiled with CFR 0.152.
 */
package buzzydrones.content.renderer;

import buzzydrones.content.entity.DroneEntity;
import buzzydrones.content.renderer.DroneModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;

public class DroneRenderer
extends MobRenderer<DroneEntity, DroneModel<DroneEntity>> {
    private static final ResourceLocation droneBlueTexture = new ResourceLocation("buzzydrones", "textures/entity/drone_blue.png");
    private static final ResourceLocation droneGreenTexture = new ResourceLocation("buzzydrones", "textures/entity/drone_green.png");
    private static final ResourceLocation droneOrangeTexture = new ResourceLocation("buzzydrones", "textures/entity/drone_orange.png");
    private static final ResourceLocation droneRedTexture = new ResourceLocation("buzzydrones", "textures/entity/drone_red.png");

    public DroneRenderer(EntityRendererProvider.Context renderProvider) {
        super(renderProvider, new DroneModel(), 0.4f);
    }

    public ResourceLocation getTextureLocation(DroneEntity entity) {
        return switch (entity.getStatus()) {
            case DroneEntity.Status.WORKING -> droneBlueTexture;
            case DroneEntity.Status.IDLE -> droneGreenTexture;
            case DroneEntity.Status.WARNING -> droneOrangeTexture;
            default -> droneRedTexture;
        };
    }
}

