/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.coldsnaphorde.Entities.Mobs.Behaviors;

import com.cartoonishvillain.coldsnaphorde.Entities.Mobs.BaseMob.GenericHordeMember;
import com.cartoonishvillain.coldsnaphorde.Register;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class GifterSurprise {
    World world;
    Entity exploder;
    double Entx;
    double Enty;
    double Entz;
    float radius;
    Vector3d position;
    DamageSource damageSource;
    ArrayList<BlockPos> blockPosArrayList = new ArrayList();
    int hordeVariant;
    ArrayList<Entity> effectedEntities = new ArrayList();

    public GifterSurprise(World world, @Nullable Entity exploder, double x, double y, double z, float radius) {
        this.world = world;
        this.Entx = x;
        this.Enty = y;
        this.Entz = z;
        this.exploder = exploder;
        this.radius = radius;
        this.damageSource = DamageSource.func_188405_b((LivingEntity)((LivingEntity)exploder));
        this.position = new Vector3d(x, y, z);
        if (exploder instanceof GenericHordeMember) {
            GenericHordeMember genericHordeMember = (GenericHordeMember)exploder;
            this.hordeVariant = genericHordeMember.getHordeVariant();
        }
    }

    public void StageDetonation() {
        int x = (int)(-this.radius) - 1;
        while ((float)x <= this.radius) {
            int y = (int)(-this.radius) - 1;
            while ((float)y <= this.radius) {
                int z = (int)(-this.radius) - 1;
                while ((float)z <= this.radius) {
                    BlockPos blockPos = new BlockPos(this.Entx + (double)x, this.Enty + (double)y, this.Entz + (double)z);
                    this.blockPosArrayList.add(blockPos);
                    ArrayList entities = (ArrayList)this.world.func_175674_a(this.exploder, new AxisAlignedBB(this.Entx + (double)x + 2.0, this.Enty + (double)y + 2.0, this.Entz + (double)z + 2.0, this.Entx + (double)x - 2.0, this.Enty + (double)y - 2.0, this.Entz + (double)z - 2.0), null);
                    for (Entity entity : entities) {
                        if (this.effectedEntities.contains(entity)) continue;
                        this.effectedEntities.add(entity);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public void DetonateTest() {
        for (BlockPos blockPos : this.blockPosArrayList) {
            this.world.func_175656_a(blockPos, Blocks.field_150355_j.func_176223_P());
        }
    }

    public void DetonateBlockDamage() {
        block9: {
            if (!ForgeEventFactory.getMobGriefingEvent((World)this.exploder.field_70170_p, (Entity)this.exploder) || this.hordeVariant == 2) break block9;
            if (this.hordeVariant != 1) {
                for (BlockPos blockPos : this.blockPosArrayList) {
                    if ((this.world.func_180495_p(blockPos).equals(Blocks.field_150350_a.func_176223_P()) || this.world.func_180495_p(blockPos).equals(Blocks.field_150349_c.func_176223_P())) && !this.world.func_180495_p(blockPos.func_177977_b()).equals(Blocks.field_150350_a.func_176223_P()) && !this.world.func_180495_p(blockPos.func_177977_b()).equals(Blocks.field_150349_c.func_176223_P())) {
                        this.world.func_175656_a(blockPos, Blocks.field_150433_aE.func_176223_P());
                        continue;
                    }
                    if (this.world.func_180495_p(blockPos).equals(Blocks.field_150355_j.func_176223_P())) {
                        this.world.func_175656_a(blockPos, Blocks.field_150432_aD.func_176223_P());
                        continue;
                    }
                    if (this.world.func_180495_p(blockPos).equals(Blocks.field_150353_l.func_176223_P())) {
                        this.world.func_175656_a(blockPos, Blocks.field_150343_Z.func_176223_P());
                        continue;
                    }
                    if (this.world.func_180495_p(blockPos).func_177230_c().equals(Blocks.field_150458_ak)) {
                        this.world.func_175656_a(blockPos, Blocks.field_150346_d.func_176223_P());
                        continue;
                    }
                    if (this.world.func_180495_p(blockPos).equals(Blocks.field_150432_aD.func_176223_P())) {
                        this.world.func_175656_a(blockPos, Blocks.field_150403_cj.func_176223_P());
                        continue;
                    }
                    if (!this.world.func_180495_p(blockPos).func_177230_c().equals(Blocks.field_150480_ab)) continue;
                    this.world.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
                }
            } else {
                for (BlockPos blockPos : this.blockPosArrayList) {
                    BlockState blockstate;
                    if (!this.world.func_180495_p(blockPos).equals(Blocks.field_150350_a.func_176223_P()) || !(blockstate = ((Block)Register.SLUSH.get()).func_176223_P()).func_196955_c((IWorldReader)this.world, blockPos)) continue;
                    this.world.func_175656_a(blockPos, blockstate);
                }
            }
        }
    }

    public void DetonateLivingHarm() {
        Vector3d vec3 = new Vector3d(this.Entx, this.Enty, this.Entz);
        for (Entity entity : this.effectedEntities) {
            double distanceFactor;
            if (!(entity instanceof LivingEntity)) continue;
            float DamageRadius = this.radius * 1.5f;
            if (entity.func_180427_aV() || !((distanceFactor = Math.sqrt(entity.func_195048_a(vec3)) / (double)DamageRadius) <= 1.0)) continue;
            double directionalx = entity.func_226277_ct_() - this.Entx;
            double directionaly = entity.func_226278_cu_() - this.Enty;
            double directionalz = entity.func_226281_cx_() - this.Entz;
            double percentSeen = Explosion.func_222259_a((Vector3d)vec3, (Entity)entity);
            double damage = (1.0 - distanceFactor) * percentSeen;
            if (this.hordeVariant != 2) {
                double knockback = damage;
                if (entity instanceof LivingEntity) {
                    knockback = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)damage);
                }
                entity.func_213317_d(entity.func_213322_ci().func_72441_c(directionalx * knockback, directionaly * knockback, directionalz * knockback));
                if (this.hordeVariant == 3) {
                    GenericHordeMember.Infection((LivingEntity)entity);
                }
            } else {
                ((LivingEntity)entity).func_213373_a(entity.func_226277_ct_() + (double)entity.field_70170_p.field_73012_v.nextInt(20) - 10.0, entity.func_226278_cu_() + (double)entity.field_70170_p.field_73012_v.nextInt(20) - 10.0, entity.func_226281_cx_() + (double)entity.field_70170_p.field_73012_v.nextInt(20) - 10.0, true);
            }
            entity.func_70097_a(this.damageSource, (float)((int)((damage * damage + damage) / 2.0 * 3.0 * (double)DamageRadius + 1.0)));
        }
    }
}

