/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.coldsnaphorde.Events;

import com.cartoonishvillain.coldsnaphorde.Capabilities.WorldCapability;
import com.cartoonishvillain.coldsnaphorde.ColdSnapHorde;
import com.cartoonishvillain.coldsnaphorde.Entities.Mobs.BaseMob.ColdSnapBrawler;
import com.cartoonishvillain.coldsnaphorde.Entities.Mobs.BaseMob.ColdSnapGifter;
import com.cartoonishvillain.coldsnaphorde.Entities.Mobs.BaseMob.ColdSnapGunner;
import com.cartoonishvillain.coldsnaphorde.Entities.Mobs.BaseMob.ColdSnapSnowballer;
import com.cartoonishvillain.coldsnaphorde.Entities.Mobs.BaseMob.ColdSnapStabber;
import com.cartoonishvillain.coldsnaphorde.Entities.Mobs.BaseMob.ColdSnapZapper;
import com.cartoonishvillain.coldsnaphorde.Entities.Mobs.BaseMob.GenericHordeMember;
import com.cartoonishvillain.coldsnaphorde.Entities.Mobs.HordeVariantManager.EndHorde;
import com.cartoonishvillain.coldsnaphorde.Entities.Mobs.HordeVariantManager.NetherHorde;
import com.cartoonishvillain.coldsnaphorde.Entities.Mobs.HordeVariantManager.PlagueHorde;
import com.cartoonishvillain.coldsnaphorde.Entities.Mobs.HordeVariantManager.StandardHorde;
import com.cartoonishvillain.coldsnaphorde.Register;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;

public class Horde {
    private Optional<BlockPos> hordeSpawn = Optional.empty();
    private ServerWorld world;
    private BlockPos center;
    private Boolean hordeActive = false;
    private MinecraftServer server;
    private float Alive = 0.0f;
    private float initAlive = 0.0f;
    private float Active = 0.0f;
    private int updateCenter = 0;
    private ServerPlayerEntity serverPlayer;
    private ArrayList<ServerPlayerEntity> players = new ArrayList();
    private ArrayList<GenericHordeMember> activeHordeMembers = new ArrayList();
    private final ServerBossInfo bossInfo = new ServerBossInfo((ITextComponent)new StringTextComponent("Cold Snap Horde").func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.BOLD}), BossInfo.Color.BLUE, BossInfo.Overlay.NOTCHED_10);

    public Horde(MinecraftServer server) {
        this.server = server;
        for (ServerWorld serverWorld : server.func_212370_w()) {
            String string = serverWorld.func_234923_W_().toString();
        }
    }

    public void Stop() {
        this.bossInfo.func_186758_d(false);
        this.bossInfo.func_201360_b();
        this.hordeActive = false;
        this.Alive = 0.0f;
        this.initAlive = 0.0f;
        this.Active = 0.0f;
        this.serverPlayer = null;
        this.activeHordeMembers.clear();
        this.center = null;
        this.players.clear();
        this.world.getCapability(WorldCapability.INSTANCE).ifPresent(h -> h.setCooldownTicks(ColdSnapHorde.sconfig.GLOBALHORDECOOLDOWN.get() * 20));
    }

    public Boolean getHordeActive() {
        return this.hordeActive;
    }

    public void SetUpHorde(ServerPlayerEntity serverPlayerEntity) {
        this.world = serverPlayerEntity.func_71121_q();
        this.bossInfo.func_186743_c(true);
        if (serverPlayerEntity.field_70170_p.func_234923_W_().toString().contains("end")) {
            this.bossInfo.func_186745_a(BossInfo.Color.PURPLE);
            this.bossInfo.func_186739_a((ITextComponent)new StringTextComponent("Cold Snap Horde").func_240701_a_(new TextFormatting[]{TextFormatting.DARK_PURPLE, TextFormatting.BOLD}));
        } else if (serverPlayerEntity.field_70170_p.func_234923_W_().toString().contains("nether")) {
            this.bossInfo.func_186745_a(BossInfo.Color.RED);
            this.bossInfo.func_186739_a((ITextComponent)new StringTextComponent("Cold Snap Horde").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD}));
        } else {
            this.bossInfo.func_186745_a(BossInfo.Color.BLUE);
        }
        if (serverPlayerEntity.field_70170_p.func_234923_W_().equals(this.world.func_234923_W_())) {
            this.serverPlayer = serverPlayerEntity;
            this.hordeActive = true;
            switch (this.world.func_175659_aa()) {
                case EASY: {
                    this.Alive = ColdSnapHorde.sconfig.ALIVEEASY.get().intValue();
                    this.initAlive = ColdSnapHorde.sconfig.ALIVEEASY.get().intValue();
                    break;
                }
                case NORMAL: {
                    this.Alive = ColdSnapHorde.sconfig.ALIVENORMAL.get().intValue();
                    this.initAlive = ColdSnapHorde.sconfig.ALIVENORMAL.get().intValue();
                    break;
                }
                case HARD: {
                    this.Alive = ColdSnapHorde.sconfig.ALIVEHARD.get().intValue();
                    this.initAlive = ColdSnapHorde.sconfig.ALIVEHARD.get().intValue();
                }
            }
            this.center = serverPlayerEntity.func_233580_cy_();
            this.world.getCapability(WorldCapability.INSTANCE).ifPresent(h -> h.setCooldownTicks(-1));
        }
    }

    private boolean checkIfPlayerIsStillValid(ServerPlayerEntity serverPlayer) {
        return serverPlayer.func_110143_aJ() != 0.0f;
    }

    public void tick() {
        if (this.hordeActive.booleanValue()) {
            if (this.Alive > 0.0f) {
                if (this.serverPlayer.field_70170_p.func_230315_m_().equals(this.world.func_230315_m_()) && this.checkIfPlayerIsStillValid(this.serverPlayer) && !this.serverPlayer.func_184850_K()) {
                    boolean flag = this.hordeActive;
                    if (this.world.func_175659_aa() == Difficulty.PEACEFUL) {
                        this.Stop();
                        return;
                    }
                    if (this.Active != (float)this.activeHordeMembers.size()) {
                        this.Active = this.activeHordeMembers.size();
                    }
                    this.bossInfo.func_186758_d(true);
                    if (this.Active < (float)ColdSnapHorde.sconfig.HORDESIZE.get().intValue()) {
                        this.hordeSpawn = this.getValidSpawn(2);
                        if (!this.hordeSpawn.equals(Optional.empty()) && this.hordeSpawn.isPresent()) {
                            this.spawnSnowman(this.hordeSpawn.get());
                        }
                    }
                    if (this.updateCenter == 0) {
                        this.center = this.serverPlayer.func_233580_cy_();
                        this.updateCenter = ColdSnapHorde.sconfig.UPDATETICK.get();
                        if (!this.world.func_234923_W_().toString().contains("nether") && !this.world.func_234923_W_().toString().contains("end")) {
                            if (this.world.func_226691_t_(this.center).getRegistryName().toString().contains("swamp")) {
                                this.bossInfo.func_186745_a(BossInfo.Color.GREEN);
                                this.bossInfo.func_186739_a((ITextComponent)new StringTextComponent("Cold Snap Horde").func_240701_a_(new TextFormatting[]{TextFormatting.GREEN, TextFormatting.BOLD}));
                            } else {
                                this.bossInfo.func_186745_a(BossInfo.Color.BLUE);
                                this.bossInfo.func_186739_a((ITextComponent)new StringTextComponent("Cold Snap Horde").func_240701_a_(new TextFormatting[]{TextFormatting.AQUA, TextFormatting.BOLD}));
                            }
                        }
                        this.updatePlayers();
                        this.updateHorde();
                    } else {
                        --this.updateCenter;
                    }
                    this.bossInfo.func_186735_a(MathHelper.func_76131_a((float)(this.Alive / this.initAlive), (float)0.0f, (float)1.0f));
                } else {
                    this.updatePlayers();
                    if (this.players.size() == 0) {
                        this.Stop();
                    } else {
                        this.bossInfo.func_186761_b(this.serverPlayer);
                        this.serverPlayer = this.players.get(0);
                        this.players.remove(0);
                    }
                }
            } else {
                this.Stop();
            }
        }
    }

    private void updatePlayers() {
        for (ServerPlayerEntity serverPlayer : this.server.func_184103_al().func_181057_v()) {
            if (this.serverPlayer == serverPlayer) {
                this.bossInfo.func_186760_a(serverPlayer);
                continue;
            }
            if (serverPlayer.field_70170_p.func_230315_m_().equals(this.world.func_230315_m_()) && this.checkIfPlayerIsStillValid(serverPlayer)) {
                double distance = MathHelper.func_76133_a((double)serverPlayer.func_70092_e((double)this.center.func_177958_n(), (double)this.center.func_177956_o(), (double)this.center.func_177952_p()));
                if (distance < 64.0) {
                    if (this.players.contains(serverPlayer)) continue;
                    this.bossInfo.func_186760_a(serverPlayer);
                    this.players.add(serverPlayer);
                    continue;
                }
                this.bossInfo.func_186761_b(serverPlayer);
                this.players.remove(serverPlayer);
                continue;
            }
            this.bossInfo.func_186761_b(serverPlayer);
            this.players.remove(serverPlayer);
        }
    }

    private void updateHorde() {
        ArrayList<GenericHordeMember> removals = new ArrayList<GenericHordeMember>();
        ArrayList<GenericHordeMember> additions = new ArrayList<GenericHordeMember>();
        for (GenericHordeMember hordeMember : this.activeHordeMembers) {
            if (!hordeMember.isHordeMember()) {
                removals.add(hordeMember);
                this.UnitLost();
            }
            if (hordeMember.func_233643_dh_()) {
                removals.add(hordeMember);
                this.UnitDown();
            }
            hordeMember.updateHordeMember(this.center);
            BlockPos hordeTarget = hordeMember.getLocTarget();
            if (MathHelper.func_76133_a((double)hordeMember.func_70092_e(hordeTarget.func_177958_n(), hordeTarget.func_177956_o(), hordeTarget.func_177952_p())) > 64.0f) {
                hordeMember.cancelHordeMembership();
                removals.add(hordeMember);
                this.UnitLost();
            }
            this.inviteNearbySnowmentoHorde(hordeMember, additions);
        }
        for (GenericHordeMember removal : removals) {
            this.activeHordeMembers.remove((Object)removal);
        }
        this.activeHordeMembers.addAll(additions);
        removals.clear();
    }

    private void inviteNearbySnowmentoHorde(GenericHordeMember Member, ArrayList<GenericHordeMember> additions) {
        List list = Member.field_70170_p.func_217357_a(GenericHordeMember.class, Member.func_174813_aQ().func_186662_g(8.0));
        for (GenericHordeMember snowman : list) {
            if (Member.getLocTarget() == null || snowman.isHordeMember() || snowman.func_70638_az() != null) continue;
            snowman.toggleHordeMember(Member.getLocTarget());
            additions.add(snowman);
            this.InviteUnit();
        }
    }

    private Optional<BlockPos> getValidSpawn(int var) {
        for (int i = 0; i < 3; ++i) {
            BlockPos blockPos = this.findRandomSpawnPos(var, 1);
            if (blockPos == null) continue;
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }

    @Nullable
    private BlockPos findRandomSpawnPos(int logicvar, int loopvar) {
        int i = logicvar == 0 ? 2 : 2 - logicvar;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        for (int a = 0; a < loopvar; ++a) {
            float f = this.world.field_73012_v.nextFloat() * ((float)Math.PI * 2);
            double DISTANCE = -1.0;
            int j = Integer.MAX_VALUE;
            int l = Integer.MAX_VALUE;
            while (!(DISTANCE != -1.0 && DISTANCE > 450.0 && DISTANCE < 1250.0 && this.biomeCheck((World)this.world, new BlockPos(j, this.center.func_177956_o(), l)))) {
                j = this.randFinder(this.center.func_177958_n(), f, i);
                l = this.randFinder(this.center.func_177952_p(), f, i);
                DISTANCE = this.center.func_177951_i((Vector3i)new BlockPos(j, this.center.func_177956_o(), l));
            }
            int k = this.findYPosition(j, l);
            if (k == -1) continue;
            blockPos.func_181079_c(j, k, l);
            if (!this.world.isAreaLoaded((BlockPos)blockPos, 20)) continue;
            return blockPos;
        }
        return null;
    }

    private int findYPosition(int j, int l) {
        BlockState blockstate;
        int i;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        for (i = this.center.func_177956_o(); i < this.center.func_177956_o() + 25; ++i) {
            blockPos.func_181079_c(j, i - 1, l);
            blockstate = this.world.func_180495_p((BlockPos)blockPos);
            if (!blockstate.func_200132_m() || blockstate.func_177230_c() instanceof LeavesBlock || blockstate.equals(Blocks.field_150357_h.func_176223_P())) continue;
            blockPos.func_181079_c(j, i, l);
            blockstate = this.world.func_180495_p((BlockPos)blockPos);
            if (!blockstate.equals(Blocks.field_150350_a.func_176223_P())) continue;
            blockPos.func_181079_c(j, i + 1, l);
            blockstate = this.world.func_180495_p((BlockPos)blockPos);
            if (!blockstate.equals(Blocks.field_150350_a.func_176223_P())) continue;
            return i;
        }
        for (i = this.center.func_177956_o(); i > this.center.func_177956_o() - 15; --i) {
            blockPos.func_181079_c(j, i - 1, l);
            blockstate = this.world.func_180495_p((BlockPos)blockPos);
            if (!blockstate.func_200132_m() || blockstate.func_177230_c() instanceof LeavesBlock || blockstate.equals(Blocks.field_150357_h.func_176223_P())) continue;
            blockPos.func_181079_c(j, i, l);
            blockstate = this.world.func_180495_p((BlockPos)blockPos);
            if (!blockstate.equals(Blocks.field_150350_a.func_176223_P())) continue;
            blockPos.func_181079_c(j, i + 1, l);
            blockstate = this.world.func_180495_p((BlockPos)blockPos);
            if (!blockstate.equals(Blocks.field_150350_a.func_176223_P())) continue;
            return i;
        }
        return -1;
    }

    private int randFinder(int centercoord, float f, int i) {
        return centercoord + (this.world.field_73012_v.nextInt(50) - 25);
    }

    public void SpawnUnit() {
        this.Active += 1.0f;
    }

    public void InviteUnit() {
        this.Active += 1.0f;
    }

    public void UnitDown() {
        this.Active -= 1.0f;
        this.Alive -= 1.0f;
    }

    public void UnitLost() {
        this.Active -= 1.0f;
    }

    private boolean biomeCheck(World world, BlockPos pos) {
        if (world.func_226691_t_(pos).getRegistryName().toString().contains("swamp")) {
            return true;
        }
        if (!world.func_234923_W_().toString().contains("over")) {
            return true;
        }
        int protlvl = ColdSnapHorde.cconfig.HEATPROT.get();
        float temp = world.func_226691_t_(pos).func_242445_k();
        int code = -1;
        if ((double)temp < 0.3) {
            code = 0;
        } else if ((double)temp >= 0.3 && (double)temp < 0.9) {
            code = 1;
        } else if ((double)temp >= 0.9 && (double)temp < 1.5) {
            code = 2;
        } else if ((double)temp >= 1.5) {
            code = 3;
        }
        return code <= protlvl;
    }

    private boolean trueBiomeCheck(World world, BlockPos pos) {
        int protlvl = ColdSnapHorde.cconfig.HEATPROT.get();
        float temp = world.func_226691_t_(pos).func_242445_k();
        int code = -1;
        if ((double)temp < 0.3) {
            code = 0;
        } else if ((double)temp >= 0.3 && (double)temp < 0.9) {
            code = 1;
        } else if ((double)temp >= 0.9 && (double)temp < 1.5) {
            code = 2;
        } else if ((double)temp >= 1.5) {
            code = 3;
        }
        return code <= protlvl;
    }

    private void spawnSnowman(BlockPos pos) {
        ArrayList<Integer> SpawnWeights = new ArrayList<Integer>();
        SpawnWeights.add(ColdSnapHorde.cconfig.GUNNER.get());
        SpawnWeights.add(ColdSnapHorde.cconfig.STABBER.get());
        SpawnWeights.add(ColdSnapHorde.cconfig.SNOWBALLER.get());
        SpawnWeights.add(ColdSnapHorde.cconfig.ZAPPER.get());
        SpawnWeights.add(ColdSnapHorde.cconfig.GIFTER.get());
        SpawnWeights.add(ColdSnapHorde.cconfig.BRAWLER.get());
        int combined = 0;
        for (Integer weight : SpawnWeights) {
            combined += weight.intValue();
        }
        Random random = new Random();
        int rng = random.nextInt(combined);
        int selected = -1;
        int counter = 0;
        for (Integer weights : SpawnWeights) {
            if (rng - weights <= 0) {
                selected = counter;
                break;
            }
            ++counter;
            rng -= weights.intValue();
        }
        switch (selected) {
            case 0: {
                ColdSnapGunner coldSnapGunner = this.gunnerSpawnRules((World)this.world, pos);
                coldSnapGunner.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                coldSnapGunner.toggleHordeMember(this.center);
                this.world.func_217376_c((Entity)coldSnapGunner);
                this.activeHordeMembers.add(coldSnapGunner);
                break;
            }
            case 1: {
                ColdSnapStabber coldSnapStabber = this.stabberSpawnRules((World)this.world, pos);
                coldSnapStabber.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                coldSnapStabber.toggleHordeMember(this.center);
                this.world.func_217376_c((Entity)coldSnapStabber);
                this.activeHordeMembers.add(coldSnapStabber);
                break;
            }
            case 2: {
                ColdSnapSnowballer coldSnapSnowballer = this.snowballerSpawnRules((World)this.world, pos);
                coldSnapSnowballer.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                coldSnapSnowballer.toggleHordeMember(this.center);
                this.world.func_217376_c((Entity)coldSnapSnowballer);
                this.activeHordeMembers.add(coldSnapSnowballer);
                break;
            }
            case 3: {
                ColdSnapZapper coldSnapZapper = this.zapperSpawnRules((World)this.world, pos);
                coldSnapZapper.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                coldSnapZapper.toggleHordeMember(this.center);
                this.world.func_217376_c((Entity)coldSnapZapper);
                this.activeHordeMembers.add(coldSnapZapper);
                break;
            }
            case 4: {
                ColdSnapGifter coldSnapGifter = this.gifterSpawnRules((World)this.world, pos);
                coldSnapGifter.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                coldSnapGifter.toggleHordeMember(this.center);
                this.world.func_217376_c((Entity)coldSnapGifter);
                this.activeHordeMembers.add(coldSnapGifter);
                break;
            }
            case 5: {
                ColdSnapBrawler coldSnapBrawler = this.brawlerSpawnRules((World)this.world, pos);
                coldSnapBrawler.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                coldSnapBrawler.toggleHordeMember(this.center);
                this.world.func_217376_c((Entity)coldSnapBrawler);
                this.activeHordeMembers.add(coldSnapBrawler);
            }
        }
    }

    private ColdSnapGunner gunnerSpawnRules(World world, BlockPos pos) {
        ColdSnapGunner coldSnapGunner = null;
        String BiomeName = world.func_226691_t_(pos).getRegistryName().toString();
        if (BiomeName.contains("swamp")) {
            coldSnapGunner = new PlagueHorde.PlagueGunner((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPGUNNER.get()), world);
        } else if (world.func_234923_W_().toString().contains("end")) {
            coldSnapGunner = new EndHorde.EndGunner((EntityType<? extends MonsterEntity>)((EntityType)Register.ECOLDSNAPGUNNER.get()), world);
        } else if (world.func_234923_W_().toString().contains("nether")) {
            coldSnapGunner = new EndHorde.EndGunner((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPGUNNER.get()), world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.func_175727_C(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapGunner = new NetherHorde.NetherGunner((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPGUNNER.get()), world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGunner == null) {
                    coldSnapGunner = new EndHorde.EndGunner((EntityType<? extends MonsterEntity>)((EntityType)Register.ECOLDSNAPGUNNER.get()), world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGunner == null) {
                    coldSnapGunner = new PlagueHorde.PlagueGunner((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPGUNNER.get()), world);
                }
                if (coldSnapGunner == null) {
                    coldSnapGunner = new StandardHorde.StandardGunner((EntityType<? extends MonsterEntity>)((EntityType)Register.COLDSNAPGUNNER.get()), world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapGunner == null) {
                    coldSnapGunner = new PlagueHorde.PlagueGunner((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPGUNNER.get()), world);
                }
                if (coldSnapGunner == null) {
                    coldSnapGunner = new StandardHorde.StandardGunner((EntityType<? extends MonsterEntity>)((EntityType)Register.COLDSNAPGUNNER.get()), world);
                }
            }
        } else {
            coldSnapGunner = new NetherHorde.NetherGunner((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPGUNNER.get()), world);
        }
        return coldSnapGunner;
    }

    private ColdSnapStabber stabberSpawnRules(World world, BlockPos pos) {
        ColdSnapStabber coldSnapStabber = null;
        String BiomeName = world.func_226691_t_(pos).getRegistryName().toString();
        if (BiomeName.contains("swamp")) {
            coldSnapStabber = new PlagueHorde.PlagueStabber((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPSTABBER.get()), world);
        } else if (world.func_234923_W_().toString().contains("end")) {
            coldSnapStabber = new EndHorde.EndStabber((EntityType<? extends MonsterEntity>)((EntityType)Register.ECOLDSNAPSTABBER.get()), world);
        } else if (world.func_234923_W_().toString().contains("nether")) {
            coldSnapStabber = new NetherHorde.NetherStabber((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPSTABBER.get()), world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.func_175727_C(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapStabber = new NetherHorde.NetherStabber((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPSTABBER.get()), world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapStabber == null) {
                    coldSnapStabber = new EndHorde.EndStabber((EntityType<? extends MonsterEntity>)((EntityType)Register.ECOLDSNAPSTABBER.get()), world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapStabber == null) {
                    coldSnapStabber = new PlagueHorde.PlagueStabber((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPSTABBER.get()), world);
                }
                if (coldSnapStabber == null) {
                    coldSnapStabber = new StandardHorde.StandardStabber((EntityType<? extends MonsterEntity>)((EntityType)Register.COLDSNAPSTABBER.get()), world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapStabber == null) {
                    coldSnapStabber = new PlagueHorde.PlagueStabber((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPSTABBER.get()), world);
                }
                if (coldSnapStabber == null) {
                    coldSnapStabber = new StandardHorde.StandardStabber((EntityType<? extends MonsterEntity>)((EntityType)Register.COLDSNAPSTABBER.get()), world);
                }
            }
        } else {
            coldSnapStabber = new NetherHorde.NetherStabber((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPSTABBER.get()), world);
        }
        return coldSnapStabber;
    }

    private ColdSnapSnowballer snowballerSpawnRules(World world, BlockPos pos) {
        ColdSnapSnowballer coldSnapSnowballer = null;
        String BiomeName = world.func_226691_t_(pos).getRegistryName().toString();
        if (BiomeName.contains("swamp")) {
            coldSnapSnowballer = new PlagueHorde.PlagueSnowballer((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPSNOWBALLER.get()), world);
        } else if (world.func_234923_W_().toString().contains("end")) {
            coldSnapSnowballer = new EndHorde.EndSnowballer((EntityType<? extends MonsterEntity>)((EntityType)Register.ECOLDSNAPSNOWBALLER.get()), world);
        } else if (world.func_234923_W_().toString().contains("nether")) {
            coldSnapSnowballer = new NetherHorde.NetherSnowballer((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPSNOWBALLER.get()), world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.func_175727_C(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapSnowballer = new NetherHorde.NetherSnowballer((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPSNOWBALLER.get()), world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapSnowballer == null) {
                    coldSnapSnowballer = new EndHorde.EndSnowballer((EntityType<? extends MonsterEntity>)((EntityType)Register.ECOLDSNAPSNOWBALLER.get()), world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapSnowballer == null) {
                    coldSnapSnowballer = new PlagueHorde.PlagueSnowballer((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPSNOWBALLER.get()), world);
                }
                if (coldSnapSnowballer == null) {
                    coldSnapSnowballer = new StandardHorde.StandardSnowballer((EntityType<? extends MonsterEntity>)((EntityType)Register.COLDSNAPSNOWBALLER.get()), world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapSnowballer == null) {
                    coldSnapSnowballer = new PlagueHorde.PlagueSnowballer((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPSNOWBALLER.get()), world);
                }
                if (coldSnapSnowballer == null) {
                    coldSnapSnowballer = new StandardHorde.StandardSnowballer((EntityType<? extends MonsterEntity>)((EntityType)Register.COLDSNAPSNOWBALLER.get()), world);
                }
            }
        } else {
            coldSnapSnowballer = new NetherHorde.NetherSnowballer((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPSNOWBALLER.get()), world);
        }
        return coldSnapSnowballer;
    }

    private ColdSnapGifter gifterSpawnRules(World world, BlockPos pos) {
        ColdSnapGifter coldSnapGifter = null;
        String BiomeName = world.func_226691_t_(pos).getRegistryName().toString();
        if (BiomeName.contains("swamp")) {
            coldSnapGifter = new PlagueHorde.PlagueGifter((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPGIFTER.get()), world);
        } else if (world.func_234923_W_().toString().contains("end")) {
            coldSnapGifter = new EndHorde.EndGifter((EntityType<? extends MonsterEntity>)((EntityType)Register.ECOLDSNAPGIFTER.get()), world);
        } else if (world.func_234923_W_().toString().contains("nether")) {
            coldSnapGifter = new NetherHorde.NetherGifter((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPGIFTER.get()), world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.func_175727_C(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapGifter = new NetherHorde.NetherGifter((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPGIFTER.get()), world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGifter == null) {
                    coldSnapGifter = new EndHorde.EndGifter((EntityType<? extends MonsterEntity>)((EntityType)Register.ECOLDSNAPGIFTER.get()), world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGifter == null) {
                    coldSnapGifter = new PlagueHorde.PlagueGifter((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPGIFTER.get()), world);
                }
                if (coldSnapGifter == null) {
                    coldSnapGifter = new StandardHorde.StandardGifter((EntityType<? extends MonsterEntity>)((EntityType)Register.COLDSNAPGIFTER.get()), world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapGifter == null) {
                    coldSnapGifter = new PlagueHorde.PlagueGifter((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPGIFTER.get()), world);
                }
                if (coldSnapGifter == null) {
                    coldSnapGifter = new StandardHorde.StandardGifter((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPGIFTER.get()), world);
                }
            }
        } else {
            coldSnapGifter = new NetherHorde.NetherGifter((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPGIFTER.get()), world);
        }
        return coldSnapGifter;
    }

    private ColdSnapZapper zapperSpawnRules(World world, BlockPos pos) {
        ColdSnapZapper coldSnapZapper = null;
        String BiomeName = world.func_226691_t_(pos).getRegistryName().toString();
        if (BiomeName.contains("swamp")) {
            coldSnapZapper = new PlagueHorde.PlagueZapper((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPZAPPER.get()), world);
        } else if (world.func_234923_W_().toString().contains("end")) {
            coldSnapZapper = new EndHorde.EndZapper((EntityType<? extends MonsterEntity>)((EntityType)Register.ECOLDSNAPZAPPER.get()), world);
        } else if (world.func_234923_W_().toString().contains("nether")) {
            coldSnapZapper = new NetherHorde.NetherZapper((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPZAPPER.get()), world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.func_175727_C(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapZapper = new NetherHorde.NetherZapper((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPZAPPER.get()), world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapZapper == null) {
                    coldSnapZapper = new EndHorde.EndZapper((EntityType<? extends MonsterEntity>)((EntityType)Register.ECOLDSNAPZAPPER.get()), world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapZapper == null) {
                    coldSnapZapper = new PlagueHorde.PlagueZapper((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPZAPPER.get()), world);
                }
                if (coldSnapZapper == null) {
                    coldSnapZapper = new StandardHorde.StandardZapper((EntityType<? extends MonsterEntity>)((EntityType)Register.COLDSNAPZAPPER.get()), world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapZapper == null) {
                    coldSnapZapper = new PlagueHorde.PlagueZapper((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPZAPPER.get()), world);
                }
                if (coldSnapZapper == null) {
                    coldSnapZapper = new StandardHorde.StandardZapper((EntityType<? extends MonsterEntity>)((EntityType)Register.COLDSNAPZAPPER.get()), world);
                }
            }
        } else {
            coldSnapZapper = new NetherHorde.NetherZapper((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPZAPPER.get()), world);
        }
        return coldSnapZapper;
    }

    private ColdSnapBrawler brawlerSpawnRules(World world, BlockPos pos) {
        ColdSnapBrawler coldSnapBrawler = null;
        String BiomeName = world.func_226691_t_(pos).getRegistryName().toString();
        if (BiomeName.contains("swamp")) {
            coldSnapBrawler = new PlagueHorde.PlagueBrawler((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPBRAWLER.get()), world);
        } else if (world.func_234923_W_().toString().contains("end")) {
            coldSnapBrawler = new EndHorde.EndBrawler((EntityType<? extends MonsterEntity>)((EntityType)Register.ECOLDSNAPBRAWLER.get()), world);
        } else if (world.func_234923_W_().toString().contains("nether")) {
            coldSnapBrawler = new NetherHorde.NetherBrawler((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPBRAWLER.get()), world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.func_175727_C(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapBrawler = new NetherHorde.NetherBrawler((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPBRAWLER.get()), world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapBrawler == null) {
                    coldSnapBrawler = new EndHorde.EndBrawler((EntityType<? extends MonsterEntity>)((EntityType)Register.ECOLDSNAPBRAWLER.get()), world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapBrawler == null) {
                    coldSnapBrawler = new PlagueHorde.PlagueBrawler((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPBRAWLER.get()), world);
                }
                if (coldSnapBrawler == null) {
                    coldSnapBrawler = new StandardHorde.StandardBrawler((EntityType<? extends MonsterEntity>)((EntityType)Register.COLDSNAPBRAWLER.get()), world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapBrawler == null) {
                    coldSnapBrawler = new PlagueHorde.PlagueBrawler((EntityType<? extends MonsterEntity>)((EntityType)Register.PCOLDSNAPBRAWLER.get()), world);
                }
                if (coldSnapBrawler == null) {
                    coldSnapBrawler = new StandardHorde.StandardBrawler((EntityType<? extends MonsterEntity>)((EntityType)Register.COLDSNAPBRAWLER.get()), world);
                }
            }
        } else {
            coldSnapBrawler = new NetherHorde.NetherBrawler((EntityType<? extends MonsterEntity>)((EntityType)Register.NCOLDSNAPBRAWLER.get()), world);
        }
        return coldSnapBrawler;
    }

    private void broadcast(MinecraftServer server, ITextComponent translationTextComponent) {
        server.func_184103_al().func_232641_a_(translationTextComponent, ChatType.CHAT, UUID.randomUUID());
    }
}

