/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.coldsnaphorde;

import com.cartoonishvillain.coldsnaphorde.Capabilities.IWorldCapabilityManager;
import com.cartoonishvillain.coldsnaphorde.Configs.CConfiguration;
import com.cartoonishvillain.coldsnaphorde.Configs.ConfigHelper;
import com.cartoonishvillain.coldsnaphorde.Configs.SConfiguration;
import com.cartoonishvillain.coldsnaphorde.Events.Horde;
import com.cartoonishvillain.coldsnaphorde.Register;
import java.time.Instant;
import java.util.Date;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="coldsnaphorde")
public class ColdSnapHorde {
    public static Capability<IWorldCapabilityManager> WORLDCAPABILITYINSTANCE = null;
    public static final String MOD_ID = "coldsnaphorde";
    private static final Logger LOGGER = LogManager.getLogger();
    public static SConfiguration sconfig;
    public static CConfiguration cconfig;
    public static boolean isCalyxLoaded;
    public static boolean isInHolidayWindow;
    public static Horde Horde;
    public static final CreativeModeTab TAB;

    public ColdSnapHorde() {
        sconfig = ConfigHelper.register(ModConfig.Type.SERVER, SConfiguration::new);
        cconfig = ConfigHelper.register(ModConfig.Type.COMMON, CConfiguration::new);
        Register.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        isCalyxLoaded = ModList.get().isLoaded("immortuoscalyx");
        Date date = Date.from(Instant.now());
        Date december = Date.from(Instant.now());
        december.setMonth(11);
        december.setDate(15);
        december.setHours(0);
        december.setMinutes(0);
        if (date.getMonth() == 0) {
            december.setYear(december.getYear() - 1);
        }
        Date January = Date.from(Instant.now());
        January.setMonth(0);
        January.setDate(5);
        January.setHours(0);
        January.setMinutes(0);
        if (date.getMonth() != 0) {
            January.setYear(January.getYear() + 1);
        }
        isInHolidayWindow = date.compareTo(december) >= 0 && date.compareTo(January) <= 0;
        LOGGER.debug((Object)isInHolidayWindow);
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        Horde = new Horde(event.getServer());
        for (ServerLevel serverWorld : event.getServer().m_129785_()) {
            serverWorld.getCapability(WORLDCAPABILITYINSTANCE).ifPresent(h -> {
                if (h.getCooldownTicks() <= 0) {
                    h.setCooldownTicks(ColdSnapHorde.sconfig.GLOBALHORDECOOLDOWN.get() * 20);
                }
            });
        }
    }

    static {
        TAB = new CreativeModeTab("ColdSnapHorde"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)Register.ROCKYSNOWBALL.get());
            }
        };
    }
}

