/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.coldsnaphorde.Entities.Mobs.Behaviors;

import com.cartoonishvillain.coldsnaphorde.Entities.Mobs.BaseMob.GenericHordeMember;
import com.cartoonishvillain.coldsnaphorde.Register;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class GifterSurprise {
    Level world;
    Entity exploder;
    DamageSource source;
    double Entx;
    double Enty;
    double Entz;
    float radius;
    Vec3 position;
    DamageSource damageSource;
    ArrayList<BlockPos> blockPosArrayList = new ArrayList();
    int hordeVariant;
    ArrayList<Entity> effectedEntities = new ArrayList();

    public GifterSurprise(Level world, @Nullable Entity exploder, double x, double y, double z, float radius) {
        this.world = world;
        this.Entx = x;
        this.Enty = y;
        this.Entz = z;
        this.exploder = exploder;
        this.radius = radius;
        this.damageSource = DamageSource.m_19373_((LivingEntity)((LivingEntity)exploder));
        this.position = new Vec3(x, y, z);
        if (exploder instanceof GenericHordeMember) {
            GenericHordeMember genericHordeMember = (GenericHordeMember)exploder;
            this.hordeVariant = genericHordeMember.getHordeVariant();
        }
    }

    public void StageDetonation() {
        int x = (int)(-this.radius) - 1;
        while ((float)x <= this.radius) {
            int y = (int)(-this.radius) - 1;
            while ((float)y <= this.radius) {
                int z = (int)(-this.radius) - 1;
                while ((float)z <= this.radius) {
                    BlockPos blockPos = new BlockPos(this.Entx + (double)x, this.Enty + (double)y, this.Entz + (double)z);
                    this.blockPosArrayList.add(blockPos);
                    ArrayList entities = (ArrayList)this.world.m_45933_(this.exploder, new AABB(this.Entx + (double)x + 2.0, this.Enty + (double)y + 2.0, this.Entz + (double)z + 2.0, this.Entx + (double)x - 2.0, this.Enty + (double)y - 2.0, this.Entz + (double)z - 2.0));
                    for (Entity entity : entities) {
                        if (this.effectedEntities.contains(entity)) continue;
                        this.effectedEntities.add(entity);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public void DetonateTest() {
        for (BlockPos blockPos : this.blockPosArrayList) {
            this.world.m_46597_(blockPos, Blocks.f_49990_.m_49966_());
        }
    }

    public void DetonateBlockDamage() {
        block9: {
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.exploder.f_19853_, (Entity)this.exploder) || this.hordeVariant == 2) break block9;
            if (this.hordeVariant != 1) {
                for (BlockPos blockPos : this.blockPosArrayList) {
                    if ((this.world.m_8055_(blockPos).equals(Blocks.f_50016_.m_49966_()) || this.world.m_8055_(blockPos).equals(Blocks.f_50034_.m_49966_())) && !this.world.m_8055_(blockPos.m_7495_()).equals(Blocks.f_50016_.m_49966_()) && !this.world.m_8055_(blockPos.m_7495_()).equals(Blocks.f_50034_.m_49966_())) {
                        this.world.m_46597_(blockPos, Blocks.f_50125_.m_49966_());
                        continue;
                    }
                    if (this.world.m_8055_(blockPos).equals(Blocks.f_49990_.m_49966_())) {
                        this.world.m_46597_(blockPos, Blocks.f_50126_.m_49966_());
                        continue;
                    }
                    if (this.world.m_8055_(blockPos).equals(Blocks.f_49991_.m_49966_())) {
                        this.world.m_46597_(blockPos, Blocks.f_50080_.m_49966_());
                        continue;
                    }
                    if (this.world.m_8055_(blockPos).m_60734_().equals(Blocks.f_50093_)) {
                        this.world.m_46597_(blockPos, Blocks.f_50493_.m_49966_());
                        continue;
                    }
                    if (this.world.m_8055_(blockPos).equals(Blocks.f_50126_.m_49966_())) {
                        this.world.m_46597_(blockPos, Blocks.f_50354_.m_49966_());
                        continue;
                    }
                    if (!this.world.m_8055_(blockPos).m_60734_().equals(Blocks.f_50083_)) continue;
                    this.world.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                }
            } else {
                for (BlockPos blockPos : this.blockPosArrayList) {
                    BlockState blockstate;
                    if (!this.world.m_8055_(blockPos).equals(Blocks.f_50016_.m_49966_()) || !(blockstate = ((Block)Register.SLUSH.get()).m_49966_()).m_60710_((LevelReader)this.world, blockPos)) continue;
                    this.world.m_46597_(blockPos, blockstate);
                }
            }
        }
    }

    public void DetonateLivingHarm() {
        Vec3 vec3 = new Vec3(this.Entx, this.Enty, this.Entz);
        for (Entity entity : this.effectedEntities) {
            double distanceFactor;
            if (!(entity instanceof LivingEntity)) continue;
            float DamageRadius = this.radius * 1.5f;
            if (entity.m_6128_() || !((distanceFactor = Math.sqrt(entity.m_20238_(vec3)) / (double)DamageRadius) <= 1.0)) continue;
            double directionalx = entity.m_20185_() - this.Entx;
            double directionaly = entity.m_20186_() - this.Enty;
            double directionalz = entity.m_20189_() - this.Entz;
            double percentSeen = Explosion.m_46064_((Vec3)vec3, (Entity)entity);
            double damage = (1.0 - distanceFactor) * percentSeen;
            if (this.hordeVariant != 2) {
                double knockback = damage;
                if (entity instanceof LivingEntity) {
                    knockback = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)damage);
                }
                entity.m_20256_(entity.m_20184_().m_82520_(directionalx * knockback, directionaly * knockback, directionalz * knockback));
                if (this.hordeVariant == 3) {
                    GenericHordeMember.Infection((LivingEntity)entity);
                }
            } else {
                ((LivingEntity)entity).m_20984_(entity.m_20185_() + (double)entity.f_19853_.f_46441_.nextInt(20) - 10.0, entity.m_20186_() + (double)entity.f_19853_.f_46441_.nextInt(20) - 10.0, entity.m_20189_() + (double)entity.f_19853_.f_46441_.nextInt(20) - 10.0, true);
            }
            entity.m_6469_(this.damageSource, (float)((int)((damage * damage + damage) / 2.0 * 3.0 * (double)DamageRadius + 1.0)));
        }
    }
}

