/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.coldsnaphorde.Items;

import com.cartoonishvillain.coldsnaphorde.ColdSnapHorde;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Snowglobe
extends Item {
    public Snowglobe(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (handIn == InteractionHand.MAIN_HAND && !worldIn.m_5776_() && playerIn != null) {
            if (worldIn.isAreaLoaded(playerIn.m_142538_(), 20) && (this.biomeCheck(worldIn, playerIn.m_142538_()) || worldIn.m_46857_(playerIn.m_142538_()).getRegistryName().toString().contains("swamp") || worldIn.m_46472_().toString().contains("end") || worldIn.m_46472_().toString().contains("nether"))) {
                AtomicInteger atomicInteger = new AtomicInteger(0);
                worldIn.getCapability(ColdSnapHorde.WORLDCAPABILITYINSTANCE).ifPresent(h -> {
                    if (h.getCooldownTicks() > 0) {
                        atomicInteger.set(h.getCooldownTicks());
                    }
                });
                if (atomicInteger.get() == 0 && !ColdSnapHorde.Horde.getHordeActive().booleanValue()) {
                    ColdSnapHorde.Horde.SetUpHorde((ServerPlayer)playerIn);
                    worldIn.m_5594_(null, playerIn.m_142538_(), SoundEvents.f_12517_, SoundSource.PLAYERS, 0.5f, 1.5f);
                    playerIn.m_21205_().m_41774_(1);
                } else if (!ColdSnapHorde.Horde.getHordeActive().booleanValue()) {
                    playerIn.m_5661_((Component)new TextComponent("Horde on cooldown! Returning in: " + this.TimeBuilder(atomicInteger.get())), false);
                } else if (ColdSnapHorde.Horde.getHordeActive().booleanValue()) {
                    playerIn.m_5661_((Component)new TextComponent("The Horde is busy elsewhere. Try again later!"), false);
                }
            } else {
                playerIn.m_5661_((Component)new TextComponent("Temperature too hot for the horde to summon!"), false);
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    private boolean biomeCheck(Level world, BlockPos pos) {
        int protlvl = ColdSnapHorde.cconfig.HEATPROT.get();
        float temp = world.m_46857_(pos).m_47554_();
        int code = -1;
        if ((double)temp < 0.3) {
            code = 0;
        } else if ((double)temp >= 0.3 && (double)temp < 0.9) {
            code = 1;
        } else if ((double)temp >= 0.9 && (double)temp < 1.5) {
            code = 2;
        } else if ((double)temp >= 1.5) {
            code = 3;
        }
        return code <= protlvl;
    }

    private String TimeBuilder(int duration) {
        Object timer = "(";
        int timermath = duration / 20;
        if (timermath >= 60) {
            timer = (String)timer + Integer.toString(timermath / 60);
            while (timermath >= 60) {
                timermath -= 60;
            }
            timer = (String)timer + ":";
        } else {
            timer = (String)timer + "00:";
        }
        if (timermath > 9) {
            timer = (String)timer + Integer.toString(timermath);
            timer = (String)timer + ")";
        } else {
            timer = (String)timer + "0";
            timer = (String)timer + Integer.toString(timermath);
            timer = (String)timer + ")";
        }
        return timer;
    }
}

