/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.coldsnaphorde;

import com.cartoonishvillain.coldsnaphorde.Register;
import com.cartoonishvillain.coldsnaphorde.component.ComponentStarter;
import com.cartoonishvillain.coldsnaphorde.component.WorldCooldownComponent;
import com.cartoonishvillain.coldsnaphorde.config.ColdSnapConfig;
import com.cartoonishvillain.coldsnaphorde.entities.Spawns;
import com.cartoonishvillain.coldsnaphorde.events.Horde;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ColdSnapHorde
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"coldsnaphorde");
    public static final String MOD_ID = "coldsnaphorde";
    public static boolean isCalyxLoaded;
    public static boolean isInHolidayWindow;
    public static Horde Horde;
    public static final class_1761 TAB;
    public static ColdSnapConfig config;

    public void onInitialize() {
        Register.init();
        AutoConfig.register(ColdSnapConfig.class, JanksonConfigSerializer::new);
        config = (ColdSnapConfig)AutoConfig.getConfigHolder(ColdSnapConfig.class).getConfig();
        isCalyxLoaded = FabricLoader.getInstance().isModLoaded("immortuoscalyx") && ColdSnapHorde.config.coldSnapSettings.PLAGUEIMMORTUOSCOMPAT;
        ColdSnapHorde.holidayWindowCheck();
        ServerLifecycleEvents.SERVER_STARTING.register((Object)ServerStartListener.getInstance());
        ServerTickEvents.END_WORLD_TICK.register((Object)WorldTickListener.getInstance());
        ServerPlayConnectionEvents.JOIN.register((Object)JoinListener.getInstance());
        Spawns.initSpawns();
    }

    public static void holidayWindowCheck() {
        Date date = Date.from(Instant.now());
        Date december = Date.from(Instant.now());
        december.setMonth(11);
        december.setDate(15);
        december.setHours(0);
        december.setMinutes(0);
        if (date.getMonth() == 0) {
            december.setYear(december.getYear() - 1);
        }
        Date January = Date.from(Instant.now());
        January.setMonth(0);
        January.setDate(5);
        January.setHours(0);
        January.setMinutes(0);
        if (date.getMonth() != 0) {
            January.setYear(January.getYear() + 1);
        }
        isInHolidayWindow = date.compareTo(december) >= 0 && date.compareTo(January) <= 0;
    }

    static {
        TAB = FabricItemGroupBuilder.build((class_2960)new class_2960(MOD_ID, "coldgroup"), () -> new class_1799((class_1935)Register.ROCKYSNOWBALL));
    }

    public static class ServerStartListener
    implements ServerLifecycleEvents.ServerStarting {
        private static final ServerStartListener INSTANCE = new ServerStartListener();

        public static ServerStartListener getInstance() {
            return INSTANCE;
        }

        public void onServerStarting(MinecraftServer server) {
            Horde = new Horde(server);
            for (class_3218 serverWorld : server.method_3738()) {
                WorldCooldownComponent h = (WorldCooldownComponent)ComponentStarter.WORLDCOMPONENT.get((Object)serverWorld);
                if (h.getCooldownTicks() > 0) continue;
                h.setCooldownTicks(ColdSnapHorde.config.coldSnapSettings.GLOBALHORDECOOLDOWN * 20);
            }
        }
    }

    public static class WorldTickListener
    implements ServerTickEvents.EndWorldTick {
        private static final WorldTickListener INSTANCE = new WorldTickListener();

        public static WorldTickListener getInstance() {
            return INSTANCE;
        }

        public void onEndTick(class_3218 world) {
            WorldCooldownComponent h = (WorldCooldownComponent)ComponentStarter.WORLDCOMPONENT.get((Object)world);
            if (h.getCooldownTicks() > 0) {
                h.addCooldownTicks(-1);
            }
            Horde.tick();
        }
    }

    public static class JoinListener
    implements ServerPlayConnectionEvents.Join {
        private static final JoinListener INSTANCE = new JoinListener();

        public void onPlayReady(class_3244 handler, PacketSender sender, MinecraftServer server) {
            if (isInHolidayWindow) {
                handler.field_14140.method_9203((class_2561)new class_2588("info.coldsnaphorde.holiday").method_27692(class_124.field_1075), UUID.randomUUID());
            }
        }

        public static JoinListener getInstance() {
            return INSTANCE;
        }
    }
}

