/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.coldsnaphorde.events;

import com.cartoonishvillain.coldsnaphorde.ColdSnapHorde;
import com.cartoonishvillain.coldsnaphorde.Register;
import com.cartoonishvillain.coldsnaphorde.component.ComponentStarter;
import com.cartoonishvillain.coldsnaphorde.component.WorldCooldownComponent;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapBrawler;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapGifter;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapGunner;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapSnowballer;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapStabber;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapZapper;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.GenericHordeMember;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.hordevariantmanager.EndHorde;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.hordevariantmanager.NetherHorde;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.hordevariantmanager.PlagueHorde;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.hordevariantmanager.StandardHorde;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;

public class Horde {
    private Optional<class_2338> hordeSpawn = Optional.empty();
    private class_3218 world;
    private class_2338 center;
    private Boolean hordeActive = false;
    private MinecraftServer server;
    private float Alive = 0.0f;
    private float initAlive = 0.0f;
    private float Active = 0.0f;
    private int updateCenter = 0;
    private class_3222 serverPlayer;
    private ArrayList<class_3222> players = new ArrayList();
    private ArrayList<GenericHordeMember> activeHordeMembers = new ArrayList();
    private final class_3213 bossInfo = new class_3213((class_2561)new class_2585("Cold Snap Horde").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_1259.class_1260.field_5780, class_1259.class_1261.field_5791);

    public Horde(MinecraftServer server) {
        this.server = server;
        for (class_3218 serverWorld : server.method_3738()) {
            String string = serverWorld.method_27983().toString();
        }
    }

    public void Stop() {
        this.bossInfo.method_14091(false);
        this.bossInfo.method_14094();
        this.hordeActive = false;
        this.Alive = 0.0f;
        this.initAlive = 0.0f;
        this.Active = 0.0f;
        this.serverPlayer = null;
        this.activeHordeMembers.clear();
        this.center = null;
        this.players.clear();
        WorldCooldownComponent h = (WorldCooldownComponent)ComponentStarter.WORLDCOMPONENT.get((Object)this.world);
        h.setCooldownTicks(ColdSnapHorde.config.coldSnapSettings.GLOBALHORDECOOLDOWN * 20);
    }

    public Boolean getHordeActive() {
        return this.hordeActive;
    }

    public void SetUpHorde(class_3222 serverPlayerEntity) {
        this.world = serverPlayerEntity.method_14220();
        this.bossInfo.method_5411(true);
        if (serverPlayerEntity.field_6002.method_27983().toString().contains("end")) {
            this.bossInfo.method_5416(class_1259.class_1260.field_5783);
            this.bossInfo.method_5413((class_2561)new class_2585("Cold Snap Horde").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}));
        } else if (serverPlayerEntity.field_6002.method_27983().toString().contains("nether")) {
            this.bossInfo.method_5416(class_1259.class_1260.field_5784);
            this.bossInfo.method_5413((class_2561)new class_2585("Cold Snap Horde").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        } else {
            this.bossInfo.method_5416(class_1259.class_1260.field_5780);
        }
        if (serverPlayerEntity.field_6002.method_27983().equals(this.world.method_27983())) {
            this.serverPlayer = serverPlayerEntity;
            this.hordeActive = true;
            switch (this.world.method_8407()) {
                case field_5805: {
                    this.Alive = ColdSnapHorde.config.coldSnapSettings.ALIVEEASY;
                    this.initAlive = ColdSnapHorde.config.coldSnapSettings.ALIVEEASY;
                    break;
                }
                case field_5802: {
                    this.Alive = ColdSnapHorde.config.coldSnapSettings.ALIVENORMAL;
                    this.initAlive = ColdSnapHorde.config.coldSnapSettings.ALIVENORMAL;
                    break;
                }
                case field_5807: {
                    this.Alive = ColdSnapHorde.config.coldSnapSettings.ALIVEHARD;
                    this.initAlive = ColdSnapHorde.config.coldSnapSettings.ALIVEHARD;
                }
            }
            this.center = serverPlayerEntity.method_24515();
            WorldCooldownComponent h = (WorldCooldownComponent)ComponentStarter.WORLDCOMPONENT.get((Object)this.world);
            h.setCooldownTicks(-1);
        }
    }

    private boolean checkIfPlayerIsStillValid(class_3222 serverPlayer) {
        return serverPlayer.method_6032() != 0.0f && !serverPlayer.method_14239();
    }

    public void tick() {
        if (this.hordeActive.booleanValue()) {
            if (this.Alive > 0.0f) {
                if (this.serverPlayer.field_6002.method_8597().equals(this.world.method_8597()) && this.checkIfPlayerIsStillValid(this.serverPlayer) && !this.serverPlayer.method_14208()) {
                    boolean flag = this.hordeActive;
                    if (this.world.method_8407() == class_1267.field_5801) {
                        this.Stop();
                        return;
                    }
                    if (this.Active != (float)this.activeHordeMembers.size()) {
                        this.Active = this.activeHordeMembers.size();
                    }
                    this.bossInfo.method_14091(true);
                    if (this.Active < (float)ColdSnapHorde.config.coldSnapSettings.HORDESIZE) {
                        this.hordeSpawn = this.getValidSpawn(2);
                        if (!this.hordeSpawn.equals(Optional.empty()) && this.hordeSpawn.isPresent()) {
                            this.spawnSnowman(this.hordeSpawn.get());
                        }
                    }
                    if (this.updateCenter == 0) {
                        this.center = this.serverPlayer.method_24515();
                        this.updateCenter = ColdSnapHorde.config.coldSnapSettings.UPDATETICK;
                        if (!this.world.method_27983().toString().contains("nether") && !this.world.method_27983().toString().contains("end")) {
                            if (this.world.method_23753(this.center).method_8688().equals((Object)class_1959.class_1961.field_9364)) {
                                this.bossInfo.method_5416(class_1259.class_1260.field_5785);
                                this.bossInfo.method_5413((class_2561)new class_2585("Cold Snap Horde").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
                            } else {
                                this.bossInfo.method_5416(class_1259.class_1260.field_5780);
                                this.bossInfo.method_5413((class_2561)new class_2585("Cold Snap Horde").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
                            }
                        }
                        this.updatePlayers();
                        this.updateHorde();
                    } else {
                        --this.updateCenter;
                    }
                    this.bossInfo.method_5408(class_3532.method_15363((float)(this.Alive / this.initAlive), (float)0.0f, (float)1.0f));
                } else {
                    this.updatePlayers();
                    if (this.players.size() == 0) {
                        this.Stop();
                    } else {
                        this.bossInfo.method_14089(this.serverPlayer);
                        this.serverPlayer = this.players.get(0);
                        this.players.remove(0);
                    }
                }
            } else {
                this.Stop();
            }
        }
    }

    private void updatePlayers() {
        for (class_3222 serverPlayer : this.server.method_3760().method_14571()) {
            if (this.serverPlayer == serverPlayer) {
                this.bossInfo.method_14088(serverPlayer);
                continue;
            }
            if (serverPlayer.field_6002.method_8597().equals(this.world.method_8597()) && this.checkIfPlayerIsStillValid(serverPlayer)) {
                double distance = class_3532.method_15355((float)((float)serverPlayer.method_5649((double)this.center.method_10263(), (double)this.center.method_10264(), (double)this.center.method_10260())));
                if (distance < 64.0) {
                    if (this.players.contains(serverPlayer)) continue;
                    this.bossInfo.method_14088(serverPlayer);
                    this.players.add(serverPlayer);
                    continue;
                }
                this.bossInfo.method_14089(serverPlayer);
                this.players.remove(serverPlayer);
                continue;
            }
            this.bossInfo.method_14089(serverPlayer);
            this.players.remove(serverPlayer);
        }
    }

    private void updateHorde() {
        ArrayList<GenericHordeMember> removals = new ArrayList<GenericHordeMember>();
        ArrayList<GenericHordeMember> additions = new ArrayList<GenericHordeMember>();
        for (GenericHordeMember hordeMember : this.activeHordeMembers) {
            if (!hordeMember.isHordeMember()) {
                removals.add(hordeMember);
                this.UnitLost();
            }
            if (hordeMember.method_29504()) {
                removals.add(hordeMember);
                this.UnitDown();
            }
            hordeMember.updateHordeMember(this.center);
            class_2338 hordeTarget = hordeMember.getLoc();
            if (class_3532.method_15355((float)((float)hordeMember.method_5649(hordeTarget.method_10263(), hordeTarget.method_10264(), hordeTarget.method_10260()))) > 64.0f) {
                hordeMember.cancelHordeMembership();
                removals.add(hordeMember);
                this.UnitLost();
            }
            this.inviteNearbySnowmentoHorde(hordeMember, additions);
        }
        for (GenericHordeMember removal : removals) {
            this.activeHordeMembers.remove(removal);
        }
        this.activeHordeMembers.addAll(additions);
        removals.clear();
    }

    private void inviteNearbySnowmentoHorde(GenericHordeMember Member, ArrayList<GenericHordeMember> additions) {
        List list = Member.field_6002.method_18467(GenericHordeMember.class, Member.method_5829().method_1014(8.0));
        for (GenericHordeMember snowman : list) {
            if (Member.getLoc() == null || snowman.isHordeMember() || snowman.method_5968() != null) continue;
            snowman.toggleHordeMember(Member.getLoc());
            additions.add(snowman);
            this.InviteUnit();
        }
    }

    private Optional<class_2338> getValidSpawn(int var) {
        for (int i = 0; i < 3; ++i) {
            class_2338 blockPos = this.findRandomSpawnPos(var, 1);
            if (blockPos == null) continue;
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }

    private class_2338 findRandomSpawnPos(int logicvar, int loopvar) {
        int i = logicvar == 0 ? 2 : 2 - logicvar;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        for (int a = 0; a < loopvar; ++a) {
            float f = this.world.field_9229.nextFloat() * ((float)Math.PI * 2);
            double DISTANCE = -1.0;
            int j = Integer.MAX_VALUE;
            int l = Integer.MAX_VALUE;
            while (!(DISTANCE != -1.0 && DISTANCE > 450.0 && DISTANCE < 1250.0 && this.biomeCheck(this.world, new class_2338(j, this.center.method_10264(), l)))) {
                j = this.randFinder(this.center.method_10263(), f, i);
                l = this.randFinder(this.center.method_10260(), f, i);
                DISTANCE = this.center.method_10262((class_2382)new class_2338(j, this.center.method_10264(), l));
            }
            int k = this.findYPosition(j, l);
            if (k == -1) continue;
            blockPos.method_10103(j, k, l);
            if (!this.world.method_8477((class_2338)blockPos)) continue;
            return blockPos;
        }
        return null;
    }

    private int findYPosition(int j, int l) {
        class_2680 blockstate;
        int i;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        for (i = this.center.method_10264(); i < this.center.method_10264() + 25; ++i) {
            blockPos.method_10103(j, i - 1, l);
            blockstate = this.world.method_8320((class_2338)blockPos);
            if (!blockstate.method_26225() || blockstate.method_26204() instanceof class_2397 || blockstate.equals(class_2246.field_9987.method_9564())) continue;
            blockPos.method_10103(j, i, l);
            blockstate = this.world.method_8320((class_2338)blockPos);
            if (!blockstate.equals(class_2246.field_10124.method_9564())) continue;
            blockPos.method_10103(j, i + 1, l);
            blockstate = this.world.method_8320((class_2338)blockPos);
            if (!blockstate.equals(class_2246.field_10124.method_9564())) continue;
            return i;
        }
        for (i = this.center.method_10264(); i > this.center.method_10264() - 15; --i) {
            blockPos.method_10103(j, i - 1, l);
            blockstate = this.world.method_8320((class_2338)blockPos);
            if (!blockstate.method_26225() || blockstate.method_26204() instanceof class_2397 || blockstate.equals(class_2246.field_9987.method_9564())) continue;
            blockPos.method_10103(j, i, l);
            blockstate = this.world.method_8320((class_2338)blockPos);
            if (!blockstate.equals(class_2246.field_10124.method_9564())) continue;
            blockPos.method_10103(j, i + 1, l);
            blockstate = this.world.method_8320((class_2338)blockPos);
            if (!blockstate.equals(class_2246.field_10124.method_9564())) continue;
            return i;
        }
        return -1;
    }

    private int randFinder(int centercoord, float f, int i) {
        return centercoord + (this.world.field_9229.nextInt(50) - 25);
    }

    public void SpawnUnit() {
        this.Active += 1.0f;
    }

    public void InviteUnit() {
        this.Active += 1.0f;
    }

    public void UnitDown() {
        this.Active -= 1.0f;
        this.Alive -= 1.0f;
    }

    public void UnitLost() {
        this.Active -= 1.0f;
    }

    private boolean biomeCheck(class_3218 world, class_2338 pos) {
        if (world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9364)) {
            return true;
        }
        if (!world.method_27983().toString().contains("over")) {
            return true;
        }
        int protlvl = ColdSnapHorde.config.spawnconfig.HEATPROT;
        float temp = world.method_23753(pos).method_8712();
        int code = -1;
        if ((double)temp < 0.3) {
            code = 0;
        } else if ((double)temp >= 0.3 && (double)temp < 0.9) {
            code = 1;
        } else if ((double)temp >= 0.9 && (double)temp < 1.5) {
            code = 2;
        } else if ((double)temp >= 1.5) {
            code = 3;
        }
        return code <= protlvl;
    }

    private boolean trueBiomeCheck(class_3218 world, class_2338 pos) {
        int protlvl = ColdSnapHorde.config.spawnconfig.HEATPROT;
        float temp = world.method_23753(pos).method_8712();
        int code = -1;
        if ((double)temp < 0.3) {
            code = 0;
        } else if ((double)temp >= 0.3 && (double)temp < 0.9) {
            code = 1;
        } else if ((double)temp >= 0.9 && (double)temp < 1.5) {
            code = 2;
        } else if ((double)temp >= 1.5) {
            code = 3;
        }
        return code <= protlvl;
    }

    private void spawnSnowman(class_2338 pos) {
        ArrayList<Integer> SpawnWeights = new ArrayList<Integer>();
        SpawnWeights.add(ColdSnapHorde.config.spawnconfig.GUNNER);
        SpawnWeights.add(ColdSnapHorde.config.spawnconfig.STABBER);
        SpawnWeights.add(ColdSnapHorde.config.spawnconfig.SNOWBALLER);
        SpawnWeights.add(ColdSnapHorde.config.spawnconfig.ZAPPER);
        SpawnWeights.add(ColdSnapHorde.config.spawnconfig.GIFTER);
        SpawnWeights.add(ColdSnapHorde.config.spawnconfig.BRAWLER);
        int combined = 0;
        for (Integer weight : SpawnWeights) {
            combined += weight.intValue();
        }
        Random random = new Random();
        int rng = random.nextInt(combined);
        int selected = -1;
        int counter = 0;
        for (Integer weights : SpawnWeights) {
            if (rng - weights <= 0) {
                selected = counter;
                break;
            }
            ++counter;
            rng -= weights.intValue();
        }
        switch (selected) {
            case 0: {
                ColdSnapGunner coldSnapGunner = this.gunnerSpawnRules(this.world, pos);
                coldSnapGunner.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
                coldSnapGunner.toggleHordeMember(this.center);
                this.world.method_8649((class_1297)coldSnapGunner);
                this.activeHordeMembers.add(coldSnapGunner);
                break;
            }
            case 1: {
                ColdSnapStabber coldSnapStabber = this.stabberSpawnRules(this.world, pos);
                coldSnapStabber.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
                coldSnapStabber.toggleHordeMember(this.center);
                this.world.method_8649((class_1297)coldSnapStabber);
                this.activeHordeMembers.add(coldSnapStabber);
                break;
            }
            case 2: {
                ColdSnapSnowballer coldSnapSnowballer = this.snowballerSpawnRules(this.world, pos);
                coldSnapSnowballer.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
                coldSnapSnowballer.toggleHordeMember(this.center);
                this.world.method_8649((class_1297)coldSnapSnowballer);
                this.activeHordeMembers.add(coldSnapSnowballer);
                break;
            }
            case 3: {
                ColdSnapZapper coldSnapZapper = this.zapperSpawnRules(this.world, pos);
                coldSnapZapper.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
                coldSnapZapper.toggleHordeMember(this.center);
                this.world.method_8649((class_1297)coldSnapZapper);
                this.activeHordeMembers.add(coldSnapZapper);
                break;
            }
            case 4: {
                ColdSnapGifter coldSnapGifter = this.gifterSpawnRules(this.world, pos);
                coldSnapGifter.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
                coldSnapGifter.toggleHordeMember(this.center);
                this.world.method_8649((class_1297)coldSnapGifter);
                this.activeHordeMembers.add(coldSnapGifter);
                break;
            }
            case 5: {
                ColdSnapBrawler coldSnapBrawler = this.brawlerSpawnRules(this.world, pos);
                coldSnapBrawler.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
                coldSnapBrawler.toggleHordeMember(this.center);
                this.world.method_8649((class_1297)coldSnapBrawler);
                this.activeHordeMembers.add(coldSnapBrawler);
            }
        }
    }

    private ColdSnapGunner gunnerSpawnRules(class_3218 world, class_2338 pos) {
        ColdSnapGunner coldSnapGunner = null;
        boolean swamp = world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9364);
        if (swamp) {
            coldSnapGunner = new PlagueHorde.PlagueGunner(Register.PCOLDSNAPGUNNER, (class_1937)world);
        } else if (world.method_27983().toString().contains("end")) {
            coldSnapGunner = new EndHorde.EndGunner(Register.ECOLDSNAPGUNNER, (class_1937)world);
        } else if (world.method_27983().toString().contains("nether")) {
            coldSnapGunner = new EndHorde.EndGunner(Register.NCOLDSNAPGUNNER, (class_1937)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.method_8520(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapGunner = new NetherHorde.NetherGunner(Register.NCOLDSNAPGUNNER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGunner == null) {
                    coldSnapGunner = new EndHorde.EndGunner(Register.ECOLDSNAPGUNNER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGunner == null) {
                    coldSnapGunner = new PlagueHorde.PlagueGunner(Register.PCOLDSNAPGUNNER, (class_1937)world);
                }
                if (coldSnapGunner == null) {
                    coldSnapGunner = new StandardHorde.StandardGunner(Register.COLDSNAPGUNNER, (class_1937)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapGunner == null) {
                    coldSnapGunner = new PlagueHorde.PlagueGunner(Register.PCOLDSNAPGUNNER, (class_1937)world);
                }
                if (coldSnapGunner == null) {
                    coldSnapGunner = new StandardHorde.StandardGunner(Register.COLDSNAPGUNNER, (class_1937)world);
                }
            }
        } else {
            coldSnapGunner = new NetherHorde.NetherGunner(Register.NCOLDSNAPGUNNER, (class_1937)world);
        }
        return coldSnapGunner;
    }

    private ColdSnapStabber stabberSpawnRules(class_3218 world, class_2338 pos) {
        ColdSnapStabber coldSnapStabber = null;
        boolean swamp = world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9364);
        if (swamp) {
            coldSnapStabber = new PlagueHorde.PlagueStabber(Register.PCOLDSNAPSTABBER, (class_1937)world);
        } else if (world.method_27983().toString().contains("end")) {
            coldSnapStabber = new EndHorde.EndStabber(Register.ECOLDSNAPSTABBER, (class_1937)world);
        } else if (world.method_27983().toString().contains("nether")) {
            coldSnapStabber = new NetherHorde.NetherStabber(Register.NCOLDSNAPSTABBER, (class_1937)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.method_8520(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapStabber = new NetherHorde.NetherStabber(Register.NCOLDSNAPSTABBER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapStabber == null) {
                    coldSnapStabber = new EndHorde.EndStabber(Register.ECOLDSNAPSTABBER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapStabber == null) {
                    coldSnapStabber = new PlagueHorde.PlagueStabber(Register.PCOLDSNAPSTABBER, (class_1937)world);
                }
                if (coldSnapStabber == null) {
                    coldSnapStabber = new StandardHorde.StandardStabber(Register.COLDSNAPSTABBER, (class_1937)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapStabber == null) {
                    coldSnapStabber = new PlagueHorde.PlagueStabber(Register.PCOLDSNAPSTABBER, (class_1937)world);
                }
                if (coldSnapStabber == null) {
                    coldSnapStabber = new StandardHorde.StandardStabber(Register.COLDSNAPSTABBER, (class_1937)world);
                }
            }
        } else {
            coldSnapStabber = new NetherHorde.NetherStabber(Register.NCOLDSNAPSTABBER, (class_1937)world);
        }
        return coldSnapStabber;
    }

    private ColdSnapSnowballer snowballerSpawnRules(class_3218 world, class_2338 pos) {
        ColdSnapSnowballer coldSnapSnowballer = null;
        boolean swamp = world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9364);
        if (swamp) {
            coldSnapSnowballer = new PlagueHorde.PlagueSnowballer(Register.PCOLDSNAPSNOWBALLER, (class_1937)world);
        } else if (world.method_27983().toString().contains("end")) {
            coldSnapSnowballer = new EndHorde.EndSnowballer(Register.ECOLDSNAPSNOWBALLER, (class_1937)world);
        } else if (world.method_27983().toString().contains("nether")) {
            coldSnapSnowballer = new NetherHorde.NetherSnowballer(Register.NCOLDSNAPSNOWBALLER, (class_1937)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.method_8520(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapSnowballer = new NetherHorde.NetherSnowballer(Register.NCOLDSNAPSNOWBALLER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapSnowballer == null) {
                    coldSnapSnowballer = new EndHorde.EndSnowballer(Register.ECOLDSNAPSNOWBALLER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapSnowballer == null) {
                    coldSnapSnowballer = new PlagueHorde.PlagueSnowballer(Register.PCOLDSNAPSNOWBALLER, (class_1937)world);
                }
                if (coldSnapSnowballer == null) {
                    coldSnapSnowballer = new StandardHorde.StandardSnowballer(Register.COLDSNAPSNOWBALLER, (class_1937)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapSnowballer == null) {
                    coldSnapSnowballer = new PlagueHorde.PlagueSnowballer(Register.PCOLDSNAPSNOWBALLER, (class_1937)world);
                }
                if (coldSnapSnowballer == null) {
                    coldSnapSnowballer = new StandardHorde.StandardSnowballer(Register.COLDSNAPSNOWBALLER, (class_1937)world);
                }
            }
        } else {
            coldSnapSnowballer = new NetherHorde.NetherSnowballer(Register.NCOLDSNAPSNOWBALLER, (class_1937)world);
        }
        return coldSnapSnowballer;
    }

    private ColdSnapGifter gifterSpawnRules(class_3218 world, class_2338 pos) {
        ColdSnapGifter coldSnapGifter = null;
        boolean swamp = world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9364);
        if (swamp) {
            coldSnapGifter = new PlagueHorde.PlagueGifter(Register.PCOLDSNAPGIFTER, (class_1937)world);
        } else if (world.method_27983().toString().contains("end")) {
            coldSnapGifter = new EndHorde.EndGifter(Register.ECOLDSNAPGIFTER, (class_1937)world);
        } else if (world.method_27983().toString().contains("nether")) {
            coldSnapGifter = new NetherHorde.NetherGifter(Register.NCOLDSNAPGIFTER, (class_1937)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.method_8520(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapGifter = new NetherHorde.NetherGifter(Register.NCOLDSNAPGIFTER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGifter == null) {
                    coldSnapGifter = new EndHorde.EndGifter(Register.ECOLDSNAPGIFTER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGifter == null) {
                    coldSnapGifter = new PlagueHorde.PlagueGifter(Register.PCOLDSNAPGIFTER, (class_1937)world);
                }
                if (coldSnapGifter == null) {
                    coldSnapGifter = new StandardHorde.StandardGifter(Register.COLDSNAPGIFTER, (class_1937)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapGifter == null) {
                    coldSnapGifter = new PlagueHorde.PlagueGifter(Register.PCOLDSNAPGIFTER, (class_1937)world);
                }
                if (coldSnapGifter == null) {
                    coldSnapGifter = new StandardHorde.StandardGifter(Register.COLDSNAPGIFTER, (class_1937)world);
                }
            }
        } else {
            coldSnapGifter = new NetherHorde.NetherGifter(Register.NCOLDSNAPGIFTER, (class_1937)world);
        }
        return coldSnapGifter;
    }

    private ColdSnapZapper zapperSpawnRules(class_3218 world, class_2338 pos) {
        ColdSnapZapper coldSnapZapper = null;
        boolean swamp = world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9364);
        if (swamp) {
            coldSnapZapper = new PlagueHorde.PlagueZapper(Register.PCOLDSNAPZAPPER, (class_1937)world);
        } else if (world.method_27983().toString().contains("end")) {
            coldSnapZapper = new EndHorde.EndZapper(Register.ECOLDSNAPZAPPER, (class_1937)world);
        } else if (world.method_27983().toString().contains("nether")) {
            coldSnapZapper = new NetherHorde.NetherZapper(Register.NCOLDSNAPZAPPER, (class_1937)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.method_8520(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapZapper = new NetherHorde.NetherZapper(Register.NCOLDSNAPZAPPER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapZapper == null) {
                    coldSnapZapper = new EndHorde.EndZapper(Register.ECOLDSNAPZAPPER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapZapper == null) {
                    coldSnapZapper = new PlagueHorde.PlagueZapper(Register.PCOLDSNAPZAPPER, (class_1937)world);
                }
                if (coldSnapZapper == null) {
                    coldSnapZapper = new StandardHorde.StandardZapper(Register.COLDSNAPZAPPER, (class_1937)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapZapper == null) {
                    coldSnapZapper = new PlagueHorde.PlagueZapper(Register.PCOLDSNAPZAPPER, (class_1937)world);
                }
                if (coldSnapZapper == null) {
                    coldSnapZapper = new StandardHorde.StandardZapper(Register.COLDSNAPZAPPER, (class_1937)world);
                }
            }
        } else {
            coldSnapZapper = new NetherHorde.NetherZapper(Register.NCOLDSNAPZAPPER, (class_1937)world);
        }
        return coldSnapZapper;
    }

    private ColdSnapBrawler brawlerSpawnRules(class_3218 world, class_2338 pos) {
        ColdSnapBrawler coldSnapBrawler = null;
        boolean swamp = world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9364);
        if (swamp) {
            coldSnapBrawler = new PlagueHorde.PlagueBrawler(Register.PCOLDSNAPBRAWLER, (class_1937)world);
        } else if (world.method_27983().toString().contains("end")) {
            coldSnapBrawler = new EndHorde.EndBrawler(Register.ECOLDSNAPBRAWLER, (class_1937)world);
        } else if (world.method_27983().toString().contains("nether")) {
            coldSnapBrawler = new NetherHorde.NetherBrawler(Register.NCOLDSNAPBRAWLER, (class_1937)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.method_8520(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapBrawler = new NetherHorde.NetherBrawler(Register.NCOLDSNAPBRAWLER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapBrawler == null) {
                    coldSnapBrawler = new EndHorde.EndBrawler(Register.ECOLDSNAPBRAWLER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapBrawler == null) {
                    coldSnapBrawler = new PlagueHorde.PlagueBrawler(Register.PCOLDSNAPBRAWLER, (class_1937)world);
                }
                if (coldSnapBrawler == null) {
                    coldSnapBrawler = new StandardHorde.StandardBrawler(Register.COLDSNAPBRAWLER, (class_1937)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapBrawler == null) {
                    coldSnapBrawler = new PlagueHorde.PlagueBrawler(Register.PCOLDSNAPBRAWLER, (class_1937)world);
                }
                if (coldSnapBrawler == null) {
                    coldSnapBrawler = new StandardHorde.StandardBrawler(Register.COLDSNAPBRAWLER, (class_1937)world);
                }
            }
        } else {
            coldSnapBrawler = new NetherHorde.NetherBrawler(Register.NCOLDSNAPBRAWLER, (class_1937)world);
        }
        return coldSnapBrawler;
    }

    private void broadcast(MinecraftServer server, class_2585 translationTextComponent) {
        server.method_3760().method_14616((class_2561)translationTextComponent, class_2556.field_11737, UUID.randomUUID());
    }
}

