/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.coldsnaphorde.events;

import com.cartoonishvillain.coldsnaphorde.ColdSnapHorde;
import com.cartoonishvillain.coldsnaphorde.Register;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapBrawler;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapGifter;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapGunner;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapSnowballer;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapStabber;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapZapper;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.GenericHordeMember;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.hordevariantmanager.EndHorde;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.hordevariantmanager.NetherHorde;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.hordevariantmanager.PlagueHorde;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.hordevariantmanager.StandardHorde;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;

public class Horde {
    private Optional<BlockPos> hordeSpawn = Optional.empty();
    private ServerLevel world;
    private BlockPos center;
    private Boolean hordeActive = false;
    private MinecraftServer server;
    private float Alive = 0.0f;
    private float initAlive = 0.0f;
    private float Active = 0.0f;
    private int updateCenter = 0;
    private ServerPlayer serverPlayer;
    private ArrayList<ServerPlayer> players = new ArrayList();
    private ArrayList<GenericHordeMember> activeHordeMembers = new ArrayList();
    private final ServerBossEvent bossInfo = new ServerBossEvent((Component)new TextComponent("Cold Snap Horde").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.NOTCHED_10);

    public Horde(MinecraftServer server) {
        this.server = server;
        for (ServerLevel serverWorld : server.m_129785_()) {
            String string = serverWorld.m_46472_().toString();
        }
    }

    public void Stop() {
        this.bossInfo.m_8321_(false);
        this.bossInfo.m_7706_();
        this.hordeActive = false;
        this.Alive = 0.0f;
        this.initAlive = 0.0f;
        this.Active = 0.0f;
        this.serverPlayer = null;
        this.activeHordeMembers.clear();
        this.center = null;
        this.players.clear();
        this.world.getCapability(ColdSnapHorde.WORLDCAPABILITYINSTANCE).ifPresent(h -> h.setCooldownTicks(ColdSnapHorde.sconfig.GLOBALHORDECOOLDOWN.get() * 20));
    }

    public Boolean getHordeActive() {
        return this.hordeActive;
    }

    public void SetUpHorde(ServerPlayer serverPlayerEntity) {
        this.world = serverPlayerEntity.m_183503_();
        this.bossInfo.m_7006_(true);
        if (serverPlayerEntity.f_19853_.m_46472_().toString().contains("end")) {
            this.bossInfo.m_6451_(BossEvent.BossBarColor.PURPLE);
            this.bossInfo.m_6456_((Component)new TextComponent("Cold Snap Horde").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD}));
        } else if (serverPlayerEntity.f_19853_.m_46472_().toString().contains("nether")) {
            this.bossInfo.m_6451_(BossEvent.BossBarColor.RED);
            this.bossInfo.m_6456_((Component)new TextComponent("Cold Snap Horde").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        } else {
            this.bossInfo.m_6451_(BossEvent.BossBarColor.BLUE);
        }
        if (serverPlayerEntity.f_19853_.m_46472_().equals((Object)this.world.m_46472_())) {
            this.serverPlayer = serverPlayerEntity;
            this.hordeActive = true;
            switch (this.world.m_46791_()) {
                case EASY: {
                    this.Alive = ColdSnapHorde.sconfig.ALIVEEASY.get().intValue();
                    this.initAlive = ColdSnapHorde.sconfig.ALIVEEASY.get().intValue();
                    break;
                }
                case NORMAL: {
                    this.Alive = ColdSnapHorde.sconfig.ALIVENORMAL.get().intValue();
                    this.initAlive = ColdSnapHorde.sconfig.ALIVENORMAL.get().intValue();
                    break;
                }
                case HARD: {
                    this.Alive = ColdSnapHorde.sconfig.ALIVEHARD.get().intValue();
                    this.initAlive = ColdSnapHorde.sconfig.ALIVEHARD.get().intValue();
                }
            }
            this.center = serverPlayerEntity.m_142538_();
            this.world.getCapability(ColdSnapHorde.WORLDCAPABILITYINSTANCE).ifPresent(h -> h.setCooldownTicks(-1));
        }
    }

    private boolean checkIfPlayerIsStillValid(ServerPlayer serverPlayer) {
        return serverPlayer.m_21223_() != 0.0f;
    }

    public void tick() {
        if (this.hordeActive.booleanValue()) {
            if (this.Alive > 0.0f) {
                if (this.serverPlayer.f_19853_.m_6042_().equals(this.world.m_6042_()) && this.checkIfPlayerIsStillValid(this.serverPlayer) && !this.serverPlayer.m_8958_()) {
                    boolean flag = this.hordeActive;
                    if (this.world.m_46791_() == Difficulty.PEACEFUL) {
                        this.Stop();
                        return;
                    }
                    if (this.Active != (float)this.activeHordeMembers.size()) {
                        this.Active = this.activeHordeMembers.size();
                    }
                    this.bossInfo.m_8321_(true);
                    if (this.Active < (float)ColdSnapHorde.sconfig.HORDESIZE.get().intValue()) {
                        this.hordeSpawn = this.getValidSpawn(2);
                        if (!this.hordeSpawn.equals(Optional.empty()) && this.hordeSpawn.isPresent()) {
                            this.spawnSnowman(this.hordeSpawn.get());
                        }
                    }
                    if (this.updateCenter == 0) {
                        this.center = this.serverPlayer.m_142538_();
                        this.updateCenter = ColdSnapHorde.sconfig.UPDATETICK.get();
                        if (!this.world.m_46472_().toString().contains("nether") && !this.world.m_46472_().toString().contains("end")) {
                            if (this.world.m_46857_(this.center).getRegistryName().toString().contains("swamp")) {
                                this.bossInfo.m_6451_(BossEvent.BossBarColor.GREEN);
                                this.bossInfo.m_6456_((Component)new TextComponent("Cold Snap Horde").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
                            } else {
                                this.bossInfo.m_6451_(BossEvent.BossBarColor.BLUE);
                                this.bossInfo.m_6456_((Component)new TextComponent("Cold Snap Horde").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
                            }
                        }
                        this.updatePlayers();
                        this.updateHorde();
                    } else {
                        --this.updateCenter;
                    }
                    this.bossInfo.m_142711_(Mth.m_14036_((float)(this.Alive / this.initAlive), (float)0.0f, (float)1.0f));
                } else {
                    this.updatePlayers();
                    if (this.players.size() == 0) {
                        this.Stop();
                    } else {
                        this.bossInfo.m_6539_(this.serverPlayer);
                        this.serverPlayer = this.players.get(0);
                        this.players.remove(0);
                    }
                }
            } else {
                this.Stop();
            }
        }
    }

    private void updatePlayers() {
        for (ServerPlayer serverPlayer : this.server.m_6846_().m_11314_()) {
            if (this.serverPlayer == serverPlayer) {
                this.bossInfo.m_6543_(serverPlayer);
                continue;
            }
            if (serverPlayer.f_19853_.m_6042_().equals(this.world.m_6042_()) && this.checkIfPlayerIsStillValid(serverPlayer)) {
                double distance = Mth.m_14116_((float)((float)serverPlayer.m_20275_((double)this.center.m_123341_(), (double)this.center.m_123342_(), (double)this.center.m_123343_())));
                if (distance < 64.0) {
                    if (this.players.contains(serverPlayer)) continue;
                    this.bossInfo.m_6543_(serverPlayer);
                    this.players.add(serverPlayer);
                    continue;
                }
                this.bossInfo.m_6539_(serverPlayer);
                this.players.remove(serverPlayer);
                continue;
            }
            this.bossInfo.m_6539_(serverPlayer);
            this.players.remove(serverPlayer);
        }
    }

    private void updateHorde() {
        ArrayList<GenericHordeMember> removals = new ArrayList<GenericHordeMember>();
        ArrayList<GenericHordeMember> additions = new ArrayList<GenericHordeMember>();
        for (GenericHordeMember hordeMember : this.activeHordeMembers) {
            if (!hordeMember.isHordeMember()) {
                removals.add(hordeMember);
                this.UnitLost();
            }
            if (hordeMember.m_21224_()) {
                removals.add(hordeMember);
                this.UnitDown();
            }
            hordeMember.updateHordeMember(this.center);
            BlockPos hordeTarget = hordeMember.getLoc();
            if (Mth.m_14116_((float)((float)hordeMember.m_20275_(hordeTarget.m_123341_(), hordeTarget.m_123342_(), hordeTarget.m_123343_()))) > 64.0f) {
                hordeMember.cancelHordeMembership();
                removals.add(hordeMember);
                this.UnitLost();
            }
            this.inviteNearbySnowmentoHorde(hordeMember, additions);
        }
        for (GenericHordeMember removal : removals) {
            this.activeHordeMembers.remove(removal);
        }
        this.activeHordeMembers.addAll(additions);
        removals.clear();
    }

    private void inviteNearbySnowmentoHorde(GenericHordeMember Member, ArrayList<GenericHordeMember> additions) {
        List list = Member.f_19853_.m_45976_(GenericHordeMember.class, Member.m_142469_().m_82400_(8.0));
        for (GenericHordeMember snowman : list) {
            if (Member.getLoc() == null || snowman.isHordeMember() || snowman.m_5448_() != null) continue;
            snowman.toggleHordeMember(Member.getLoc());
            additions.add(snowman);
            this.InviteUnit();
        }
    }

    private Optional<BlockPos> getValidSpawn(int var) {
        for (int i = 0; i < 3; ++i) {
            BlockPos blockPos = this.findRandomSpawnPos(var, 1);
            if (blockPos == null) continue;
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }

    private BlockPos findRandomSpawnPos(int logicvar, int loopvar) {
        int i = logicvar == 0 ? 2 : 2 - logicvar;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int a = 0; a < loopvar; ++a) {
            float f = this.world.f_46441_.nextFloat() * ((float)Math.PI * 2);
            double DISTANCE = -1.0;
            int j = Integer.MAX_VALUE;
            int l = Integer.MAX_VALUE;
            while (!(DISTANCE != -1.0 && DISTANCE > 450.0 && DISTANCE < 1250.0 && this.biomeCheck(this.world, new BlockPos(j, this.center.m_123342_(), l)))) {
                j = this.randFinder(this.center.m_123341_(), f, i);
                l = this.randFinder(this.center.m_123343_(), f, i);
                DISTANCE = this.center.m_123331_((Vec3i)new BlockPos(j, this.center.m_123342_(), l));
            }
            int k = this.findYPosition(j, l);
            if (k == -1) continue;
            blockPos.m_122178_(j, k, l);
            if (!this.world.isAreaLoaded((BlockPos)blockPos, 20)) continue;
            return blockPos;
        }
        return null;
    }

    private int findYPosition(int j, int l) {
        BlockState blockstate;
        int i;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (i = this.center.m_123342_(); i < this.center.m_123342_() + 25; ++i) {
            blockPos.m_122178_(j, i - 1, l);
            blockstate = this.world.m_8055_((BlockPos)blockPos);
            if (!blockstate.m_60815_() || blockstate.m_60734_() instanceof LeavesBlock || blockstate.equals(Blocks.f_50752_.m_49966_())) continue;
            blockPos.m_122178_(j, i, l);
            blockstate = this.world.m_8055_((BlockPos)blockPos);
            if (!blockstate.equals(Blocks.f_50016_.m_49966_())) continue;
            blockPos.m_122178_(j, i + 1, l);
            blockstate = this.world.m_8055_((BlockPos)blockPos);
            if (!blockstate.equals(Blocks.f_50016_.m_49966_())) continue;
            return i;
        }
        for (i = this.center.m_123342_(); i > this.center.m_123342_() - 15; --i) {
            blockPos.m_122178_(j, i - 1, l);
            blockstate = this.world.m_8055_((BlockPos)blockPos);
            if (!blockstate.m_60815_() || blockstate.m_60734_() instanceof LeavesBlock || blockstate.equals(Blocks.f_50752_.m_49966_())) continue;
            blockPos.m_122178_(j, i, l);
            blockstate = this.world.m_8055_((BlockPos)blockPos);
            if (!blockstate.equals(Blocks.f_50016_.m_49966_())) continue;
            blockPos.m_122178_(j, i + 1, l);
            blockstate = this.world.m_8055_((BlockPos)blockPos);
            if (!blockstate.equals(Blocks.f_50016_.m_49966_())) continue;
            return i;
        }
        return -1;
    }

    private int randFinder(int centercoord, float f, int i) {
        return centercoord + (this.world.f_46441_.nextInt(50) - 25);
    }

    public void SpawnUnit() {
        this.Active += 1.0f;
    }

    public void InviteUnit() {
        this.Active += 1.0f;
    }

    public void UnitDown() {
        this.Active -= 1.0f;
        this.Alive -= 1.0f;
    }

    public void UnitLost() {
        this.Active -= 1.0f;
    }

    private boolean biomeCheck(ServerLevel world, BlockPos pos) {
        if (world.m_46857_(pos).getRegistryName().toString().contains("swamp")) {
            return true;
        }
        if (!world.m_46472_().toString().contains("over")) {
            return true;
        }
        int protlvl = ColdSnapHorde.cconfig.HEATPROT.get();
        float temp = world.m_46857_(pos).m_47554_();
        int code = -1;
        if ((double)temp < 0.3) {
            code = 0;
        } else if ((double)temp >= 0.3 && (double)temp < 0.9) {
            code = 1;
        } else if ((double)temp >= 0.9 && (double)temp < 1.5) {
            code = 2;
        } else if ((double)temp >= 1.5) {
            code = 3;
        }
        return code <= protlvl;
    }

    private boolean trueBiomeCheck(ServerLevel world, BlockPos pos) {
        int protlvl = ColdSnapHorde.cconfig.HEATPROT.get();
        float temp = world.m_46857_(pos).m_47554_();
        int code = -1;
        if ((double)temp < 0.3) {
            code = 0;
        } else if ((double)temp >= 0.3 && (double)temp < 0.9) {
            code = 1;
        } else if ((double)temp >= 0.9 && (double)temp < 1.5) {
            code = 2;
        } else if ((double)temp >= 1.5) {
            code = 3;
        }
        return code <= protlvl;
    }

    private void spawnSnowman(BlockPos pos) {
        ArrayList<Integer> SpawnWeights = new ArrayList<Integer>();
        SpawnWeights.add(ColdSnapHorde.cconfig.GUNNER.get());
        SpawnWeights.add(ColdSnapHorde.cconfig.STABBER.get());
        SpawnWeights.add(ColdSnapHorde.cconfig.SNOWBALLER.get());
        SpawnWeights.add(ColdSnapHorde.cconfig.ZAPPER.get());
        SpawnWeights.add(ColdSnapHorde.cconfig.GIFTER.get());
        SpawnWeights.add(ColdSnapHorde.cconfig.BRAWLER.get());
        int combined = 0;
        for (Integer weight : SpawnWeights) {
            combined += weight.intValue();
        }
        Random random = new Random();
        int rng = random.nextInt(combined);
        int selected = -1;
        int counter = 0;
        for (Integer weights : SpawnWeights) {
            if (rng - weights <= 0) {
                selected = counter;
                break;
            }
            ++counter;
            rng -= weights.intValue();
        }
        switch (selected) {
            case 0: {
                ColdSnapGunner coldSnapGunner = this.gunnerSpawnRules(this.world, pos);
                coldSnapGunner.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                coldSnapGunner.toggleHordeMember(this.center);
                this.world.m_7967_((Entity)coldSnapGunner);
                this.activeHordeMembers.add(coldSnapGunner);
                break;
            }
            case 1: {
                ColdSnapStabber coldSnapStabber = this.stabberSpawnRules(this.world, pos);
                coldSnapStabber.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                coldSnapStabber.toggleHordeMember(this.center);
                this.world.m_7967_((Entity)coldSnapStabber);
                this.activeHordeMembers.add(coldSnapStabber);
                break;
            }
            case 2: {
                ColdSnapSnowballer coldSnapSnowballer = this.snowballerSpawnRules(this.world, pos);
                coldSnapSnowballer.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                coldSnapSnowballer.toggleHordeMember(this.center);
                this.world.m_7967_((Entity)coldSnapSnowballer);
                this.activeHordeMembers.add(coldSnapSnowballer);
                break;
            }
            case 3: {
                ColdSnapZapper coldSnapZapper = this.zapperSpawnRules(this.world, pos);
                coldSnapZapper.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                coldSnapZapper.toggleHordeMember(this.center);
                this.world.m_7967_((Entity)coldSnapZapper);
                this.activeHordeMembers.add(coldSnapZapper);
                break;
            }
            case 4: {
                ColdSnapGifter coldSnapGifter = this.gifterSpawnRules(this.world, pos);
                coldSnapGifter.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                coldSnapGifter.toggleHordeMember(this.center);
                this.world.m_7967_((Entity)coldSnapGifter);
                this.activeHordeMembers.add(coldSnapGifter);
                break;
            }
            case 5: {
                ColdSnapBrawler coldSnapBrawler = this.brawlerSpawnRules(this.world, pos);
                coldSnapBrawler.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                coldSnapBrawler.toggleHordeMember(this.center);
                this.world.m_7967_((Entity)coldSnapBrawler);
                this.activeHordeMembers.add(coldSnapBrawler);
            }
        }
    }

    private ColdSnapGunner gunnerSpawnRules(ServerLevel world, BlockPos pos) {
        ColdSnapGunner coldSnapGunner = null;
        String BiomeName = world.m_46857_(pos).getRegistryName().toString();
        if (BiomeName.contains("swamp")) {
            coldSnapGunner = new PlagueHorde.PlagueGunner((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPGUNNER.get()), (Level)world);
        } else if (world.m_46472_().toString().contains("end")) {
            coldSnapGunner = new EndHorde.EndGunner((EntityType<? extends Monster>)((EntityType)Register.ECOLDSNAPGUNNER.get()), (Level)world);
        } else if (world.m_46472_().toString().contains("nether")) {
            coldSnapGunner = new EndHorde.EndGunner((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPGUNNER.get()), (Level)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.m_46758_(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapGunner = new NetherHorde.NetherGunner((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPGUNNER.get()), (Level)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGunner == null) {
                    coldSnapGunner = new EndHorde.EndGunner((EntityType<? extends Monster>)((EntityType)Register.ECOLDSNAPGUNNER.get()), (Level)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGunner == null) {
                    coldSnapGunner = new PlagueHorde.PlagueGunner((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPGUNNER.get()), (Level)world);
                }
                if (coldSnapGunner == null) {
                    coldSnapGunner = new StandardHorde.StandardGunner((EntityType<? extends Monster>)((EntityType)Register.COLDSNAPGUNNER.get()), (Level)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapGunner == null) {
                    coldSnapGunner = new PlagueHorde.PlagueGunner((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPGUNNER.get()), (Level)world);
                }
                if (coldSnapGunner == null) {
                    coldSnapGunner = new StandardHorde.StandardGunner((EntityType<? extends Monster>)((EntityType)Register.COLDSNAPGUNNER.get()), (Level)world);
                }
            }
        } else {
            coldSnapGunner = new NetherHorde.NetherGunner((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPGUNNER.get()), (Level)world);
        }
        return coldSnapGunner;
    }

    private ColdSnapStabber stabberSpawnRules(ServerLevel world, BlockPos pos) {
        ColdSnapStabber coldSnapStabber = null;
        String BiomeName = world.m_46857_(pos).getRegistryName().toString();
        if (BiomeName.contains("swamp")) {
            coldSnapStabber = new PlagueHorde.PlagueStabber((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPSTABBER.get()), (Level)world);
        } else if (world.m_46472_().toString().contains("end")) {
            coldSnapStabber = new EndHorde.EndStabber((EntityType<? extends Monster>)((EntityType)Register.ECOLDSNAPSTABBER.get()), (Level)world);
        } else if (world.m_46472_().toString().contains("nether")) {
            coldSnapStabber = new NetherHorde.NetherStabber((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPSTABBER.get()), (Level)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.m_46758_(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapStabber = new NetherHorde.NetherStabber((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPSTABBER.get()), (Level)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapStabber == null) {
                    coldSnapStabber = new EndHorde.EndStabber((EntityType<? extends Monster>)((EntityType)Register.ECOLDSNAPSTABBER.get()), (Level)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapStabber == null) {
                    coldSnapStabber = new PlagueHorde.PlagueStabber((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPSTABBER.get()), (Level)world);
                }
                if (coldSnapStabber == null) {
                    coldSnapStabber = new StandardHorde.StandardStabber((EntityType<? extends Monster>)((EntityType)Register.COLDSNAPSTABBER.get()), (Level)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapStabber == null) {
                    coldSnapStabber = new PlagueHorde.PlagueStabber((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPSTABBER.get()), (Level)world);
                }
                if (coldSnapStabber == null) {
                    coldSnapStabber = new StandardHorde.StandardStabber((EntityType<? extends Monster>)((EntityType)Register.COLDSNAPSTABBER.get()), (Level)world);
                }
            }
        } else {
            coldSnapStabber = new NetherHorde.NetherStabber((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPSTABBER.get()), (Level)world);
        }
        return coldSnapStabber;
    }

    private ColdSnapSnowballer snowballerSpawnRules(ServerLevel world, BlockPos pos) {
        ColdSnapSnowballer coldSnapSnowballer = null;
        String BiomeName = world.m_46857_(pos).getRegistryName().toString();
        if (BiomeName.contains("swamp")) {
            coldSnapSnowballer = new PlagueHorde.PlagueSnowballer((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPSNOWBALLER.get()), (Level)world);
        } else if (world.m_46472_().toString().contains("end")) {
            coldSnapSnowballer = new EndHorde.EndSnowballer((EntityType<? extends Monster>)((EntityType)Register.ECOLDSNAPSNOWBALLER.get()), (Level)world);
        } else if (world.m_46472_().toString().contains("nether")) {
            coldSnapSnowballer = new NetherHorde.NetherSnowballer((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPSNOWBALLER.get()), (Level)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.m_46758_(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapSnowballer = new NetherHorde.NetherSnowballer((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPSNOWBALLER.get()), (Level)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapSnowballer == null) {
                    coldSnapSnowballer = new EndHorde.EndSnowballer((EntityType<? extends Monster>)((EntityType)Register.ECOLDSNAPSNOWBALLER.get()), (Level)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapSnowballer == null) {
                    coldSnapSnowballer = new PlagueHorde.PlagueSnowballer((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPSNOWBALLER.get()), (Level)world);
                }
                if (coldSnapSnowballer == null) {
                    coldSnapSnowballer = new StandardHorde.StandardSnowballer((EntityType<? extends Monster>)((EntityType)Register.COLDSNAPSNOWBALLER.get()), (Level)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapSnowballer == null) {
                    coldSnapSnowballer = new PlagueHorde.PlagueSnowballer((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPSNOWBALLER.get()), (Level)world);
                }
                if (coldSnapSnowballer == null) {
                    coldSnapSnowballer = new StandardHorde.StandardSnowballer((EntityType<? extends Monster>)((EntityType)Register.COLDSNAPSNOWBALLER.get()), (Level)world);
                }
            }
        } else {
            coldSnapSnowballer = new NetherHorde.NetherSnowballer((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPSNOWBALLER.get()), (Level)world);
        }
        return coldSnapSnowballer;
    }

    private ColdSnapGifter gifterSpawnRules(ServerLevel world, BlockPos pos) {
        ColdSnapGifter coldSnapGifter = null;
        String BiomeName = world.m_46857_(pos).getRegistryName().toString();
        if (BiomeName.contains("swamp")) {
            coldSnapGifter = new PlagueHorde.PlagueGifter((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPGIFTER.get()), (Level)world);
        } else if (world.m_46472_().toString().contains("end")) {
            coldSnapGifter = new EndHorde.EndGifter((EntityType<? extends Monster>)((EntityType)Register.ECOLDSNAPGIFTER.get()), (Level)world);
        } else if (world.m_46472_().toString().contains("nether")) {
            coldSnapGifter = new NetherHorde.NetherGifter((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPGIFTER.get()), (Level)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.m_46758_(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapGifter = new NetherHorde.NetherGifter((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPGIFTER.get()), (Level)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGifter == null) {
                    coldSnapGifter = new EndHorde.EndGifter((EntityType<? extends Monster>)((EntityType)Register.ECOLDSNAPGIFTER.get()), (Level)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGifter == null) {
                    coldSnapGifter = new PlagueHorde.PlagueGifter((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPGIFTER.get()), (Level)world);
                }
                if (coldSnapGifter == null) {
                    coldSnapGifter = new StandardHorde.StandardGifter((EntityType<? extends Monster>)((EntityType)Register.COLDSNAPGIFTER.get()), (Level)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapGifter == null) {
                    coldSnapGifter = new PlagueHorde.PlagueGifter((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPGIFTER.get()), (Level)world);
                }
                if (coldSnapGifter == null) {
                    coldSnapGifter = new StandardHorde.StandardGifter((EntityType<? extends Monster>)((EntityType)Register.COLDSNAPGIFTER.get()), (Level)world);
                }
            }
        } else {
            coldSnapGifter = new NetherHorde.NetherGifter((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPGIFTER.get()), (Level)world);
        }
        return coldSnapGifter;
    }

    private ColdSnapZapper zapperSpawnRules(ServerLevel world, BlockPos pos) {
        ColdSnapZapper coldSnapZapper = null;
        String BiomeName = world.m_46857_(pos).getRegistryName().toString();
        if (BiomeName.contains("swamp")) {
            coldSnapZapper = new PlagueHorde.PlagueZapper((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPZAPPER.get()), (Level)world);
        } else if (world.m_46472_().toString().contains("end")) {
            coldSnapZapper = new EndHorde.EndZapper((EntityType<? extends Monster>)((EntityType)Register.ECOLDSNAPZAPPER.get()), (Level)world);
        } else if (world.m_46472_().toString().contains("nether")) {
            coldSnapZapper = new NetherHorde.NetherZapper((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPZAPPER.get()), (Level)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.m_46758_(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapZapper = new NetherHorde.NetherZapper((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPZAPPER.get()), (Level)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapZapper == null) {
                    coldSnapZapper = new EndHorde.EndZapper((EntityType<? extends Monster>)((EntityType)Register.ECOLDSNAPZAPPER.get()), (Level)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapZapper == null) {
                    coldSnapZapper = new PlagueHorde.PlagueZapper((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPZAPPER.get()), (Level)world);
                }
                if (coldSnapZapper == null) {
                    coldSnapZapper = new StandardHorde.StandardZapper((EntityType<? extends Monster>)((EntityType)Register.COLDSNAPZAPPER.get()), (Level)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapZapper == null) {
                    coldSnapZapper = new PlagueHorde.PlagueZapper((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPZAPPER.get()), (Level)world);
                }
                if (coldSnapZapper == null) {
                    coldSnapZapper = new StandardHorde.StandardZapper((EntityType<? extends Monster>)((EntityType)Register.COLDSNAPZAPPER.get()), (Level)world);
                }
            }
        } else {
            coldSnapZapper = new NetherHorde.NetherZapper((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPZAPPER.get()), (Level)world);
        }
        return coldSnapZapper;
    }

    private ColdSnapBrawler brawlerSpawnRules(ServerLevel world, BlockPos pos) {
        ColdSnapBrawler coldSnapBrawler = null;
        String BiomeName = world.m_46857_(pos).getRegistryName().toString();
        if (BiomeName.contains("swamp")) {
            coldSnapBrawler = new PlagueHorde.PlagueBrawler((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPBRAWLER.get()), (Level)world);
        } else if (world.m_46472_().toString().contains("end")) {
            coldSnapBrawler = new EndHorde.EndBrawler((EntityType<? extends Monster>)((EntityType)Register.ECOLDSNAPBRAWLER.get()), (Level)world);
        } else if (world.m_46472_().toString().contains("nether")) {
            coldSnapBrawler = new NetherHorde.NetherBrawler((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPBRAWLER.get()), (Level)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.m_46758_(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapBrawler = new NetherHorde.NetherBrawler((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPBRAWLER.get()), (Level)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapBrawler == null) {
                    coldSnapBrawler = new EndHorde.EndBrawler((EntityType<? extends Monster>)((EntityType)Register.ECOLDSNAPBRAWLER.get()), (Level)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapBrawler == null) {
                    coldSnapBrawler = new PlagueHorde.PlagueBrawler((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPBRAWLER.get()), (Level)world);
                }
                if (coldSnapBrawler == null) {
                    coldSnapBrawler = new StandardHorde.StandardBrawler((EntityType<? extends Monster>)((EntityType)Register.COLDSNAPBRAWLER.get()), (Level)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapBrawler == null) {
                    coldSnapBrawler = new PlagueHorde.PlagueBrawler((EntityType<? extends Monster>)((EntityType)Register.PCOLDSNAPBRAWLER.get()), (Level)world);
                }
                if (coldSnapBrawler == null) {
                    coldSnapBrawler = new StandardHorde.StandardBrawler((EntityType<? extends Monster>)((EntityType)Register.COLDSNAPBRAWLER.get()), (Level)world);
                }
            }
        } else {
            coldSnapBrawler = new NetherHorde.NetherBrawler((EntityType<? extends Monster>)((EntityType)Register.NCOLDSNAPBRAWLER.get()), (Level)world);
        }
        return coldSnapBrawler;
    }

    private void broadcast(MinecraftServer server, TextComponent translationTextComponent) {
        server.m_6846_().m_11264_((Component)translationTextComponent, ChatType.CHAT, UUID.randomUUID());
    }
}

