/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.coldsnaphorde.events;

import com.cartoonishvillain.cartoonishhorde.EntityHordeData;
import com.cartoonishvillain.cartoonishhorde.Horde;
import com.cartoonishvillain.coldsnaphorde.ColdSnapHorde;
import com.cartoonishvillain.coldsnaphorde.Register;
import com.cartoonishvillain.coldsnaphorde.component.ComponentStarter;
import com.cartoonishvillain.coldsnaphorde.component.WorldCooldownComponent;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapBrawler;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapGifter;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapGunner;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapSnowballer;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapStabber;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.ColdSnapZapper;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.basemob.GenericHordeMember;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.hordevariantmanager.EndHorde;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.hordevariantmanager.NetherHorde;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.hordevariantmanager.PlagueHorde;
import com.cartoonishvillain.coldsnaphorde.entities.mobs.hordevariantmanager.StandardHorde;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ColdSnapHordeEvent
extends Horde {
    public ColdSnapHordeEvent(MinecraftServer server) {
        super(server);
    }

    public void Stop(Horde.HordeStopReasons stopReason) {
        switch (stopReason) {
            case VICTORY: {
                this.broadcast(this.server, (class_2561)new class_2588("message.coldsnaphorde.hordevictory").method_27692(class_124.field_1075));
                for (class_3222 player : this.players) {
                    ColdSnapHorde.giveAdvancement(player, this.server, new class_2960("coldsnaphorde", "sliced_snowmen"));
                }
                ColdSnapHorde.giveAdvancement(this.hordeAnchorPlayer, this.server, new class_2960("coldsnaphorde", "sliced_snowmen"));
                break;
            }
            case DEFEAT: {
                this.broadcast(this.server, (class_2561)new class_2588("message.coldsnaphorde.hordedefeat").method_27692(class_124.field_1061));
                break;
            }
            case PEACEFUL: {
                this.broadcast(this.server, (class_2561)new class_2588("message.coldsnaphorde.peaceful").method_27692(class_124.field_1054));
                break;
            }
            case SPAWN_ERROR: {
                this.broadcast(this.server, (class_2561)new class_2588("message.coldsnaphorde.confused").method_27692(class_124.field_1061));
            }
        }
        WorldCooldownComponent h = (WorldCooldownComponent)ComponentStarter.WORLDCOMPONENT.get((Object)this.world);
        h.setCooldownTicks(ColdSnapHorde.config.coldSnapSettings.GLOBALHORDECOOLDOWN * 20);
        super.Stop(stopReason);
    }

    public void setActiveMemberCount() {
        this.allowedActive = ColdSnapHorde.config.coldSnapSettings.HORDESIZE;
    }

    public void SetUpHorde(class_3222 serverPlayer) {
        super.SetUpHorde(serverPlayer);
        WorldCooldownComponent h = (WorldCooldownComponent)ComponentStarter.WORLDCOMPONENT.get((Object)this.world);
        h.setCooldownTicks(-1);
        this.bossInfo.method_5411(true);
        if (this.hordeAnchorPlayer.field_6002.method_27983().toString().contains("end")) {
            this.bossInfo.method_5416(class_1259.class_1260.field_5783);
            this.bossInfo.method_5413((class_2561)new class_2585("Cold Snap Horde").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}));
        } else if (this.hordeAnchorPlayer.field_6002.method_27983().toString().contains("nether")) {
            this.bossInfo.method_5416(class_1259.class_1260.field_5784);
            this.bossInfo.method_5413((class_2561)new class_2585("Cold Snap Horde").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
        } else if (this.world.method_23753(this.center).method_8688().equals((Object)class_1959.class_1961.field_9364)) {
            this.bossInfo.method_5416(class_1259.class_1260.field_5785);
            this.bossInfo.method_5413((class_2561)new class_2585("Cold Snap Horde").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
        } else {
            this.bossInfo.method_5416(class_1259.class_1260.field_5780);
            this.bossInfo.method_5413((class_2561)new class_2585("Cold Snap Horde").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
        }
        ColdSnapHorde.giveAdvancement(serverPlayer, this.server, new class_2960("coldsnaphorde", "snow_day"));
        this.broadcast(this.server, (class_2561)new class_2588("message.coldsnaphorde.hordestart", new Object[]{serverPlayer.method_5476()}).method_27692(class_124.field_1075));
    }

    public void setEasyDifficultyStats() {
        this.Alive = ColdSnapHorde.config.coldSnapSettings.ALIVEEASY;
        this.initAlive = ColdSnapHorde.config.coldSnapSettings.ALIVEEASY;
    }

    public void setNormalDifficultyStats() {
        this.Alive = ColdSnapHorde.config.coldSnapSettings.ALIVENORMAL;
        this.initAlive = ColdSnapHorde.config.coldSnapSettings.ALIVENORMAL;
    }

    public void setHardDifficultyStats() {
        this.Alive = ColdSnapHorde.config.coldSnapSettings.ALIVEHARD;
        this.initAlive = ColdSnapHorde.config.coldSnapSettings.ALIVEHARD;
    }

    protected void updateCenter() {
        if (this.updateCenter == 0) {
            this.center = this.hordeAnchorPlayer.method_24515();
            this.updateCenter = ColdSnapHorde.config.coldSnapSettings.UPDATETICK;
            if (!this.world.method_27983().toString().contains("nether") && !this.world.method_27983().toString().contains("end")) {
                if (this.world.method_23753(this.center).method_8688().equals((Object)class_1959.class_1961.field_9364)) {
                    this.bossInfo.method_5416(class_1259.class_1260.field_5785);
                    this.bossInfo.method_5413((class_2561)new class_2585("Cold Snap Horde").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
                } else {
                    this.bossInfo.method_5416(class_1259.class_1260.field_5780);
                    this.bossInfo.method_5413((class_2561)new class_2585("Cold Snap Horde").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
                }
            }
            this.updatePlayers();
            this.updateHorde();
        } else {
            --this.updateCenter;
        }
    }

    private void broadcast(MinecraftServer server, class_2561 translationTextComponent) {
        server.method_3760().method_14616(translationTextComponent, class_2556.field_11737, UUID.randomUUID());
    }

    private boolean biomeCheck(class_3218 world, class_2338 pos) {
        if (world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9364)) {
            return true;
        }
        if (!world.method_27983().toString().contains("over")) {
            return true;
        }
        int protlvl = ColdSnapHorde.config.spawnconfig.HEATPROT;
        float temp = world.method_23753(pos).method_8712();
        int code = -1;
        if ((double)temp < 0.3) {
            code = 0;
        } else if ((double)temp >= 0.3 && (double)temp < 0.9) {
            code = 1;
        } else if ((double)temp >= 0.9 && (double)temp < 1.5) {
            code = 2;
        } else if ((double)temp >= 1.5) {
            code = 3;
        }
        return code <= protlvl;
    }

    private boolean trueBiomeCheck(class_3218 world, class_2338 pos) {
        int protlvl = ColdSnapHorde.config.spawnconfig.HEATPROT;
        float temp = world.method_23753(pos).method_8712();
        int code = -1;
        if ((double)temp < 0.3) {
            code = 0;
        } else if ((double)temp >= 0.3 && (double)temp < 0.9) {
            code = 1;
        } else if ((double)temp >= 0.9 && (double)temp < 1.5) {
            code = 2;
        } else if ((double)temp >= 1.5) {
            code = 3;
        }
        return code <= protlvl;
    }

    protected class_2338 hordeSpawnAttempter(class_1299 type) {
        Optional hordeSpawn = Optional.empty();
        int attempts = 0;
        while (hordeSpawn.isEmpty()) {
            hordeSpawn = this.getValidSpawn(2, type);
            if (!hordeSpawn.isEmpty() || ++attempts < 5) continue;
            this.Stop(Horde.HordeStopReasons.SPAWN_ERROR);
            return null;
        }
        return (class_2338)hordeSpawn.get();
    }

    protected void spawnHordeMember() {
        ArrayList<Integer> SpawnWeights = new ArrayList<Integer>();
        SpawnWeights.add(ColdSnapHorde.config.spawnconfig.GUNNER);
        SpawnWeights.add(ColdSnapHorde.config.spawnconfig.STABBER);
        SpawnWeights.add(ColdSnapHorde.config.spawnconfig.SNOWBALLER);
        SpawnWeights.add(ColdSnapHorde.config.spawnconfig.ZAPPER);
        SpawnWeights.add(ColdSnapHorde.config.spawnconfig.GIFTER);
        SpawnWeights.add(ColdSnapHorde.config.spawnconfig.BRAWLER);
        int combined = 0;
        for (Integer weight : SpawnWeights) {
            combined += weight.intValue();
        }
        Random random = new Random();
        int rng = random.nextInt(combined);
        int selected = -1;
        int counter = 0;
        for (Integer weights : SpawnWeights) {
            if (rng - weights <= 0) {
                selected = counter;
                break;
            }
            ++counter;
            rng -= weights.intValue();
        }
        switch (selected) {
            case 0: {
                ColdSnapGunner coldSnapGunner = new StandardHorde.StandardGunner(Register.COLDSNAPGUNNER, (class_1937)this.world);
                class_2338 pos = this.hordeSpawnAttempter(coldSnapGunner.method_5864());
                if (pos == null) {
                    return;
                }
                coldSnapGunner = this.gunnerSpawnRules(this.world, pos);
                coldSnapGunner.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
                this.injectGoal((class_1314)coldSnapGunner, ColdSnapHorde.defaultHordeData, ColdSnapHorde.defaultHordeData.getGoalMovementSpeed());
                this.world.method_8649((class_1297)coldSnapGunner);
                this.activeHordeMembers.add(coldSnapGunner);
                break;
            }
            case 1: {
                ColdSnapStabber coldSnapStabber = new StandardHorde.StandardStabber(Register.COLDSNAPSTABBER, (class_1937)this.world);
                class_2338 pos = this.hordeSpawnAttempter(coldSnapStabber.method_5864());
                if (pos == null) {
                    return;
                }
                coldSnapStabber = this.stabberSpawnRules(this.world, pos);
                coldSnapStabber.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
                this.injectGoal((class_1314)coldSnapStabber, ColdSnapHorde.defaultHordeData, ColdSnapHorde.defaultHordeData.getGoalMovementSpeed());
                this.world.method_8649((class_1297)coldSnapStabber);
                this.activeHordeMembers.add(coldSnapStabber);
                break;
            }
            case 2: {
                ColdSnapSnowballer coldSnapSnowballer = new StandardHorde.StandardSnowballer(Register.COLDSNAPSNOWBALLER, (class_1937)this.world);
                class_2338 pos = this.hordeSpawnAttempter(coldSnapSnowballer.method_5864());
                if (pos == null) {
                    return;
                }
                coldSnapSnowballer = this.snowballerSpawnRules(this.world, pos);
                coldSnapSnowballer.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
                this.injectGoal((class_1314)coldSnapSnowballer, ColdSnapHorde.defaultHordeData, ColdSnapHorde.defaultHordeData.getGoalMovementSpeed());
                this.world.method_8649((class_1297)coldSnapSnowballer);
                this.activeHordeMembers.add(coldSnapSnowballer);
                break;
            }
            case 3: {
                ColdSnapZapper coldSnapZapper = new StandardHorde.StandardZapper(Register.COLDSNAPZAPPER, (class_1937)this.world);
                class_2338 pos = this.hordeSpawnAttempter(coldSnapZapper.method_5864());
                if (pos == null) {
                    return;
                }
                coldSnapZapper = this.zapperSpawnRules(this.world, pos);
                coldSnapZapper.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
                this.injectGoal((class_1314)coldSnapZapper, ColdSnapHorde.defaultHordeData, ColdSnapHorde.defaultHordeData.getGoalMovementSpeed());
                this.world.method_8649((class_1297)coldSnapZapper);
                this.activeHordeMembers.add(coldSnapZapper);
                break;
            }
            case 4: {
                ColdSnapGifter coldSnapGifter = new StandardHorde.StandardGifter(Register.COLDSNAPGIFTER, (class_1937)this.world);
                class_2338 pos = this.hordeSpawnAttempter(coldSnapGifter.method_5864());
                if (pos == null) {
                    return;
                }
                coldSnapGifter = this.gifterSpawnRules(this.world, pos);
                coldSnapGifter.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
                this.injectGoal((class_1314)coldSnapGifter, ColdSnapHorde.defaultHordeData, ColdSnapHorde.defaultHordeData.getGoalMovementSpeed());
                this.world.method_8649((class_1297)coldSnapGifter);
                this.activeHordeMembers.add(coldSnapGifter);
                break;
            }
            case 5: {
                ColdSnapBrawler coldSnapBrawler = new StandardHorde.StandardBrawler(Register.COLDSNAPBRAWLER, (class_1937)this.world);
                class_2338 pos = this.hordeSpawnAttempter(coldSnapBrawler.method_5864());
                if (pos == null) {
                    return;
                }
                coldSnapBrawler = this.brawlerSpawnRules(this.world, pos);
                coldSnapBrawler.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
                this.injectGoal((class_1314)coldSnapBrawler, ColdSnapHorde.defaultHordeData, ColdSnapHorde.defaultHordeData.getGoalMovementSpeed());
                this.world.method_8649((class_1297)coldSnapBrawler);
                this.activeHordeMembers.add(coldSnapBrawler);
            }
        }
    }

    public void injectGoal(class_1314 entity, EntityHordeData entityHordeData, double movementSpeedModifier) {
        super.injectGoal(entity, entityHordeData, movementSpeedModifier);
        if (entity instanceof GenericHordeMember) {
            ((GenericHordeMember)entity).setHordeStatus(true);
        }
    }

    private ColdSnapGunner gunnerSpawnRules(class_3218 world, class_2338 pos) {
        ColdSnapGunner coldSnapGunner = null;
        boolean swamp = world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9364);
        if (swamp) {
            coldSnapGunner = new PlagueHorde.PlagueGunner(Register.PCOLDSNAPGUNNER, (class_1937)world);
        } else if (world.method_27983().toString().contains("end")) {
            coldSnapGunner = new EndHorde.EndGunner(Register.ECOLDSNAPGUNNER, (class_1937)world);
        } else if (world.method_27983().toString().contains("nether")) {
            coldSnapGunner = new EndHorde.EndGunner(Register.NCOLDSNAPGUNNER, (class_1937)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.method_8520(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapGunner = new NetherHorde.NetherGunner(Register.NCOLDSNAPGUNNER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGunner == null) {
                    coldSnapGunner = new EndHorde.EndGunner(Register.ECOLDSNAPGUNNER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGunner == null) {
                    coldSnapGunner = new PlagueHorde.PlagueGunner(Register.PCOLDSNAPGUNNER, (class_1937)world);
                }
                if (coldSnapGunner == null) {
                    coldSnapGunner = new StandardHorde.StandardGunner(Register.COLDSNAPGUNNER, (class_1937)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapGunner == null) {
                    coldSnapGunner = new PlagueHorde.PlagueGunner(Register.PCOLDSNAPGUNNER, (class_1937)world);
                }
                if (coldSnapGunner == null) {
                    coldSnapGunner = new StandardHorde.StandardGunner(Register.COLDSNAPGUNNER, (class_1937)world);
                }
            }
        } else {
            coldSnapGunner = new NetherHorde.NetherGunner(Register.NCOLDSNAPGUNNER, (class_1937)world);
        }
        return coldSnapGunner;
    }

    private ColdSnapStabber stabberSpawnRules(class_3218 world, class_2338 pos) {
        ColdSnapStabber coldSnapStabber = null;
        boolean swamp = world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9364);
        if (swamp) {
            coldSnapStabber = new PlagueHorde.PlagueStabber(Register.PCOLDSNAPSTABBER, (class_1937)world);
        } else if (world.method_27983().toString().contains("end")) {
            coldSnapStabber = new EndHorde.EndStabber(Register.ECOLDSNAPSTABBER, (class_1937)world);
        } else if (world.method_27983().toString().contains("nether")) {
            coldSnapStabber = new NetherHorde.NetherStabber(Register.NCOLDSNAPSTABBER, (class_1937)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.method_8520(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapStabber = new NetherHorde.NetherStabber(Register.NCOLDSNAPSTABBER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapStabber == null) {
                    coldSnapStabber = new EndHorde.EndStabber(Register.ECOLDSNAPSTABBER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapStabber == null) {
                    coldSnapStabber = new PlagueHorde.PlagueStabber(Register.PCOLDSNAPSTABBER, (class_1937)world);
                }
                if (coldSnapStabber == null) {
                    coldSnapStabber = new StandardHorde.StandardStabber(Register.COLDSNAPSTABBER, (class_1937)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapStabber == null) {
                    coldSnapStabber = new PlagueHorde.PlagueStabber(Register.PCOLDSNAPSTABBER, (class_1937)world);
                }
                if (coldSnapStabber == null) {
                    coldSnapStabber = new StandardHorde.StandardStabber(Register.COLDSNAPSTABBER, (class_1937)world);
                }
            }
        } else {
            coldSnapStabber = new NetherHorde.NetherStabber(Register.NCOLDSNAPSTABBER, (class_1937)world);
        }
        return coldSnapStabber;
    }

    private ColdSnapSnowballer snowballerSpawnRules(class_3218 world, class_2338 pos) {
        ColdSnapSnowballer coldSnapSnowballer = null;
        boolean swamp = world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9364);
        if (swamp) {
            coldSnapSnowballer = new PlagueHorde.PlagueSnowballer(Register.PCOLDSNAPSNOWBALLER, (class_1937)world);
        } else if (world.method_27983().toString().contains("end")) {
            coldSnapSnowballer = new EndHorde.EndSnowballer(Register.ECOLDSNAPSNOWBALLER, (class_1937)world);
        } else if (world.method_27983().toString().contains("nether")) {
            coldSnapSnowballer = new NetherHorde.NetherSnowballer(Register.NCOLDSNAPSNOWBALLER, (class_1937)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.method_8520(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapSnowballer = new NetherHorde.NetherSnowballer(Register.NCOLDSNAPSNOWBALLER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapSnowballer == null) {
                    coldSnapSnowballer = new EndHorde.EndSnowballer(Register.ECOLDSNAPSNOWBALLER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapSnowballer == null) {
                    coldSnapSnowballer = new PlagueHorde.PlagueSnowballer(Register.PCOLDSNAPSNOWBALLER, (class_1937)world);
                }
                if (coldSnapSnowballer == null) {
                    coldSnapSnowballer = new StandardHorde.StandardSnowballer(Register.COLDSNAPSNOWBALLER, (class_1937)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapSnowballer == null) {
                    coldSnapSnowballer = new PlagueHorde.PlagueSnowballer(Register.PCOLDSNAPSNOWBALLER, (class_1937)world);
                }
                if (coldSnapSnowballer == null) {
                    coldSnapSnowballer = new StandardHorde.StandardSnowballer(Register.COLDSNAPSNOWBALLER, (class_1937)world);
                }
            }
        } else {
            coldSnapSnowballer = new NetherHorde.NetherSnowballer(Register.NCOLDSNAPSNOWBALLER, (class_1937)world);
        }
        return coldSnapSnowballer;
    }

    private ColdSnapGifter gifterSpawnRules(class_3218 world, class_2338 pos) {
        ColdSnapGifter coldSnapGifter = null;
        boolean swamp = world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9364);
        if (swamp) {
            coldSnapGifter = new PlagueHorde.PlagueGifter(Register.PCOLDSNAPGIFTER, (class_1937)world);
        } else if (world.method_27983().toString().contains("end")) {
            coldSnapGifter = new EndHorde.EndGifter(Register.ECOLDSNAPGIFTER, (class_1937)world);
        } else if (world.method_27983().toString().contains("nether")) {
            coldSnapGifter = new NetherHorde.NetherGifter(Register.NCOLDSNAPGIFTER, (class_1937)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.method_8520(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapGifter = new NetherHorde.NetherGifter(Register.NCOLDSNAPGIFTER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGifter == null) {
                    coldSnapGifter = new EndHorde.EndGifter(Register.ECOLDSNAPGIFTER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapGifter == null) {
                    coldSnapGifter = new PlagueHorde.PlagueGifter(Register.PCOLDSNAPGIFTER, (class_1937)world);
                }
                if (coldSnapGifter == null) {
                    coldSnapGifter = new StandardHorde.StandardGifter(Register.COLDSNAPGIFTER, (class_1937)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapGifter == null) {
                    coldSnapGifter = new PlagueHorde.PlagueGifter(Register.PCOLDSNAPGIFTER, (class_1937)world);
                }
                if (coldSnapGifter == null) {
                    coldSnapGifter = new StandardHorde.StandardGifter(Register.COLDSNAPGIFTER, (class_1937)world);
                }
            }
        } else {
            coldSnapGifter = new NetherHorde.NetherGifter(Register.NCOLDSNAPGIFTER, (class_1937)world);
        }
        return coldSnapGifter;
    }

    private ColdSnapZapper zapperSpawnRules(class_3218 world, class_2338 pos) {
        ColdSnapZapper coldSnapZapper = null;
        boolean swamp = world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9364);
        if (swamp) {
            coldSnapZapper = new PlagueHorde.PlagueZapper(Register.PCOLDSNAPZAPPER, (class_1937)world);
        } else if (world.method_27983().toString().contains("end")) {
            coldSnapZapper = new EndHorde.EndZapper(Register.ECOLDSNAPZAPPER, (class_1937)world);
        } else if (world.method_27983().toString().contains("nether")) {
            coldSnapZapper = new NetherHorde.NetherZapper(Register.NCOLDSNAPZAPPER, (class_1937)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.method_8520(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapZapper = new NetherHorde.NetherZapper(Register.NCOLDSNAPZAPPER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapZapper == null) {
                    coldSnapZapper = new EndHorde.EndZapper(Register.ECOLDSNAPZAPPER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapZapper == null) {
                    coldSnapZapper = new PlagueHorde.PlagueZapper(Register.PCOLDSNAPZAPPER, (class_1937)world);
                }
                if (coldSnapZapper == null) {
                    coldSnapZapper = new StandardHorde.StandardZapper(Register.COLDSNAPZAPPER, (class_1937)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapZapper == null) {
                    coldSnapZapper = new PlagueHorde.PlagueZapper(Register.PCOLDSNAPZAPPER, (class_1937)world);
                }
                if (coldSnapZapper == null) {
                    coldSnapZapper = new StandardHorde.StandardZapper(Register.COLDSNAPZAPPER, (class_1937)world);
                }
            }
        } else {
            coldSnapZapper = new NetherHorde.NetherZapper(Register.NCOLDSNAPZAPPER, (class_1937)world);
        }
        return coldSnapZapper;
    }

    private ColdSnapBrawler brawlerSpawnRules(class_3218 world, class_2338 pos) {
        ColdSnapBrawler coldSnapBrawler = null;
        boolean swamp = world.method_23753(pos).method_8688().equals((Object)class_1959.class_1961.field_9364);
        if (swamp) {
            coldSnapBrawler = new PlagueHorde.PlagueBrawler(Register.PCOLDSNAPBRAWLER, (class_1937)world);
        } else if (world.method_27983().toString().contains("end")) {
            coldSnapBrawler = new EndHorde.EndBrawler(Register.ECOLDSNAPBRAWLER, (class_1937)world);
        } else if (world.method_27983().toString().contains("nether")) {
            coldSnapBrawler = new NetherHorde.NetherBrawler(Register.NCOLDSNAPBRAWLER, (class_1937)world);
        } else if (this.trueBiomeCheck(world, pos)) {
            if (!world.method_8520(pos)) {
                Random random = new Random();
                int chance = random.nextInt(100);
                if (chance <= 5) {
                    coldSnapBrawler = new NetherHorde.NetherBrawler(Register.NCOLDSNAPBRAWLER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapBrawler == null) {
                    coldSnapBrawler = new EndHorde.EndBrawler(Register.ECOLDSNAPBRAWLER, (class_1937)world);
                }
                if ((chance = random.nextInt(100)) <= 5 && coldSnapBrawler == null) {
                    coldSnapBrawler = new PlagueHorde.PlagueBrawler(Register.PCOLDSNAPBRAWLER, (class_1937)world);
                }
                if (coldSnapBrawler == null) {
                    coldSnapBrawler = new StandardHorde.StandardBrawler(Register.COLDSNAPBRAWLER, (class_1937)world);
                }
            } else {
                Random random = new Random();
                int chance = random.nextInt(150);
                if (chance <= 10 && coldSnapBrawler == null) {
                    coldSnapBrawler = new PlagueHorde.PlagueBrawler(Register.PCOLDSNAPBRAWLER, (class_1937)world);
                }
                if (coldSnapBrawler == null) {
                    coldSnapBrawler = new StandardHorde.StandardBrawler(Register.COLDSNAPBRAWLER, (class_1937)world);
                }
            }
        } else {
            coldSnapBrawler = new NetherHorde.NetherBrawler(Register.NCOLDSNAPBRAWLER, (class_1937)world);
        }
        return coldSnapBrawler;
    }
}

