/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.client.model.geo;

import com.github.eterdelta.crittersandcompanions.entity.OtterEntity;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class OtterModel
extends AnimatedGeoModel<OtterEntity> {
    private static final ResourceLocation[] MODELS = new ResourceLocation[]{new ResourceLocation("crittersandcompanions", "geo/otter.geo.json"), new ResourceLocation("crittersandcompanions", "geo/baby_otter.geo.json")};
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("crittersandcompanions", "textures/entity/otter.png"), new ResourceLocation("crittersandcompanions", "textures/entity/baby_otter.png")};
    private static final ResourceLocation[] ANIMATIONS = new ResourceLocation[]{new ResourceLocation("crittersandcompanions", "animations/otter.animation.json"), new ResourceLocation("crittersandcompanions", "animations/baby_otter.animation.json")};

    public ResourceLocation getModelLocation(OtterEntity object) {
        return MODELS[object.m_6162_() ? 1 : 0];
    }

    public ResourceLocation getTextureLocation(OtterEntity object) {
        return TEXTURES[object.m_6162_() ? 1 : 0];
    }

    public ResourceLocation getAnimationFileLocation(OtterEntity animatable) {
        return ANIMATIONS[animatable.m_6162_() ? 1 : 0];
    }

    public void setLivingAnimations(OtterEntity entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone rotBone = this.getAnimationProcessor().getBone(entity.m_20069_() ? "main" : "head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        if (!entity.isEating() && !entity.isFloating()) {
            rotBone.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
            rotBone.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

