/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.client.model.geo;

import com.github.eterdelta.crittersandcompanions.entity.SeaBunnyEntity;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class SeaBunnyModel
extends AnimatedGeoModel<SeaBunnyEntity> {
    private static final ResourceLocation MODEL = new ResourceLocation("crittersandcompanions", "geo/sea_bunny.geo.json");
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("crittersandcompanions", "textures/entity/sea_bunny_white.png"), new ResourceLocation("crittersandcompanions", "textures/entity/sea_bunny_blue.png"), new ResourceLocation("crittersandcompanions", "textures/entity/sea_bunny_yellow.png")};
    private static final ResourceLocation ANIMATION = new ResourceLocation("crittersandcompanions", "animations/sea_bunny.animation.json");

    public ResourceLocation getModelLocation(SeaBunnyEntity object) {
        return MODEL;
    }

    public ResourceLocation getTextureLocation(SeaBunnyEntity object) {
        return TEXTURES[object.getVariant()];
    }

    public ResourceLocation getAnimationFileLocation(SeaBunnyEntity animatable) {
        return ANIMATION;
    }

    public void setLivingAnimations(SeaBunnyEntity entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone mainBone = this.getAnimationProcessor().getBone("main");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        mainBone.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        if (entity.isClimbing()) {
            mainBone.setRotationX(1.5707964f);
        }
    }
}

