/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DragonflyEntity
extends PathfinderMob
implements IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private BlockPos targetPosition;

    public DragonflyEntity(EntityType<? extends DragonflyEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.OPEN, 1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0);
    }

    public static boolean checkDragonflySpawnRules(EntityType<DragonflyEntity> entityType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, Random random) {
        return blockPos.m_123342_() > 63 && levelAccessor.m_8055_(blockPos).m_60795_() && levelAccessor.m_45524_(blockPos, 0) > 8;
    }

    protected int m_6552_(Player player) {
        return this.f_19796_.nextInt(2, 5);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
    }

    public float m_21692_(BlockPos blockPos) {
        return this.f_19853_.m_204166_(blockPos).m_203565_(Biomes.f_48208_) ? 10.0f : 5.0f;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!(this.targetPosition == null || this.f_19853_.m_46859_(this.targetPosition) && this.targetPosition.m_123342_() > this.f_19853_.m_141937_())) {
            this.targetPosition = null;
        }
        if (this.targetPosition == null || this.f_19796_.nextInt(30) == 0 || this.targetPosition.m_203195_((Position)this.m_20182_(), 2.0)) {
            Vec3 randomPos = RandomPos.m_148542_((PathfinderMob)this, () -> new BlockPos(this.m_20185_() + (double)this.f_19796_.nextInt(7) - (double)this.f_19796_.nextInt(7), this.m_20186_() + (double)this.f_19796_.nextInt(6) - 2.0, this.m_20189_() + (double)this.f_19796_.nextInt(7) - (double)this.f_19796_.nextInt(7)));
            this.targetPosition = randomPos == null ? this.m_142538_() : new BlockPos(randomPos);
        }
        double d0 = (double)this.targetPosition.m_123341_() + 0.5 - this.m_20185_();
        double d1 = (double)this.targetPosition.m_123342_() + 0.1 - this.m_20186_();
        double d2 = (double)this.targetPosition.m_123343_() + 0.5 - this.m_20189_();
        Vec3 deltaMovement = this.m_20184_();
        Vec3 signumDeltaMovement = deltaMovement.m_82520_((Math.signum(d0) * 0.5 - deltaMovement.f_82479_) * (double)0.1f, (Math.signum(d1) * (double)0.7f - deltaMovement.f_82480_) * (double)0.1f, (Math.signum(d2) * 0.5 - deltaMovement.f_82481_) * (double)0.1f);
        this.m_20256_(signumDeltaMovement);
        float angle = (float)(Mth.m_14136_((double)signumDeltaMovement.f_82481_, (double)signumDeltaMovement.f_82479_) * 57.2957763671875) - 90.0f;
        float wrappedAngle = Mth.m_14177_((float)(angle - this.m_146908_()));
        this.f_20902_ = 0.5f;
        this.m_146922_(this.m_146908_() + wrappedAngle);
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_7840_(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("dragonfly_fly", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

