/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class DumboOctopusEntity
extends WaterAnimal
implements IAnimatable,
Bucketable {
    private static final EntityDataAccessor<Boolean> RESTING = SynchedEntityData.m_135353_(DumboOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(DumboOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(DumboOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    public int restTimer;

    public DumboOctopusEntity(EntityType<? extends DumboOctopusEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new DumboOctopusMoveControl(90, 90, 1.0f, 1.0f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 180);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, 0.06);
    }

    public static boolean checkDumboOctopusSpawnRules(EntityType<DumboOctopusEntity> entityType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, Random random) {
        return blockPos.m_123342_() <= 50 && WaterAnimal.m_186237_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)blockPos, (Random)random);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_142392_();
    }

    public boolean m_6785_(double distance) {
        return !this.m_142392_() && !this.m_8077_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RESTING, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new RandomSwimmingGoal(this, 1.0, 40));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Resting", this.isResting());
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setResting(compound.m_128471_("Resting"));
        this.setVariant(compound.m_128451_("Variant"));
    }

    public boolean m_142392_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_142139_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public void m_142146_(ItemStack bucketStack) {
        CompoundTag bucketCompound = bucketStack.m_41784_();
        Bucketable.m_148822_((Mob)this, (ItemStack)bucketStack);
        bucketCompound.m_128405_("BucketVariant", this.getVariant());
    }

    public void m_142278_(CompoundTag bucketCompound) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)bucketCompound);
        if (bucketCompound.m_128441_("BucketVariant")) {
            this.setVariant(bucketCompound.m_128451_("BucketVariant"));
        }
    }

    public ItemStack m_142563_() {
        return new ItemStack((ItemLike)CACItems.DUMBO_OCTOPUS_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_144077_;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.5f;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.m_5776_() && this.m_6142_()) {
            if (this.m_20069_()) {
                if (this.isResting()) {
                    if (--this.restTimer <= 0) {
                        this.setResting(false);
                    }
                    this.m_20256_(this.m_20184_().m_82492_(0.0, 0.01, 0.0));
                } else if (this.f_19796_.nextFloat() <= 0.001f) {
                    this.restTimer = this.f_19796_.nextInt(200, 601);
                    this.setResting(true);
                }
            } else {
                this.setResting(false);
            }
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public void m_7023_(Vec3 speed) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), speed);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(speed);
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)interactionHand, (LivingEntity)this).orElse(super.m_6071_(player, interactionHand));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CompoundTag p_146750_) {
        this.setVariant(this.f_19796_.nextInt(0, 4));
        return spawnGroupData;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isResting()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dumbo_octopus_idle", Boolean.valueOf(true)));
        } else if (this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dumbo_octopus_swim", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("dumbo_octopus_on_land", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 4.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean isResting() {
        return (Boolean)this.f_19804_.m_135370_(RESTING);
    }

    public void setResting(boolean resting) {
        this.f_19804_.m_135381_(RESTING, (Object)resting);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)Mth.m_14045_((int)variant, (int)0, (int)3));
    }

    class DumboOctopusMoveControl
    extends SmoothSwimmingMoveControl {
        public DumboOctopusMoveControl(int maxTurnX, int maxTurnY, float inWaterSpeedModifier, float outsideWaterSpeedModifier, boolean applyGravity) {
            super((Mob)DumboOctopusEntity.this, maxTurnX, maxTurnY, inWaterSpeedModifier, outsideWaterSpeedModifier, applyGravity);
        }

        public void m_8126_() {
            if (!DumboOctopusEntity.this.isResting()) {
                super.m_8126_();
            }
        }
    }

    static class RandomSwimmingGoal
    extends net.minecraft.world.entity.ai.goal.RandomSwimmingGoal {
        private final DumboOctopusEntity dumboOctopus;

        public RandomSwimmingGoal(DumboOctopusEntity dumboOctopus, double speedModifier, int interval) {
            super((PathfinderMob)dumboOctopus, speedModifier, interval);
            this.dumboOctopus = dumboOctopus;
        }

        public boolean m_8036_() {
            return !this.dumboOctopus.isResting() && super.m_8036_();
        }
    }
}

