/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.handler;

import com.github.eterdelta.crittersandcompanions.entity.DragonflyEntity;
import com.github.eterdelta.crittersandcompanions.entity.DumboOctopusEntity;
import com.github.eterdelta.crittersandcompanions.entity.LeafInsectEntity;
import com.github.eterdelta.crittersandcompanions.entity.OtterEntity;
import com.github.eterdelta.crittersandcompanions.entity.SeaBunnyEntity;
import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="crittersandcompanions")
public class SpawnHandler {
    @SubscribeEvent
    public static void onLivingCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Drowned) {
            Drowned drowned = (Drowned)livingEntity;
            if (event.getSpawnReason() == MobSpawnType.NATURAL && drowned.m_21187_().nextFloat() <= 0.05f) {
                drowned.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)CACItems.CLAM.get()));
            }
        }
    }

    @SubscribeEvent
    public static void onBiomeLoading(BiomeLoadingEvent event) {
        if (event.getName() != null) {
            ResourceKey biome = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)event.getName());
            if (biome == Biomes.f_48208_) {
                event.getSpawns().getSpawner(MobCategory.WATER_CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)CACEntities.OTTER.get(), 2, 3, 5));
                event.getSpawns().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)CACEntities.KOI_FISH.get(), 4, 2, 5));
                event.getSpawns().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)CACEntities.DRAGONFLY.get(), 6, 1, 1));
            } else if (biome == Biomes.f_48174_ || biome == Biomes.f_48225_) {
                event.getSpawns().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)CACEntities.SEA_BUNNY.get(), 32, 1, 2));
                event.getSpawns().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)CACEntities.DUMBO_OCTOPUS.get(), 4, 1, 1));
            } else if (biome == Biomes.f_48167_ || biome == Biomes.f_48170_) {
                event.getSpawns().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)CACEntities.SEA_BUNNY.get(), 32, 1, 3));
                event.getSpawns().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)CACEntities.DUMBO_OCTOPUS.get(), 4, 1, 1));
            } else if (biome == Biomes.f_48166_) {
                event.getSpawns().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)CACEntities.SEA_BUNNY.get(), 64, 1, 4));
                event.getSpawns().getSpawner(MobCategory.WATER_AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)CACEntities.DUMBO_OCTOPUS.get(), 6, 1, 1));
            } else if (biome == Biomes.f_48149_ || biome == Biomes.f_48205_) {
                event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)CACEntities.FERRET.get(), 3, 2, 3));
            }
            if (event.getCategory() == Biome.BiomeCategory.FOREST) {
                event.getSpawns().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)CACEntities.LEAF_INSECT.get(), 10, 1, 1));
            } else if (event.getCategory() == Biome.BiomeCategory.JUNGLE) {
                event.getSpawns().getSpawner(MobCategory.AMBIENT).add(new MobSpawnSettings.SpawnerData((EntityType)CACEntities.LEAF_INSECT.get(), 8, 1, 1));
                event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)CACEntities.RED_PANDA.get(), 6, 1, 2));
            } else if (event.getCategory() == Biome.BiomeCategory.PLAINS) {
                event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)CACEntities.FERRET.get(), 3, 2, 3));
            }
        }
    }

    public static void registerSpawnPlacements() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.OTTER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, OtterEntity::checkOtterSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.KOI_FISH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_186237_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.DRAGONFLY.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, DragonflyEntity::checkDragonflySpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.SEA_BUNNY.get()), (SpawnPlacements.Type)SpawnPlacements.Type.create((String)"ON_WATER_GROUND", (levelReader, blockPos, entityType) -> levelReader.m_6425_(blockPos).m_205070_(FluidTags.f_13131_) && levelReader.m_8055_(blockPos.m_7495_()).m_60783_((BlockGetter)levelReader, blockPos.m_7495_(), Direction.UP)), (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR, SeaBunnyEntity::checkSeaBunnySpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.FERRET.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.DUMBO_OCTOPUS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DumboOctopusEntity::checkDumboOctopusSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.LEAF_INSECT.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, LeafInsectEntity::checkLeafInsectSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)CACEntities.RED_PANDA.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_27577_);
    }
}

