/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.blockentity;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1937;
import net.minecraft.class_2260;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5558;
import org.apache.commons.lang3.tuple.Pair;
import tfar.davespotioneering.Events;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.duck.BrewingStandDuck;
import tfar.davespotioneering.init.ModBlockEntityTypes;
import tfar.davespotioneering.inv.BrewingHandler;
import tfar.davespotioneering.menu.AdvancedBrewingStandContainer;

public class AdvancedBrewingStandBlockEntity
extends class_2586
implements class_3908,
BrewingStandDuck {
    public static final int[] POTIONS = new int[]{0, 1, 2};
    public static final int[] INGREDIENTS = new int[]{3, 4, 5, 6, 7};
    public static final int FUEL = 8;
    public static final int TIME = 200;
    protected int xp;
    public static final int SLOTS = POTIONS.length + INGREDIENTS.length + 1;
    private final BrewingHandler brewingHandler = new BrewingHandler(SLOTS);
    private int brewTime;
    private boolean[] filledSlots;
    private class_1792 ingredientID;
    private int fuel;
    protected final class_3913 data = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return AdvancedBrewingStandBlockEntity.this.brewTime;
                }
                case 1: {
                    return AdvancedBrewingStandBlockEntity.this.fuel;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    AdvancedBrewingStandBlockEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    AdvancedBrewingStandBlockEntity.this.fuel = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public AdvancedBrewingStandBlockEntity(class_2338 blockPos, class_2680 blockState) {
        this(ModBlockEntityTypes.COMPOUND_BREWING_STAND, blockPos, blockState);
    }

    protected AdvancedBrewingStandBlockEntity(class_2591<?> typeIn, class_2338 blockPos, class_2680 blockState) {
        super(typeIn, blockPos, blockState);
    }

    protected class_2561 getDefaultName() {
        return class_2561.method_43471((String)"container.davespotioneering.compound_brewing");
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 blockState, AdvancedBrewingStandBlockEntity brewingStandBlockEntity) {
        class_1799 fuelStack = brewingStandBlockEntity.brewingHandler.method_5438(8);
        if (brewingStandBlockEntity.fuel <= 0 && fuelStack.method_7909() == class_1802.field_8183) {
            brewingStandBlockEntity.fuel = 20;
            fuelStack.method_7934(1);
            AdvancedBrewingStandBlockEntity.markDirty(world, blockPos, blockState);
        }
        boolean canBrew = brewingStandBlockEntity.canBrew();
        boolean brewing = brewingStandBlockEntity.brewTime > 0;
        class_1799 ing = (class_1799)brewingStandBlockEntity.getPriorityIngredient().getRight();
        if (brewing) {
            boolean done;
            --brewingStandBlockEntity.brewTime;
            boolean bl = done = brewingStandBlockEntity.brewTime == 0;
            if (done && canBrew) {
                brewingStandBlockEntity.brewPotions();
                AdvancedBrewingStandBlockEntity.markDirty(world, blockPos, blockState);
            } else if (!canBrew) {
                brewingStandBlockEntity.brewTime = 0;
                AdvancedBrewingStandBlockEntity.markDirty(world, blockPos, blockState);
            } else if (brewingStandBlockEntity.ingredientID != ing.method_7909()) {
                brewingStandBlockEntity.brewTime = 0;
                AdvancedBrewingStandBlockEntity.markDirty(world, blockPos, blockState);
            }
        } else if (canBrew && brewingStandBlockEntity.fuel > 0) {
            --brewingStandBlockEntity.fuel;
            brewingStandBlockEntity.brewTime = 200;
            brewingStandBlockEntity.ingredientID = ing.method_7909();
            AdvancedBrewingStandBlockEntity.markDirty(world, blockPos, blockState);
        }
        if (!brewingStandBlockEntity.field_11863.field_9236) {
            brewingStandBlockEntity.setBottleBlockStates();
        }
    }

    private void setBottleBlockStates() {
        boolean[] aboolean = this.createFilledSlotsArray();
        if (!Arrays.equals(aboolean, this.filledSlots)) {
            this.filledSlots = aboolean;
            class_2680 blockstate = this.field_11863.method_8320(this.method_11016());
            if (!(blockstate.method_26204() instanceof class_2260)) {
                return;
            }
            for (int i = 0; i < class_2260.field_10700.length; ++i) {
                blockstate = (class_2680)blockstate.method_11657((class_2769)class_2260.field_10700[i], (Comparable)Boolean.valueOf(aboolean[i]));
            }
            this.field_11863.method_8652(this.field_11867, blockstate, 2);
        }
    }

    public Pair<Integer, class_1799> getPriorityIngredient() {
        for (int i = 7; i > 2; --i) {
            class_1799 ing = this.brewingHandler.method_5438(i);
            if (ing.method_7960() || !this.isThereARecipe(ing)) continue;
            return Pair.of((Object)i, (Object)ing);
        }
        return Pair.of((Object)-1, (Object)class_1799.field_8037);
    }

    public boolean isThereARecipe(class_1799 ingredient) {
        for (int i : POTIONS) {
            class_1799 potion = this.brewingHandler.method_5438(i);
            if (!class_1845.method_8072((class_1799)potion, (class_1799)ingredient)) continue;
            return true;
        }
        return false;
    }

    public boolean[] createFilledSlotsArray() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (this.brewingHandler.method_5438(i).method_7960()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    private boolean canBrew() {
        class_1799 ing = (class_1799)this.getPriorityIngredient().getRight();
        if (!ing.method_7960()) {
            if (ing.method_7909() == class_1802.field_8103 && this.canMilkify()) {
                return true;
            }
            return this.isThereARecipe(ing);
        }
        return false;
    }

    private void brewPotions() {
        Pair<Integer, class_1799> pair = this.getPriorityIngredient();
        class_1799 ingredient = (class_1799)pair.getRight();
        boolean canMilkify = ingredient.method_7909() == class_1802.field_8103;
        Util.brewPotions(this.brewingHandler.getItems(), ingredient, POTIONS);
        Events.potionBrew(this, ingredient);
        if (canMilkify) {
            for (int i = 0; i < POTIONS.length; ++i) {
                class_1799 potion = this.brewingHandler.method_5438(i);
                Util.milkifyPotion(potion);
            }
        }
        class_2338 blockpos = this.method_11016();
        if (ingredient.method_7909().method_7857()) {
            class_1799 ingredientContainerItem = ingredient.method_7909().method_7858().method_7854();
            ingredient.method_7934(1);
            if (ingredient.method_7960()) {
                ingredient = ingredientContainerItem;
            } else if (!this.field_11863.field_9236) {
                class_1264.method_5449((class_1937)this.field_11863, (double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260(), (class_1799)ingredientContainerItem);
            }
        } else {
            ingredient.method_7934(1);
        }
        this.brewingHandler.method_5447((Integer)pair.getLeft(), ingredient);
        this.field_11863.method_20290(1035, blockpos, 0);
    }

    private boolean canMilkify() {
        for (int i : POTIONS) {
            class_1842 potion;
            String name;
            class_1799 potionStack = this.brewingHandler.method_5438(i);
            if (!(potionStack.method_7909() instanceof class_1812) || (name = class_2378.field_11143.method_10221((Object)(potion = class_1844.method_8063((class_1799)potionStack))).toString()).contains("long") || name.contains("strong")) continue;
            return true;
        }
        return false;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.brewingHandler.getItems());
        this.brewTime = nbt.method_10568("BrewTime");
        this.fuel = nbt.method_10550("Fuel");
        this.xp = nbt.method_10550("xp");
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10575("BrewTime", (short)this.brewTime);
        class_1262.method_5426((class_2487)compound, this.brewingHandler.getItems());
        compound.method_10569("Fuel", this.fuel);
        compound.method_10569("xp", this.xp);
    }

    public class_2561 method_5476() {
        return this.getDefaultName();
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 playerInventory, class_1657 player) {
        return new AdvancedBrewingStandContainer(id, playerInventory, (class_1263)this.brewingHandler, this.data, this);
    }

    @Override
    public void addXp(double xp) {
        this.xp = (int)((double)this.xp + xp);
    }

    @Override
    public void dump(class_1657 player) {
        if (this.xp > 0) {
            Util.splitAndSpawnExperience(this.field_11863, player.method_19538(), this.xp);
            this.xp = 0;
            this.method_5431();
        }
    }

    public BrewingHandler getBrewingHandler() {
        return this.brewingHandler;
    }

    @Nullable
    public static <E extends class_2586, A extends class_2586> class_5558<A> checkType(class_2591<A> blockEntityType, class_2591<E> blockEntityType2, class_5558<? super E> blockEntityTicker) {
        return blockEntityType2 == blockEntityType ? blockEntityTicker : null;
    }

    protected static void markDirty(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        world.method_8524(blockPos);
        if (!blockState.method_26215()) {
            world.method_8455(blockPos, blockState.method_26204());
        }
    }
}

