/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1058;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import tfar.davespotioneering.config.ClothConfig;
import tfar.davespotioneering.init.ModSoundEvents;
import tfar.davespotioneering.item.GauntletItem;
import tfar.davespotioneering.mixin.IngameGuiAccess;

public class GauntletHUD {
    public static final class_2960 GAUNTLET_ICON_LOC = new class_2960("davespotioneering", "textures/gauntlet_icons/");
    private static final int TEX_H = 41;
    private static class_1842 activePotion = null;
    private static class_1842 prePotion = null;
    private static class_1842 postPotion = null;
    private static final class_2960 hud_texture = GauntletHUD.getGauntletIconLoc("hud");
    public static final class_310 mc = class_310.method_1551();
    private static boolean forwardCycle = false;
    private static boolean backwardCycle = false;
    private static final int maxCooldown = 40;
    private static int cooldown = 40;

    public static class_2960 getGauntletIconLoc(String fileName) {
        return new class_2960(GAUNTLET_ICON_LOC.method_12836(), GAUNTLET_ICON_LOC.method_12832() + fileName + ".png");
    }

    public static void init(class_1842 activePotion, class_1842 prePotion, class_1842 postPotion) {
        GauntletHUD.activePotion = activePotion;
        GauntletHUD.prePotion = prePotion;
        GauntletHUD.postPotion = postPotion;
    }

    public static void render(class_4587 matrixStack) {
        class_746 player;
        matrixStack.method_22903();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)hud_texture);
        class_329 hud = GauntletHUD.mc.field_1705;
        int fade = ((IngameGuiAccess)hud).getHeldItemTooltipFade();
        int windowW = mc.method_22683().method_4486();
        int windowH = mc.method_22683().method_4502();
        int xFixed = class_3532.method_15340((int)((windowW + ClothConfig.gauntlet_hud_x) / 2), (int)0, (int)(windowW - 120));
        int yFixed = class_3532.method_15340((int)(windowH + ClothConfig.gauntlet_hud_y), (int)0, (int)(windowH - 41));
        if (ClothConfig.gauntlet_hud_preset == HudPreset.ABOVE_HOTBAR) {
            int height = 91;
            if (fade > 0) {
                height += 10;
            }
            yFixed = windowH - height;
        }
        if (forwardCycle) {
            class_332.method_25291((class_4587)matrixStack, (int)xFixed, (int)yFixed, (int)hud.method_25305(), (float)0.0f, (float)87.0f, (int)120, (int)41, (int)128, (int)128);
            if (--cooldown <= 0) {
                mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)ModSoundEvents.GAUNTLET_SCROLL, (float)1.0f));
                forwardCycle = false;
                cooldown = 40;
            }
        } else if (backwardCycle) {
            class_332.method_25291((class_4587)matrixStack, (int)xFixed, (int)yFixed, (int)hud.method_25305(), (float)0.0f, (float)44.0f, (int)120, (int)41, (int)128, (int)128);
            if (--cooldown <= 0) {
                mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)ModSoundEvents.GAUNTLET_SCROLL, (float)1.0f));
                backwardCycle = false;
                cooldown = 40;
            }
        } else {
            class_332.method_25291((class_4587)matrixStack, (int)xFixed, (int)yFixed, (int)hud.method_25305(), (float)0.0f, (float)1.0f, (int)120, (int)41, (int)128, (int)128);
        }
        if ((player = class_310.method_1551().field_1724) == null) {
            return;
        }
        class_1799 g = player.method_6047();
        class_2487 info = g.method_7948().method_10562("info");
        GauntletHUD.renderPotion(prePotion, matrixStack, xFixed + 3, yFixed + 21, GauntletItem.getCooldownFromPotionByIndex(info.method_10550("activePotionIndex") - 1, g), false);
        GauntletHUD.renderPotion(activePotion, matrixStack, xFixed + 51, yFixed + 5, GauntletItem.getCooldownFromPotionByIndex(info.method_10550("activePotionIndex"), g), true);
        GauntletHUD.renderPotion(postPotion, matrixStack, xFixed + 99, yFixed + 21, GauntletItem.getCooldownFromPotionByIndex(info.method_10550("activePotionIndex") + 1, g), false);
        matrixStack.method_22909();
    }

    private static void renderPotion(class_1842 potion, class_4587 matrixStack, int x, int y, int cooldown, boolean isActivePotion) {
        if (potion == null) {
            return;
        }
        class_2960 name = class_2378.field_11143.method_10221((Object)potion);
        if (potion.method_8049().isEmpty()) {
            return;
        }
        matrixStack.method_22903();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (potion.method_8049().size() > 1) {
            if (name.toString().contains("turtle_master")) {
                RenderSystem.setShaderTexture((int)0, (class_2960)GauntletHUD.getGauntletIconLoc("turtle_master"));
            } else if (mc.method_1478().method_14486(GauntletHUD.getGauntletIconLoc(name.toString())).isPresent()) {
                RenderSystem.setShaderTexture((int)0, (class_2960)GauntletHUD.getGauntletIconLoc(name.toString()));
            } else {
                RenderSystem.setShaderTexture((int)0, (class_2960)GauntletHUD.getGauntletIconLoc("unknown"));
            }
            class_332.method_25291((class_4587)matrixStack, (int)x, (int)y, (int)GauntletHUD.mc.field_1705.method_25305(), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
        } else {
            class_1291 effect = ((class_1293)potion.method_8049().get(0)).method_5579();
            class_1058 sprite = mc.method_18505().method_18663(effect);
            RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_24119().method_24106());
            class_332.method_25298((class_4587)matrixStack, (int)x, (int)y, (int)0, (int)18, (int)18, (class_1058)sprite);
        }
        if ((float)cooldown > 0.0f) {
            matrixStack.method_22903();
            RenderSystem.disableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            matrixStack.method_22904(1.0, 1.0, (double)(GauntletHUD.mc.field_1705.method_25305() + 1));
            class_289 tessellator = class_289.method_1348();
            class_287 bufferbuilder = tessellator.method_1349();
            if (isActivePotion) {
                int scale = GauntletHUD.getScaledCooldown(18.0f, cooldown);
                GauntletHUD.draw(bufferbuilder, x, y + scale, 18, 18 - scale, 255, 255, 255, 127);
            } else {
                int scale = GauntletHUD.getScaledCooldown(16.0f, cooldown);
                GauntletHUD.draw(bufferbuilder, x, y + scale, 17, 16 - scale, 255, 255, 255, 127);
            }
            RenderSystem.enableTexture();
            RenderSystem.enableDepthTest();
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
    }

    private static int getScaledCooldown(float pixels, float cooldown) {
        float totalCooldown = ClothConfig.gauntlet_cooldown;
        float progress = totalCooldown - cooldown;
        if (totalCooldown != 0.0f) {
            float result = progress * pixels / totalCooldown;
            return Math.round(result);
        }
        return 0;
    }

    private static void draw(class_287 renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        renderer.method_22912((double)x, (double)y, 0.0).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22912((double)x, (double)(y + height), 0.0).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22912((double)(x + width), (double)(y + height), 0.0).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22912((double)(x + width), (double)y, 0.0).method_1336(red, green, blue, alpha).method_1344();
        class_289.method_1348().method_1350();
    }

    public static void forwardCycle() {
        forwardCycle = true;
    }

    public static void backwardCycle() {
        backwardCycle = true;
    }

    public static enum HudPreset {
        TOP_LEFT,
        TOP_RIGHT,
        BTM_LEFT,
        BTM_RIGHT,
        ABOVE_HOTBAR,
        FREE_MOVE;

    }
}

