/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.ea.network;

import com.lupicus.ea.item.IGuiRightClick;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class EAPacket {
    private int cmd;
    private int windowId;
    private int index;

    public EAPacket(int cmd, int windowId, int index) {
        this.cmd = cmd;
        this.windowId = windowId;
        this.index = index;
    }

    public void encode(PacketBuffer buf) {
        buf.writeByte(this.cmd);
        buf.writeByte(this.windowId);
        buf.writeShort(this.index);
    }

    public static EAPacket readPacketData(PacketBuffer buf) {
        byte cmd = buf.readByte();
        byte windowId = buf.readByte();
        short index = buf.readShort();
        return new EAPacket(cmd, windowId, index);
    }

    public static void writePacketData(EAPacket msg, PacketBuffer buf) {
        msg.encode(buf);
    }

    public static void processPacket(EAPacket message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (message.cmd == 1) {
            ctx.get().enqueueWork(() -> {
                ItemStack stack;
                Slot slot;
                Container cont = player.field_71070_bA;
                if (message.windowId == cont.field_75152_c && message.index >= 0 && (slot = cont.func_75139_a(message.index)).func_75216_d() && (stack = slot.func_75211_c()).func_77973_b() instanceof IGuiRightClick) {
                    ((IGuiRightClick)stack.func_77973_b()).menuRightClick(stack);
                    slot.func_75218_e();
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

