/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.ea.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class EARecipe
extends ShapelessRecipe {
    protected final String operation;
    private final boolean copyDamage;
    public static final Serializer CRAFTING_EA = (Serializer)new Serializer().setRegistryName(Serializer.NAME);

    public EARecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn, String operationIn) {
        super(idIn, groupIn, recipeOutputIn, recipeItemsIn);
        this.operation = operationIn;
        boolean copyDamage = false;
        if (recipeOutputIn.m_41763_()) {
            block0: for (Ingredient thing : recipeItemsIn) {
                for (ItemStack stack : thing.m_43908_()) {
                    if (!stack.m_41763_() || stack.m_41776_() != recipeOutputIn.m_41776_()) continue;
                    copyDamage = true;
                    continue block0;
                }
            }
        }
        this.copyDamage = copyDamage;
    }

    public RecipeSerializer<?> m_7707_() {
        return CRAFTING_EA;
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        CompoundTag compoundnbt;
        ItemStack ret = this.m_8043_().m_41777_();
        if (this.copyDamage) {
            for (int j = 0; j < inv.m_6643_(); ++j) {
                ItemStack itemstack = inv.m_8020_(j);
                if (itemstack.m_41619_() || !itemstack.m_41763_() || itemstack.m_41776_() != ret.m_41776_()) continue;
                ret.m_41721_(itemstack.m_41773_());
                if (!itemstack.m_41782_()) break;
                ret.m_41751_(itemstack.m_41783_().m_6426_());
                break;
            }
        }
        if (this.operation.equals("reset_color")) {
            CompoundTag compoundnbt2 = ret.m_41737_("display");
            if (compoundnbt2 != null && compoundnbt2.m_128425_("color", 99)) {
                compoundnbt2.m_128473_("color");
            }
        } else if (this.operation.equals("set_color")) {
            int color = -1;
            for (int j = 0; j < inv.m_6643_(); ++j) {
                Item item;
                ItemStack itemstack = inv.m_8020_(j);
                if (itemstack.m_41619_() || !((item = itemstack.m_41720_()) instanceof DyeItem)) continue;
                if (item.equals(Items.f_42535_)) {
                    color = 0xFFFFFF;
                    break;
                }
                if (item.equals(Items.f_42497_)) {
                    color = 0xFF0000;
                    break;
                }
                if (item.equals(Items.f_42496_)) {
                    color = 65280;
                    break;
                }
                if (item.equals(Items.f_42494_)) {
                    color = 255;
                    break;
                }
                if (!item.equals(Items.f_42498_)) break;
                color = 0;
                break;
            }
            if (color >= 0) {
                CompoundTag compoundnbt3 = ret.m_41698_("display");
                compoundnbt3.m_128405_("color", color);
            } else {
                ret = ItemStack.f_41583_;
            }
        } else if (this.operation.equals("remove") && (compoundnbt = ret.m_41737_("display")) != null) {
            compoundnbt.m_128473_("color");
            compoundnbt.m_128473_("glint");
            if (compoundnbt.m_128456_()) {
                ret.m_41749_("display");
            }
        }
        return ret;
    }

    public static class Serializer
    extends ShapelessRecipe.Serializer {
        private static final ResourceLocation NAME = new ResourceLocation("ea", "crafting_shapeless");

        public EARecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            String s2 = GsonHelper.m_13851_((JsonObject)json, (String)"operation", (String)"");
            return new EARecipe(recipeId, s, itemstack, nonnulllist, s2);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray array) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < array.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)array.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public EARecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String s = buffer.m_130277_();
            int i = buffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack itemstack = buffer.m_130267_();
            String s2 = buffer.m_130277_();
            return new EARecipe(recipeId, s, itemstack, (NonNullList<Ingredient>)nonnulllist, s2);
        }

        public void m_6178_(FriendlyByteBuf buffer, ShapelessRecipe recipe) {
            super.m_6178_(buffer, recipe);
            buffer.m_130070_(((EARecipe)recipe).operation);
        }
    }
}

