/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.ea.network;

import com.lupicus.ea.item.IGuiRightClick;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class EAPacket {
    private int cmd;
    private int windowId;
    private int index;

    public EAPacket(int cmd, int windowId, int index) {
        this.cmd = cmd;
        this.windowId = windowId;
        this.index = index;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.cmd);
        buf.writeByte(this.windowId);
        buf.writeShort(this.index);
    }

    public static EAPacket readPacketData(FriendlyByteBuf buf) {
        byte cmd = buf.readByte();
        byte windowId = buf.readByte();
        short index = buf.readShort();
        return new EAPacket(cmd, windowId, index);
    }

    public static void writePacketData(EAPacket msg, FriendlyByteBuf buf) {
        msg.encode(buf);
    }

    public static void processPacket(EAPacket message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (message.cmd == 1) {
            ctx.get().enqueueWork(() -> {
                ItemStack stack;
                Slot slot;
                AbstractContainerMenu cont = player.f_36096_;
                if (message.windowId == cont.f_38840_ && message.index >= 0 && (slot = cont.m_38853_(message.index)).m_6657_() && (stack = slot.m_7993_()).m_41720_() instanceof IGuiRightClick) {
                    ((IGuiRightClick)stack.m_41720_()).menuRightClick(stack);
                    slot.m_6654_();
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

