/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.gui.plaque;

import fuzs.mobplaques.client.gui.plaque.TransitionPlaqueRenderer;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5146;

public class HealthPlaqueRenderer
extends TransitionPlaqueRenderer {
    private boolean hideWhenFull;

    @Override
    public boolean wantsToRender(class_1309 entity) {
        return this.allowRendering && (!this.hideWhenFull || this.belowMaxValue(entity));
    }

    @Override
    protected int getHighColor() {
        return class_124.field_1060.method_532();
    }

    @Override
    protected int getLowColor() {
        return class_124.field_1061.method_532();
    }

    @Override
    public int getValue(class_1309 entity) {
        return (int)Math.ceil(entity.method_6032()) + this.getAbsorptionValue(entity);
    }

    private int getAbsorptionValue(class_1309 entity) {
        return class_3532.method_15386((float)entity.method_6067());
    }

    @Override
    public int getMaxValue(class_1309 entity) {
        return (int)Math.ceil(entity.method_6063()) + this.getAbsorptionValue(entity);
    }

    @Override
    protected void renderIconBackground(class_4587 poseStack, int posX, int posY, class_1309 entity) {
        class_332.method_25290((class_4587)poseStack, (int)posX, (int)posY, (float)HeartType.CONTAINER.getTextureX(), (float)HeartType.CONTAINER.getTextureY(), (int)9, (int)9, (int)256, (int)256);
        poseStack.method_22904(0.0, 0.0, (double)-0.03f);
    }

    @Override
    protected int getIconX(class_1309 entity) {
        return HeartType.selectHeartType(entity).getTextureX();
    }

    @Override
    protected int getIconY(class_1309 entity) {
        return HeartType.selectHeartType(entity).getTextureY();
    }

    @Override
    public void setupConfig(AbstractConfigBuilder builder, ValueCallback callback) {
        super.setupConfig(builder, callback);
        callback.accept((Supplier)builder.comment("Hide health plaque when mob has full health.").define("hide_when_full", false), v -> {
            this.hideWhenFull = v;
        });
    }

    private static enum HeartType {
        CONTAINER(0),
        NORMAL(2),
        POISONED(4),
        WITHERED(6),
        ABSORBING(8),
        FROZEN(9),
        MOUNT(4, 1, false);

        private final int indexX;
        private final int indexY;
        private final boolean hardcoreVariant;

        private HeartType(int indexX) {
            this(indexX, 0, true);
        }

        private HeartType(int indexX, int indexY, boolean hardcoreVariant) {
            this.indexX = indexX;
            this.indexY = indexY;
            this.hardcoreVariant = hardcoreVariant;
        }

        public int getTextureX() {
            return 16 + this.indexX * 18;
        }

        public int getTextureY() {
            return this.getIndexY(false) * 9;
        }

        public int getIndexY(boolean hardcore) {
            if (hardcore && this.hardcoreVariant) {
                return 5;
            }
            return this.indexY;
        }

        public static HeartType selectHeartType(class_1309 entity) {
            class_5146 saddleable;
            if (entity.method_6059(class_1294.field_5899)) {
                return POISONED;
            }
            if (entity.method_6059(class_1294.field_5920)) {
                return WITHERED;
            }
            if (entity.method_32314()) {
                return FROZEN;
            }
            if (entity.method_6067() > 0.0f) {
                return ABSORBING;
            }
            return entity instanceof class_5146 && (saddleable = (class_5146)entity).method_6725() ? MOUNT : NORMAL;
        }
    }
}

