/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.gui.plaque;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import java.util.function.Supplier;
import net.minecraft.class_1159;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_757;

public abstract class MobPlaqueRenderer {
    protected static final int PLAQUE_HEIGHT = 11;
    protected static final int BACKGROUND_BORDER_SIZE = 1;
    protected static final int ICON_SIZE = 9;
    protected static final int TEXT_ICON_GAP = 2;
    protected boolean allowRendering;

    public boolean wantsToRender(class_1309 entity) {
        return this.allowRendering && this.getValue(entity) > 0;
    }

    public int getWidth(class_327 font, class_1309 entity) {
        return font.method_27525((class_5348)this.getComponent(entity)) + 2 + 9 + 2;
    }

    public int getHeight() {
        return 11;
    }

    public abstract int getValue(class_1309 var1);

    protected class_2561 getComponent(class_1309 entity) {
        return class_2561.method_43470((String)(this.getValue(entity) + "x"));
    }

    protected int getColor(class_1309 entity) {
        return -1;
    }

    public void render(class_4587 poseStack, int posX, int posY, class_4597 bufferSource, int packedLight, boolean withBackground, class_327 font, class_1309 entity) {
        poseStack.method_22903();
        this.tryRenderBackground(poseStack, posX, posY, withBackground, font, entity);
        this.renderComponent(poseStack, posX, posY, bufferSource, packedLight, font, entity);
        this.renderIcon(poseStack, posX, posY, font, entity);
        poseStack.method_22909();
    }

    private void tryRenderBackground(class_4587 poseStack, int posX, int posY, boolean withBackground, class_327 font, class_1309 entity) {
        if (withBackground) {
            int totalWidth = this.getWidth(font, entity);
            class_332.method_25294((class_4587)poseStack, (int)(posX - totalWidth / 2), (int)posY, (int)(posX + totalWidth / 2), (int)(posY + this.getHeight()), (int)class_310.method_1551().field_1690.method_19345(0.25f));
            poseStack.method_22904(0.0, 0.0, (double)0.03f);
        }
    }

    private void renderComponent(class_4587 poseStack, int posX, int posY, class_4597 bufferSource, int packedLight, class_327 font, class_1309 entity) {
        class_2561 component = this.getComponent(entity);
        int totalWidth = this.getWidth(font, entity);
        class_1159 matrix4f = poseStack.method_23760().method_23761();
        font.method_30882(component, (float)(posX - totalWidth / 2 + 1), (float)(posY + 1 + 1), this.getColor(entity), false, matrix4f, bufferSource, false, 0, 0xF000F0);
    }

    private void renderIcon(class_4587 poseStack, int posX, int posY, class_327 font, class_1309 entity) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.getTextureSheet());
        RenderSystem.enableDepthTest();
        this.renderIconBackground(poseStack, posX += this.getWidth(font, entity) / 2 - 1 - 9, ++posY, entity);
        class_332.method_25290((class_4587)poseStack, (int)posX, (int)posY, (float)this.getIconX(entity), (float)this.getIconY(entity), (int)9, (int)9, (int)256, (int)256);
        RenderSystem.disableDepthTest();
    }

    protected void renderIconBackground(class_4587 poseStack, int posX, int posY, class_1309 entity) {
    }

    protected abstract int getIconX(class_1309 var1);

    protected abstract int getIconY(class_1309 var1);

    protected class_2960 getTextureSheet() {
        return class_332.field_22737;
    }

    public void setupConfig(AbstractConfigBuilder builder, ValueCallback callback) {
        callback.accept((Supplier)builder.comment("Allow for rendering this type of plaque.").define("allow_rendering", true), v -> {
            this.allowRendering = v;
        });
    }
}

