/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.handler;

import com.google.common.collect.Lists;
import fuzs.mobplaques.MobPlaques;
import fuzs.mobplaques.client.gui.plaque.AirPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.ArmorPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.HealthPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.MobPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.ToughnessPlaqueRenderer;
import fuzs.mobplaques.config.ClientConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.apache.commons.lang3.mutable.MutableInt;

public class MobPlaqueHandler {
    private static final int PLAQUE_HORIZONTAL_DISTANCE = 2;
    private static final int PLAQUE_VERTICAL_DISTANCE = 2;
    public static final Map<class_2960, MobPlaqueRenderer> PLAQUE_RENDERERS = new LinkedHashMap<String, MobPlaqueRenderer>(){
        {
            this.put("health", new HealthPlaqueRenderer());
            this.put("air", new AirPlaqueRenderer());
            this.put("armor", new ArmorPlaqueRenderer());
            this.put("toughness", new ToughnessPlaqueRenderer());
        }
    }.entrySet().stream().collect(Collectors.toMap(e -> new class_2960("mobplaques", (String)e.getKey()), Map.Entry::getValue, (o1, o2) -> o1, LinkedHashMap::new));

    public static Optional<Boolean> onRenderNameTag(class_1297 entity, class_2561 content, class_897<?> entityRenderer, class_4587 poseStack, class_4597 multiBufferSource, int packedLight, float partialTick) {
        class_1309 livingEntity;
        if (!((Boolean)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).allowRendering.get()).booleanValue()) {
            return Optional.empty();
        }
        if (entity instanceof class_1309 && MobPlaqueHandler.canMobRenderPlaques(livingEntity = (class_1309)entity)) {
            class_1309 camera;
            class_1297 class_12972;
            class_310 minecraft = class_310.method_1551();
            class_898 entityRenderDispatcher = minecraft.method_1561();
            if (entityRenderDispatcher.field_4686 != null && MobPlaqueHandler.shouldShowName(livingEntity, entityRenderDispatcher) && (class_12972 = entityRenderDispatcher.field_4686.method_19331()) instanceof class_1309 && MobPlaqueHandler.isMobUnobstructed((class_1937)minecraft.field_1687, camera = (class_1309)class_12972, livingEntity, partialTick)) {
                poseStack.method_22903();
                int offsetY = "deadmau5".equals(content.getString()) ? -13 : -3;
                poseStack.method_22904(0.0, (double)livingEntity.method_17682() + 0.5, 0.0);
                poseStack.method_22907(entityRenderDispatcher.method_24197());
                float plaqueScale = (float)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).plaqueScale;
                if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).scaleWithDistance) {
                    double distanceSqr = entityRenderDispatcher.method_23168((class_1297)livingEntity);
                    float pickRange = minecraft.field_1761.method_2904();
                    double scaleRatio = class_3532.method_15350((double)((distanceSqr - Math.pow((double)pickRange / 2.0, 2.0)) / (Math.pow((double)pickRange * 2.0, 2.0) / 2.0)), (double)0.0, (double)2.0);
                    plaqueScale = (float)((double)plaqueScale * (1.0 + scaleRatio));
                }
                float scale = 0.025f * plaqueScale;
                poseStack.method_22905(-scale, -scale, scale);
                offsetY = (int)((float)offsetY - (float)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).heightOffset * (0.5f / plaqueScale));
                offsetY = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).renderBelowNameTag ? (int)((float)offsetY + 23.0f * (0.5f / plaqueScale)) : (int)((float)offsetY - (float)(MobPlaqueHandler.getPlaquesHeight(minecraft.field_1772, livingEntity) + 2) * (0.5f / plaqueScale));
                boolean plaqueBackground = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).plaqueBackground;
                Iterator<MobPlaqueRenderer> iterator = PLAQUE_RENDERERS.values().iterator();
                List<MutableInt> widths = MobPlaqueHandler.getPlaquesWidths(minecraft.field_1772, livingEntity);
                for (MutableInt width : widths) {
                    int rowStart = -width.intValue() / 2;
                    int maxRowHeight = 0;
                    while (iterator.hasNext()) {
                        MobPlaqueRenderer plaqueRenderer = iterator.next();
                        if (!plaqueRenderer.wantsToRender(livingEntity)) continue;
                        int plaqueWidth = plaqueRenderer.getWidth(minecraft.field_1772, livingEntity);
                        plaqueRenderer.render(poseStack, rowStart + plaqueWidth / 2, offsetY, multiBufferSource, packedLight, plaqueBackground, minecraft.field_1772, livingEntity);
                        maxRowHeight = Math.max(plaqueRenderer.getHeight(), maxRowHeight);
                        rowStart += (plaqueWidth += 2);
                        if (width.addAndGet(-plaqueWidth) > 0) continue;
                        break;
                    }
                    offsetY += maxRowHeight + 2;
                }
                poseStack.method_22909();
            }
        }
        return Optional.empty();
    }

    private static List<MutableInt> getPlaquesWidths(class_327 font, class_1309 entity) {
        int maxWidth = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).maxPlaqueRowWidth;
        ArrayList widths = Lists.newArrayList();
        int index = -1;
        for (MobPlaqueRenderer plaqueRenderer : PLAQUE_RENDERERS.values()) {
            if (!plaqueRenderer.wantsToRender(entity)) continue;
            int plaqueWidth = plaqueRenderer.getWidth(font, entity);
            if (widths.isEmpty() || maxWidth < ((MutableInt)widths.get(index)).intValue() + 2 + plaqueWidth) {
                widths.add(new MutableInt(plaqueWidth));
                ++index;
                continue;
            }
            ((MutableInt)widths.get(index)).add(2 + plaqueWidth);
        }
        return widths;
    }

    private static int getPlaquesHeight(class_327 font, class_1309 entity) {
        int maxWidth = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).maxPlaqueRowWidth;
        int currentWidth = -1;
        int currentMaxHeight = 0;
        int totalHeight = -1;
        for (MobPlaqueRenderer plaqueRenderer : PLAQUE_RENDERERS.values()) {
            if (!plaqueRenderer.wantsToRender(entity)) continue;
            int plaqueWidth = plaqueRenderer.getWidth(font, entity);
            if (currentWidth == -1 || maxWidth < currentWidth + 2 + plaqueWidth) {
                currentWidth = plaqueWidth;
                currentMaxHeight = plaqueRenderer.getHeight();
                totalHeight += plaqueRenderer.getHeight() + (totalHeight == -1 ? 0 : 2);
                continue;
            }
            currentWidth += 2 + plaqueWidth;
            if (plaqueRenderer.getHeight() <= currentMaxHeight) continue;
            totalHeight += plaqueRenderer.getHeight() - currentMaxHeight;
            currentMaxHeight = plaqueRenderer.getHeight();
        }
        return totalHeight;
    }

    private static boolean canMobRenderPlaques(class_1309 entity) {
        if (!((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).mobBlacklist.contains((Object)entity.method_5864()) && ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).disallowedMobSelectors.stream().noneMatch(selector -> selector.canMobRenderPlaque(entity))) {
            return ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).allowedMobSelectors.stream().anyMatch(selector -> selector.canMobRenderPlaque(entity));
        }
        return false;
    }

    private static boolean isMobUnobstructed(class_1937 level, class_1309 cameraEntity, class_1309 targetEntity, float partialTicks) {
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).behindWalls) {
            return true;
        }
        return MobPlaqueHandler.pick(level, cameraEntity, targetEntity, partialTicks).method_17783() == class_239.class_240.field_1333;
    }

    private static class_239 pick(class_1937 level, class_1309 cameraEntity, class_1309 targetEntity, float partialTicks) {
        class_243 vec3 = cameraEntity.method_5836(partialTicks);
        class_243 vec32 = targetEntity.method_5836(partialTicks);
        return level.method_17742(new class_3959(vec3, vec32, class_3959.class_3960.field_23142, class_3959.class_242.field_1348, (class_1297)cameraEntity));
    }

    private static boolean shouldShowName(class_1309 entity, class_898 entityRenderDispatcher) {
        boolean invisibleToPlayer;
        float f;
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).pickedEntity && entity != entityRenderDispatcher.field_4678) {
            return false;
        }
        double d0 = entityRenderDispatcher.method_23168((class_1297)entity);
        int maxRenderDistance = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).maxRenderDistance;
        float f2 = f = entity.method_21751() ? (float)maxRenderDistance / 2.0f : (float)maxRenderDistance;
        if (d0 >= (double)(f * f)) {
            return false;
        }
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        boolean bl = invisibleToPlayer = !entity.method_5756((class_1657)player);
        if (entity != player) {
            class_270 team = entity.method_5781();
            class_270 team1 = player.method_5781();
            if (team != null) {
                class_270.class_272 team$visibility = team.method_1201();
                switch (team$visibility) {
                    case field_1442: {
                        return invisibleToPlayer;
                    }
                    case field_1443: {
                        return false;
                    }
                    case field_1444: {
                        return team1 == null ? invisibleToPlayer : team.method_1206(team1) && (team.method_1199() || invisibleToPlayer);
                    }
                    case field_1446: {
                        return team1 == null ? invisibleToPlayer : !team.method_1206(team1) && invisibleToPlayer;
                    }
                }
                return true;
            }
        }
        return class_310.method_1498() && entity != minecraft.method_1560() && invisibleToPlayer && !entity.method_5782();
    }
}

