/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import fuzs.mobplaques.client.core.ClientModServices;
import fuzs.mobplaques.client.gui.plaque.MobPlaqueRenderer;
import fuzs.mobplaques.client.handler.MobPlaqueHandler;
import fuzs.puzzleslib.config.ConfigCore;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.annotation.Config;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import fuzs.puzzleslib.config.core.AbstractConfigValue;
import fuzs.puzzleslib.config.serialization.ConfigDataSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5146;
import net.minecraft.class_5321;
import net.minecraft.class_6025;

public class ClientConfig
implements ConfigCore {
    private static final String KEY_GENERAL_CATEGORY = "general";
    public AbstractConfigValue<Boolean> allowRendering;
    @Config(category={"general"}, description={"Show plaques for the entity picked by the crosshair only."})
    public boolean pickedEntity = false;
    @Config(category={"general"}, description={"Custom scale for rendering plaques."})
    @Config.DoubleRange(min=0.05, max=2.0)
    public double plaqueScale = 0.5;
    @Config(category={"general"}, description={"Amount of pixels a row of plaques may take up, when exceeding this value a new row will be started."})
    @Config.IntRange(min=0)
    public int maxPlaqueRowWidth = 108;
    @Config(category={"general"}, description={"Render mob plaques below the mob's name tag instead of above."})
    public boolean renderBelowNameTag = false;
    @Config(category={"general"}, description={"Show a black background box behind plaques. Disabled by default as it doesn't work with shaders."})
    public boolean plaqueBackground = false;
    @Config(category={"general"}, description={"Height offset from default position."})
    public int heightOffset = 0;
    @Config(category={"general"}, description={"Distance to the mob at which plaques will still be visible. The distance is halved when the mob is crouching."})
    @Config.IntRange(min=0)
    public int maxRenderDistance = 64;
    @Config(category={"general"}, description={"Show plaques from mobs obstructed by walls the player cannot see through."})
    public boolean behindWalls = false;
    @Config(category={"general"}, description={"Dynamically increase plaque size the further away the camera is to simplify readability."})
    public boolean scaleWithDistance = true;
    @Config(category={"general"}, name="mob_blacklist", description={"Entities blacklisted from showing any plaques.", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. Path may use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*shulker_box\" to match all shulker boxes no matter of color."})
    List<String> mobBlacklistRaw = ConfigDataSet.toString((class_5321)class_2378.field_25107, (Object[])new class_1299[]{class_1299.field_6131});
    @Config(category={"general"}, name="disallowed_mob_selectors", description={"Selectors for choosing mobs to prevent rendering plaques for, takes priority over allowed list."})
    @Config.AllowedValues(values={"ALL", "TAMED", "TAMED_ONLY_OWNER", "PLAYER", "MONSTER", "BOSS", "MOUNT"})
    List<String> disallowedMobSelectorsRaw = Lists.newArrayList();
    @Config(category={"general"}, name="allowed_mob_selectors", description={"Selectors for choosing mobs to render plaques for."})
    @Config.AllowedValues(values={"ALL", "TAMED", "TAMED_ONLY_OWNER", "PLAYER", "MONSTER", "BOSS", "MOUNT"})
    List<String> allowedMobSelectorsRaw = Stream.of(MobPlaquesSelector.ALL).map(Enum::name).collect(Collectors.toList());
    public ConfigDataSet<class_1299<?>> mobBlacklist;
    public List<MobPlaquesSelector> disallowedMobSelectors;
    public List<MobPlaquesSelector> allowedMobSelectors;

    public void addToBuilder(AbstractConfigBuilder builder, ValueCallback callback) {
        builder.push(KEY_GENERAL_CATEGORY);
        this.allowRendering = builder.comment("Are mob plaques enabled, toggleable in-game using the 'J' key by default.").define("allow_rendering", true);
        builder.pop();
        for (Map.Entry<class_2960, MobPlaqueRenderer> entry : MobPlaqueHandler.PLAQUE_RENDERERS.entrySet()) {
            builder.push(entry.getKey().method_12832());
            entry.getValue().setupConfig(builder, callback);
            builder.pop();
        }
    }

    public void afterConfigReload() {
        this.mobBlacklist = ConfigDataSet.of((class_5321)class_2378.field_25107, this.mobBlacklistRaw);
        this.disallowedMobSelectors = (List)this.disallowedMobSelectorsRaw.stream().map(MobPlaquesSelector::valueOf).collect(ImmutableList.toImmutableList());
        this.allowedMobSelectors = (List)this.allowedMobSelectorsRaw.stream().map(MobPlaquesSelector::valueOf).collect(ImmutableList.toImmutableList());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum MobPlaquesSelector {
        ALL{

            @Override
            public boolean canMobRenderPlaque(class_1309 entity) {
                return true;
            }
        }
        ,
        TAMED{

            @Override
            public boolean canMobRenderPlaque(class_1309 entity) {
                class_1496 abstractHorse;
                class_6025 tamableAnimal;
                return entity instanceof class_6025 && (tamableAnimal = (class_6025)entity).method_6139() != null || entity instanceof class_1496 && (abstractHorse = (class_1496)entity).method_6768() != null;
            }
        }
        ,
        TAMED_ONLY_OWNER{

            @Override
            public boolean canMobRenderPlaque(class_1309 entity) {
                class_1496 abstractHorse;
                class_6025 tamableAnimal;
                UUID owner = class_310.method_1551().field_1724.method_5667();
                return entity instanceof class_6025 && owner.equals((tamableAnimal = (class_6025)entity).method_6139()) || entity instanceof class_1496 && owner.equals((abstractHorse = (class_1496)entity).method_6768());
            }
        }
        ,
        PLAYER{

            @Override
            public boolean canMobRenderPlaque(class_1309 entity) {
                return entity instanceof class_1657;
            }
        }
        ,
        MONSTER{

            @Override
            public boolean canMobRenderPlaque(class_1309 entity) {
                return entity instanceof class_1588 || !entity.method_5864().method_5891().method_6136();
            }
        }
        ,
        BOSS{

            @Override
            public boolean canMobRenderPlaque(class_1309 entity) {
                return ClientModServices.ABSTRACTIONS.isBossMob(entity);
            }
        }
        ,
        MOUNT{

            @Override
            public boolean canMobRenderPlaque(class_1309 entity) {
                class_5146 saddleable;
                return entity instanceof class_5146 && (saddleable = (class_5146)entity).method_6765();
            }
        };


        public abstract boolean canMobRenderPlaque(class_1309 var1);
    }
}

