/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.gui.plaque;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mobplaques.client.gui.plaque.TransitionPlaqueRenderer;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Saddleable;

public class HealthPlaqueRenderer
extends TransitionPlaqueRenderer {
    private boolean hideWhenFull;

    @Override
    public boolean wantsToRender(LivingEntity entity) {
        return this.allowRendering && (!this.hideWhenFull || this.belowMaxValue(entity));
    }

    @Override
    protected int getHighColor() {
        return ChatFormatting.GREEN.m_126665_();
    }

    @Override
    protected int getLowColor() {
        return ChatFormatting.RED.m_126665_();
    }

    @Override
    public int getValue(LivingEntity entity) {
        return (int)Math.ceil(entity.m_21223_()) + this.getAbsorptionValue(entity);
    }

    private int getAbsorptionValue(LivingEntity entity) {
        return Mth.m_14167_((float)entity.m_6103_());
    }

    @Override
    public int getMaxValue(LivingEntity entity) {
        return (int)Math.ceil(entity.m_21233_()) + this.getAbsorptionValue(entity);
    }

    @Override
    protected void renderIconBackground(PoseStack poseStack, int posX, int posY, LivingEntity entity) {
        GuiComponent.m_93133_((PoseStack)poseStack, (int)posX, (int)posY, (float)HeartType.CONTAINER.getTextureX(), (float)HeartType.CONTAINER.getTextureY(), (int)9, (int)9, (int)256, (int)256);
        poseStack.m_85837_(0.0, 0.0, (double)-0.03f);
    }

    @Override
    protected int getIconX(LivingEntity entity) {
        return HeartType.selectHeartType(entity).getTextureX();
    }

    @Override
    protected int getIconY(LivingEntity entity) {
        return HeartType.selectHeartType(entity).getTextureY();
    }

    @Override
    public void setupConfig(AbstractConfigBuilder builder, ValueCallback callback) {
        super.setupConfig(builder, callback);
        callback.accept((Supplier)builder.comment("Hide health plaque when mob has full health.").define("hide_when_full", false), v -> {
            this.hideWhenFull = v;
        });
    }

    private static enum HeartType {
        CONTAINER(0),
        NORMAL(2),
        POISONED(4),
        WITHERED(6),
        ABSORBING(8),
        FROZEN(9),
        MOUNT(4, 1, false);

        private final int indexX;
        private final int indexY;
        private final boolean hardcoreVariant;

        private HeartType(int indexX) {
            this(indexX, 0, true);
        }

        private HeartType(int indexX, int indexY, boolean hardcoreVariant) {
            this.indexX = indexX;
            this.indexY = indexY;
            this.hardcoreVariant = hardcoreVariant;
        }

        public int getTextureX() {
            return 16 + this.indexX * 18;
        }

        public int getTextureY() {
            return this.getIndexY(false) * 9;
        }

        public int getIndexY(boolean hardcore) {
            if (hardcore && this.hardcoreVariant) {
                return 5;
            }
            return this.indexY;
        }

        public static HeartType selectHeartType(LivingEntity entity) {
            Saddleable saddleable;
            if (entity.m_21023_(MobEffects.f_19614_)) {
                return POISONED;
            }
            if (entity.m_21023_(MobEffects.f_19615_)) {
                return WITHERED;
            }
            if (entity.m_146890_()) {
                return FROZEN;
            }
            if (entity.m_6103_() > 0.0f) {
                return ABSORBING;
            }
            return entity instanceof Saddleable && (saddleable = (Saddleable)entity).m_6254_() ? MOUNT : NORMAL;
        }
    }
}

