/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.gui.plaque;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public abstract class MobPlaqueRenderer {
    protected static final int PLAQUE_HEIGHT = 11;
    protected static final int BACKGROUND_BORDER_SIZE = 1;
    protected static final int ICON_SIZE = 9;
    protected static final int TEXT_ICON_GAP = 2;
    protected boolean allowRendering;

    public boolean wantsToRender(LivingEntity entity) {
        return this.allowRendering && this.getValue(entity) > 0;
    }

    public int getWidth(Font font, LivingEntity entity) {
        return font.m_92852_((FormattedText)this.getComponent(entity)) + 2 + 9 + 2;
    }

    public int getHeight() {
        return 11;
    }

    public abstract int getValue(LivingEntity var1);

    protected Component getComponent(LivingEntity entity) {
        return Component.m_237113_((String)(this.getValue(entity) + "x"));
    }

    protected int getColor(LivingEntity entity) {
        return -1;
    }

    public void render(PoseStack poseStack, int posX, int posY, MultiBufferSource bufferSource, int packedLight, boolean withBackground, Font font, LivingEntity entity) {
        poseStack.m_85836_();
        this.tryRenderBackground(poseStack, posX, posY, withBackground, font, entity);
        this.renderComponent(poseStack, posX, posY, bufferSource, packedLight, font, entity);
        this.renderIcon(poseStack, posX, posY, font, entity);
        poseStack.m_85849_();
    }

    private void tryRenderBackground(PoseStack poseStack, int posX, int posY, boolean withBackground, Font font, LivingEntity entity) {
        if (withBackground) {
            int totalWidth = this.getWidth(font, entity);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(posX - totalWidth / 2), (int)posY, (int)(posX + totalWidth / 2), (int)(posY + this.getHeight()), (int)Minecraft.m_91087_().f_91066_.m_92170_(0.25f));
            poseStack.m_85837_(0.0, 0.0, (double)0.03f);
        }
    }

    private void renderComponent(PoseStack poseStack, int posX, int posY, MultiBufferSource bufferSource, int packedLight, Font font, LivingEntity entity) {
        Component component = this.getComponent(entity);
        int totalWidth = this.getWidth(font, entity);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        font.m_92841_(component, (float)(posX - totalWidth / 2 + 1), (float)(posY + 1 + 1), this.getColor(entity), false, matrix4f, bufferSource, false, 0, 0xF000F0);
    }

    private void renderIcon(PoseStack poseStack, int posX, int posY, Font font, LivingEntity entity) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureSheet());
        RenderSystem.m_69482_();
        this.renderIconBackground(poseStack, posX += this.getWidth(font, entity) / 2 - 1 - 9, ++posY, entity);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)posX, (int)posY, (float)this.getIconX(entity), (float)this.getIconY(entity), (int)9, (int)9, (int)256, (int)256);
        RenderSystem.m_69465_();
    }

    protected void renderIconBackground(PoseStack poseStack, int posX, int posY, LivingEntity entity) {
    }

    protected abstract int getIconX(LivingEntity var1);

    protected abstract int getIconY(LivingEntity var1);

    protected ResourceLocation getTextureSheet() {
        return GuiComponent.f_93098_;
    }

    public void setupConfig(AbstractConfigBuilder builder, ValueCallback callback) {
        callback.accept((Supplier)builder.comment("Allow for rendering this type of plaque.").define("allow_rendering", true), v -> {
            this.allowRendering = v;
        });
    }
}

