/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.gui.plaque;

import fuzs.mobplaques.client.gui.plaque.MobPlaqueRenderer;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public abstract class TransitionPlaqueRenderer
extends MobPlaqueRenderer {
    private boolean shiftColors;
    private boolean relativeValue;

    protected abstract int getHighColor();

    protected abstract int getLowColor();

    public abstract int getMaxValue(LivingEntity var1);

    protected boolean belowMaxValue(LivingEntity entity) {
        return this.getValue(entity) < this.getMaxValue(entity);
    }

    @Override
    protected Component getComponent(LivingEntity entity) {
        if (!this.relativeValue) {
            return super.getComponent(entity);
        }
        return Component.m_237113_((String)((int)(this.getValuePercentage(entity) * 100.0f) + "%"));
    }

    @Override
    protected int getColor(LivingEntity entity) {
        if (!this.shiftColors) {
            return super.getColor(entity);
        }
        return TransitionPlaqueRenderer.getTransitionedColor(this.getHighColor(), this.getLowColor(), this.getValuePercentage(entity));
    }

    private float getValuePercentage(LivingEntity entity) {
        return Mth.m_14036_((float)((float)this.getValue(entity) / (float)this.getMaxValue(entity)), (float)0.0f, (float)1.0f);
    }

    @Override
    public void setupConfig(AbstractConfigBuilder builder, ValueCallback callback) {
        super.setupConfig(builder, callback);
        callback.accept((Supplier)builder.comment("Transition text colors depending on current percentage.").define("shift_colors", true), v -> {
            this.shiftColors = v;
        });
        callback.accept((Supplier)builder.comment("Show current amount as percentage instead of as absolute value.").define("relative_value", false), v -> {
            this.relativeValue = v;
        });
    }

    private static int getTransitionedColor(int startColor, int endColor, float transition) {
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor >> 0 & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor >> 0 & 0xFF;
        int colorR = endR + (int)((float)(startR - endR) * transition);
        int colorG = endG + (int)((float)(startG - endG) * transition);
        int colorB = endB + (int)((float)(startB - endB) * transition);
        int color = 0;
        color |= colorR << 16;
        color |= colorG << 8;
        return color |= colorB << 0;
    }
}

