/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.client.handler;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mobplaques.MobPlaques;
import fuzs.mobplaques.client.gui.plaque.AirPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.ArmorPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.HealthPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.MobPlaqueRenderer;
import fuzs.mobplaques.client.gui.plaque.ToughnessPlaqueRenderer;
import fuzs.mobplaques.config.ClientConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.apache.commons.lang3.mutable.MutableInt;

public class MobPlaqueHandler {
    private static final int PLAQUE_HORIZONTAL_DISTANCE = 2;
    private static final int PLAQUE_VERTICAL_DISTANCE = 2;
    public static final Map<ResourceLocation, MobPlaqueRenderer> PLAQUE_RENDERERS = new LinkedHashMap<String, MobPlaqueRenderer>(){
        {
            this.put("health", new HealthPlaqueRenderer());
            this.put("air", new AirPlaqueRenderer());
            this.put("armor", new ArmorPlaqueRenderer());
            this.put("toughness", new ToughnessPlaqueRenderer());
        }
    }.entrySet().stream().collect(Collectors.toMap(e -> new ResourceLocation("mobplaques", (String)e.getKey()), Map.Entry::getValue, (o1, o2) -> o1, LinkedHashMap::new));

    public static Optional<Boolean> onRenderNameTag(Entity entity, Component content, EntityRenderer<?> entityRenderer, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, float partialTick) {
        LivingEntity livingEntity;
        if (!((Boolean)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).allowRendering.get()).booleanValue()) {
            return Optional.empty();
        }
        if (entity instanceof LivingEntity && MobPlaqueHandler.canMobRenderPlaques(livingEntity = (LivingEntity)entity)) {
            LivingEntity camera;
            Entity entity2;
            Minecraft minecraft = Minecraft.m_91087_();
            EntityRenderDispatcher entityRenderDispatcher = minecraft.m_91290_();
            if (entityRenderDispatcher.f_114358_ != null && MobPlaqueHandler.shouldShowName(livingEntity, entityRenderDispatcher) && (entity2 = entityRenderDispatcher.f_114358_.m_90592_()) instanceof LivingEntity && MobPlaqueHandler.isMobUnobstructed((Level)minecraft.f_91073_, camera = (LivingEntity)entity2, livingEntity, partialTick)) {
                poseStack.m_85836_();
                int offsetY = "deadmau5".equals(content.getString()) ? -13 : -3;
                poseStack.m_85837_(0.0, (double)livingEntity.m_20206_() + 0.5, 0.0);
                poseStack.m_85845_(entityRenderDispatcher.m_114470_());
                float plaqueScale = (float)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).plaqueScale;
                if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).scaleWithDistance) {
                    double distanceSqr = entityRenderDispatcher.m_114471_((Entity)livingEntity);
                    float pickRange = minecraft.f_91072_.m_105286_();
                    double scaleRatio = Mth.m_14008_((double)((distanceSqr - Math.pow((double)pickRange / 2.0, 2.0)) / (Math.pow((double)pickRange * 2.0, 2.0) / 2.0)), (double)0.0, (double)2.0);
                    plaqueScale = (float)((double)plaqueScale * (1.0 + scaleRatio));
                }
                float scale = 0.025f * plaqueScale;
                poseStack.m_85841_(-scale, -scale, scale);
                offsetY = (int)((float)offsetY - (float)((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).heightOffset * (0.5f / plaqueScale));
                offsetY = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).renderBelowNameTag ? (int)((float)offsetY + 23.0f * (0.5f / plaqueScale)) : (int)((float)offsetY - (float)(MobPlaqueHandler.getPlaquesHeight(minecraft.f_91062_, livingEntity) + 2) * (0.5f / plaqueScale));
                boolean plaqueBackground = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).plaqueBackground;
                Iterator<MobPlaqueRenderer> iterator = PLAQUE_RENDERERS.values().iterator();
                List<MutableInt> widths = MobPlaqueHandler.getPlaquesWidths(minecraft.f_91062_, livingEntity);
                for (MutableInt width : widths) {
                    int rowStart = -width.intValue() / 2;
                    int maxRowHeight = 0;
                    while (iterator.hasNext()) {
                        MobPlaqueRenderer plaqueRenderer = iterator.next();
                        if (!plaqueRenderer.wantsToRender(livingEntity)) continue;
                        int plaqueWidth = plaqueRenderer.getWidth(minecraft.f_91062_, livingEntity);
                        plaqueRenderer.render(poseStack, rowStart + plaqueWidth / 2, offsetY, multiBufferSource, packedLight, plaqueBackground, minecraft.f_91062_, livingEntity);
                        maxRowHeight = Math.max(plaqueRenderer.getHeight(), maxRowHeight);
                        rowStart += (plaqueWidth += 2);
                        if (width.addAndGet(-plaqueWidth) > 0) continue;
                        break;
                    }
                    offsetY += maxRowHeight + 2;
                }
                poseStack.m_85849_();
            }
        }
        return Optional.empty();
    }

    private static List<MutableInt> getPlaquesWidths(Font font, LivingEntity entity) {
        int maxWidth = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).maxPlaqueRowWidth;
        ArrayList widths = Lists.newArrayList();
        int index = -1;
        for (MobPlaqueRenderer plaqueRenderer : PLAQUE_RENDERERS.values()) {
            if (!plaqueRenderer.wantsToRender(entity)) continue;
            int plaqueWidth = plaqueRenderer.getWidth(font, entity);
            if (widths.isEmpty() || maxWidth < ((MutableInt)widths.get(index)).intValue() + 2 + plaqueWidth) {
                widths.add(new MutableInt(plaqueWidth));
                ++index;
                continue;
            }
            ((MutableInt)widths.get(index)).add(2 + plaqueWidth);
        }
        return widths;
    }

    private static int getPlaquesHeight(Font font, LivingEntity entity) {
        int maxWidth = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).maxPlaqueRowWidth;
        int currentWidth = -1;
        int currentMaxHeight = 0;
        int totalHeight = -1;
        for (MobPlaqueRenderer plaqueRenderer : PLAQUE_RENDERERS.values()) {
            if (!plaqueRenderer.wantsToRender(entity)) continue;
            int plaqueWidth = plaqueRenderer.getWidth(font, entity);
            if (currentWidth == -1 || maxWidth < currentWidth + 2 + plaqueWidth) {
                currentWidth = plaqueWidth;
                currentMaxHeight = plaqueRenderer.getHeight();
                totalHeight += plaqueRenderer.getHeight() + (totalHeight == -1 ? 0 : 2);
                continue;
            }
            currentWidth += 2 + plaqueWidth;
            if (plaqueRenderer.getHeight() <= currentMaxHeight) continue;
            totalHeight += plaqueRenderer.getHeight() - currentMaxHeight;
            currentMaxHeight = plaqueRenderer.getHeight();
        }
        return totalHeight;
    }

    private static boolean canMobRenderPlaques(LivingEntity entity) {
        if (!((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).mobBlacklist.contains((Object)entity.m_6095_()) && ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).disallowedMobSelectors.stream().noneMatch(selector -> selector.canMobRenderPlaque(entity))) {
            return ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).allowedMobSelectors.stream().anyMatch(selector -> selector.canMobRenderPlaque(entity));
        }
        return false;
    }

    private static boolean isMobUnobstructed(Level level, LivingEntity cameraEntity, LivingEntity targetEntity, float partialTicks) {
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).behindWalls) {
            return true;
        }
        return MobPlaqueHandler.pick(level, cameraEntity, targetEntity, partialTicks).m_6662_() == HitResult.Type.MISS;
    }

    private static HitResult pick(Level level, LivingEntity cameraEntity, LivingEntity targetEntity, float partialTicks) {
        Vec3 vec3 = cameraEntity.m_20299_(partialTicks);
        Vec3 vec32 = targetEntity.m_20299_(partialTicks);
        return level.m_45547_(new ClipContext(vec3, vec32, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)cameraEntity));
    }

    private static boolean shouldShowName(LivingEntity entity, EntityRenderDispatcher entityRenderDispatcher) {
        boolean invisibleToPlayer;
        float f;
        if (((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).pickedEntity && entity != entityRenderDispatcher.f_114359_) {
            return false;
        }
        double d0 = entityRenderDispatcher.m_114471_((Entity)entity);
        int maxRenderDistance = ((ClientConfig)MobPlaques.CONFIG.get(ClientConfig.class)).maxRenderDistance;
        float f2 = f = entity.m_20163_() ? (float)maxRenderDistance / 2.0f : (float)maxRenderDistance;
        if (d0 >= (double)(f * f)) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        boolean bl = invisibleToPlayer = !entity.m_20177_((Player)player);
        if (entity != player) {
            Team team = entity.m_5647_();
            Team team1 = player.m_5647_();
            if (team != null) {
                Team.Visibility team$visibility = team.m_7470_();
                switch (team$visibility) {
                    case ALWAYS: {
                        return invisibleToPlayer;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return team1 == null ? invisibleToPlayer : team.m_83536_(team1) && (team.m_6259_() || invisibleToPlayer);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return team1 == null ? invisibleToPlayer : !team.m_83536_(team1) && invisibleToPlayer;
                    }
                }
                return true;
            }
        }
        return Minecraft.m_91404_() && entity != minecraft.m_91288_() && invisibleToPlayer && !entity.m_20160_();
    }
}

