/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mobplaques.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import fuzs.mobplaques.client.core.ClientModServices;
import fuzs.mobplaques.client.gui.plaque.MobPlaqueRenderer;
import fuzs.mobplaques.client.handler.MobPlaqueHandler;
import fuzs.puzzleslib.config.ConfigCore;
import fuzs.puzzleslib.config.ValueCallback;
import fuzs.puzzleslib.config.annotation.Config;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import fuzs.puzzleslib.config.core.AbstractConfigValue;
import fuzs.puzzleslib.config.serialization.ConfigDataSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;

public class ClientConfig
implements ConfigCore {
    private static final String KEY_GENERAL_CATEGORY = "general";
    public AbstractConfigValue<Boolean> allowRendering;
    @Config(category={"general"}, description={"Show plaques for the entity picked by the crosshair only."})
    public boolean pickedEntity = false;
    @Config(category={"general"}, description={"Custom scale for rendering plaques."})
    @Config.DoubleRange(min=0.05, max=2.0)
    public double plaqueScale = 0.5;
    @Config(category={"general"}, description={"Amount of pixels a row of plaques may take up, when exceeding this value a new row will be started."})
    @Config.IntRange(min=0)
    public int maxPlaqueRowWidth = 108;
    @Config(category={"general"}, description={"Render mob plaques below the mob's name tag instead of above."})
    public boolean renderBelowNameTag = false;
    @Config(category={"general"}, description={"Show a black background box behind plaques. Disabled by default as it doesn't work with shaders."})
    public boolean plaqueBackground = false;
    @Config(category={"general"}, description={"Height offset from default position."})
    public int heightOffset = 0;
    @Config(category={"general"}, description={"Distance to the mob at which plaques will still be visible. The distance is halved when the mob is crouching."})
    @Config.IntRange(min=0)
    public int maxRenderDistance = 64;
    @Config(category={"general"}, description={"Show plaques from mobs obstructed by walls the player cannot see through."})
    public boolean behindWalls = false;
    @Config(category={"general"}, description={"Dynamically increase plaque size the further away the camera is to simplify readability."})
    public boolean scaleWithDistance = true;
    @Config(category={"general"}, name="mob_blacklist", description={"Entities blacklisted from showing any plaques.", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. Path may use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*shulker_box\" to match all shulker boxes no matter of color."})
    List<String> mobBlacklistRaw = ConfigDataSet.toString((ResourceKey)Registry.f_122903_, (Object[])new EntityType[]{EntityType.f_20529_});
    @Config(category={"general"}, name="disallowed_mob_selectors", description={"Selectors for choosing mobs to prevent rendering plaques for, takes priority over allowed list."})
    @Config.AllowedValues(values={"ALL", "TAMED", "TAMED_ONLY_OWNER", "PLAYER", "MONSTER", "BOSS", "MOUNT"})
    List<String> disallowedMobSelectorsRaw = Lists.newArrayList();
    @Config(category={"general"}, name="allowed_mob_selectors", description={"Selectors for choosing mobs to render plaques for."})
    @Config.AllowedValues(values={"ALL", "TAMED", "TAMED_ONLY_OWNER", "PLAYER", "MONSTER", "BOSS", "MOUNT"})
    List<String> allowedMobSelectorsRaw = Stream.of(MobPlaquesSelector.ALL).map(Enum::name).collect(Collectors.toList());
    public ConfigDataSet<EntityType<?>> mobBlacklist;
    public List<MobPlaquesSelector> disallowedMobSelectors;
    public List<MobPlaquesSelector> allowedMobSelectors;

    public void addToBuilder(AbstractConfigBuilder builder, ValueCallback callback) {
        builder.push(KEY_GENERAL_CATEGORY);
        this.allowRendering = builder.comment("Are mob plaques enabled, toggleable in-game using the 'J' key by default.").define("allow_rendering", true);
        builder.pop();
        for (Map.Entry<ResourceLocation, MobPlaqueRenderer> entry : MobPlaqueHandler.PLAQUE_RENDERERS.entrySet()) {
            builder.push(entry.getKey().m_135815_());
            entry.getValue().setupConfig(builder, callback);
            builder.pop();
        }
    }

    public void afterConfigReload() {
        this.mobBlacklist = ConfigDataSet.of((ResourceKey)Registry.f_122903_, this.mobBlacklistRaw);
        this.disallowedMobSelectors = (List)this.disallowedMobSelectorsRaw.stream().map(MobPlaquesSelector::valueOf).collect(ImmutableList.toImmutableList());
        this.allowedMobSelectors = (List)this.allowedMobSelectorsRaw.stream().map(MobPlaquesSelector::valueOf).collect(ImmutableList.toImmutableList());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum MobPlaquesSelector {
        ALL{

            @Override
            public boolean canMobRenderPlaque(LivingEntity entity) {
                return true;
            }
        }
        ,
        TAMED{

            @Override
            public boolean canMobRenderPlaque(LivingEntity entity) {
                AbstractHorse abstractHorse;
                OwnableEntity tamableAnimal;
                return entity instanceof OwnableEntity && (tamableAnimal = (OwnableEntity)entity).m_21805_() != null || entity instanceof AbstractHorse && (abstractHorse = (AbstractHorse)entity).m_30615_() != null;
            }
        }
        ,
        TAMED_ONLY_OWNER{

            @Override
            public boolean canMobRenderPlaque(LivingEntity entity) {
                AbstractHorse abstractHorse;
                OwnableEntity tamableAnimal;
                UUID owner = Minecraft.m_91087_().f_91074_.m_20148_();
                return entity instanceof OwnableEntity && owner.equals((tamableAnimal = (OwnableEntity)entity).m_21805_()) || entity instanceof AbstractHorse && owner.equals((abstractHorse = (AbstractHorse)entity).m_30615_());
            }
        }
        ,
        PLAYER{

            @Override
            public boolean canMobRenderPlaque(LivingEntity entity) {
                return entity instanceof Player;
            }
        }
        ,
        MONSTER{

            @Override
            public boolean canMobRenderPlaque(LivingEntity entity) {
                return entity instanceof Monster || !entity.m_6095_().m_20674_().m_21609_();
            }
        }
        ,
        BOSS{

            @Override
            public boolean canMobRenderPlaque(LivingEntity entity) {
                return ClientModServices.ABSTRACTIONS.isBossMob(entity);
            }
        }
        ,
        MOUNT{

            @Override
            public boolean canMobRenderPlaque(LivingEntity entity) {
                Saddleable saddleable;
                return entity instanceof Saddleable && (saddleable = (Saddleable)entity).m_6741_();
            }
        };


        public abstract boolean canMobRenderPlaque(LivingEntity var1);
    }
}

