/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage;

import com.buuz135.functionalstorage.block.ArmoryCabinetBlock;
import com.buuz135.functionalstorage.block.CompactingDrawerBlock;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.DrawerControllerBlock;
import com.buuz135.functionalstorage.block.EnderDrawerBlock;
import com.buuz135.functionalstorage.client.CompactingDrawerRenderer;
import com.buuz135.functionalstorage.client.ControllerRenderer;
import com.buuz135.functionalstorage.client.DrawerRenderer;
import com.buuz135.functionalstorage.client.EnderDrawerRenderer;
import com.buuz135.functionalstorage.data.FunctionalStorageBlockTagsProvider;
import com.buuz135.functionalstorage.data.FunctionalStorageBlockstateProvider;
import com.buuz135.functionalstorage.data.FunctionalStorageItemTagsProvider;
import com.buuz135.functionalstorage.data.FunctionalStorageLangProvider;
import com.buuz135.functionalstorage.inventory.BigInventoryHandler;
import com.buuz135.functionalstorage.inventory.item.DrawerStackItemHandler;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.buuz135.functionalstorage.network.EnderDrawerSyncMessage;
import com.buuz135.functionalstorage.util.DrawerWoodType;
import com.buuz135.functionalstorage.util.IWoodType;
import com.buuz135.functionalstorage.util.NumberUtils;
import com.buuz135.functionalstorage.util.StorageTags;
import com.buuz135.functionalstorage.util.TooltipUtil;
import com.google.common.base.Supplier;
import com.hrznstudio.titanium.block.BasicBlock;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.datagenerator.loot.TitaniumLootTableProvider;
import com.hrznstudio.titanium.datagenerator.model.BlockItemModelGeneratorProvider;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.recipe.generator.TitaniumRecipeProvider;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.tab.AdvancedTitaniumTab;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.DataProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.UpgradeRecipeBuilder;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="functionalstorage")
public class FunctionalStorage
extends ModuleController {
    public static String MOD_ID = "functionalstorage";
    public static NetworkHandler NETWORK = new NetworkHandler(MOD_ID);
    private static final Logger LOGGER;
    public static List<IWoodType> WOOD_TYPES;
    public static HashMap<DrawerType, List<RegistryObject<Block>>> DRAWER_TYPES;
    public static RegistryObject<Block> COMPACTING_DRAWER;
    public static RegistryObject<Block> DRAWER_CONTROLLER;
    public static RegistryObject<Block> ARMORY_CABINET;
    public static RegistryObject<Block> ENDER_DRAWER;
    public static RegistryObject<Item> LINKING_TOOL;
    public static HashMap<StorageUpgradeItem.StorageTier, RegistryObject<Item>> STORAGE_UPGRADES;
    public static RegistryObject<Item> COLLECTOR_UPGRADE;
    public static RegistryObject<Item> PULLING_UPGRADE;
    public static RegistryObject<Item> PUSHING_UPGRADE;
    public static RegistryObject<Item> VOID_UPGRADE;
    public static RegistryObject<Item> CONFIGURATION_TOOL;
    public static AdvancedTitaniumTab TAB;

    public FunctionalStorage() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::onClient);
        EventManager.forge(BlockEvent.BreakEvent.class).process(breakEvent -> {
            if (breakEvent.getPlayer().m_7500_()) {
                int hit;
                if (breakEvent.getState().m_60734_() instanceof DrawerBlock && (hit = ((DrawerBlock)breakEvent.getState().m_60734_()).getHit(breakEvent.getState(), breakEvent.getPlayer().m_183503_(), breakEvent.getPos(), breakEvent.getPlayer())) != -1) {
                    breakEvent.setCanceled(true);
                    ((DrawerBlock)breakEvent.getState().m_60734_()).m_6256_(breakEvent.getState(), breakEvent.getPlayer().m_183503_(), breakEvent.getPos(), breakEvent.getPlayer());
                }
                if (breakEvent.getState().m_60734_() instanceof CompactingDrawerBlock && (hit = ((CompactingDrawerBlock)breakEvent.getState().m_60734_()).getHit(breakEvent.getState(), breakEvent.getPlayer().m_183503_(), breakEvent.getPos(), breakEvent.getPlayer())) != -1) {
                    breakEvent.setCanceled(true);
                    ((CompactingDrawerBlock)breakEvent.getState().m_60734_()).m_6256_(breakEvent.getState(), breakEvent.getPlayer().m_183503_(), breakEvent.getPos(), breakEvent.getPlayer());
                }
                if (breakEvent.getState().m_60734_() instanceof EnderDrawerBlock && (hit = ((EnderDrawerBlock)breakEvent.getState().m_60734_()).getHit(breakEvent.getState(), breakEvent.getPlayer().m_183503_(), breakEvent.getPos(), breakEvent.getPlayer())) != -1) {
                    breakEvent.setCanceled(true);
                    ((EnderDrawerBlock)breakEvent.getState().m_60734_()).m_6256_(breakEvent.getState(), breakEvent.getPlayer().m_183503_(), breakEvent.getPos(), breakEvent.getPlayer());
                }
            }
        }).subscribe();
    }

    protected void initModules() {
        WOOD_TYPES.addAll(List.of(DrawerWoodType.values()));
        for (DrawerType drawerType2 : DrawerType.values()) {
            for (IWoodType woodType : WOOD_TYPES) {
                String name = woodType.getName() + "_" + drawerType2.getSlots();
                DRAWER_TYPES.computeIfAbsent(drawerType2, drawerType -> new ArrayList()).add(this.getRegistries().register(Block.class, name, () -> new DrawerBlock(woodType, drawerType2)));
            }
            DRAWER_TYPES.get((Object)drawerType2).forEach(blockRegistryObject -> TAB.addIconStacks(new Supplier[]{() -> new ItemStack((ItemLike)blockRegistryObject.get())}));
        }
        COMPACTING_DRAWER = this.getRegistries().register(Block.class, "compacting_drawer", () -> new CompactingDrawerBlock("compacting_drawer"));
        DRAWER_CONTROLLER = this.getRegistries().register(Block.class, "storage_controller", DrawerControllerBlock::new);
        LINKING_TOOL = this.getRegistries().register(Item.class, "linking_tool", LinkingToolItem::new);
        for (Enum enum_ : StorageUpgradeItem.StorageTier.values()) {
            STORAGE_UPGRADES.put((StorageUpgradeItem.StorageTier)enum_, (RegistryObject<Item>)this.getRegistries().register(Item.class, enum_.name().toLowerCase(Locale.ROOT) + (enum_ == StorageUpgradeItem.StorageTier.IRON ? "_downgrade" : "_upgrade"), () -> FunctionalStorage.lambda$initModules$7((StorageUpgradeItem.StorageTier)enum_)));
        }
        COLLECTOR_UPGRADE = this.getRegistries().register(Item.class, "collector_upgrade", () -> new UpgradeItem(new Item.Properties(), UpgradeItem.Type.UTILITY));
        PULLING_UPGRADE = this.getRegistries().register(Item.class, "puller_upgrade", () -> new UpgradeItem(new Item.Properties(), UpgradeItem.Type.UTILITY));
        PUSHING_UPGRADE = this.getRegistries().register(Item.class, "pusher_upgrade", () -> new UpgradeItem(new Item.Properties(), UpgradeItem.Type.UTILITY));
        VOID_UPGRADE = this.getRegistries().register(Item.class, "void_upgrade", () -> new UpgradeItem(new Item.Properties(), UpgradeItem.Type.UTILITY));
        ARMORY_CABINET = this.getRegistries().register(Block.class, "armory_cabinet", ArmoryCabinetBlock::new);
        CONFIGURATION_TOOL = this.getRegistries().register(Item.class, "configuration_tool", ConfigurationToolItem::new);
        ENDER_DRAWER = this.getRegistries().register(Block.class, "ender_drawer", EnderDrawerBlock::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClient() {
        EventManager.mod(EntityRenderersEvent.RegisterRenderers.class).process(registerRenderers -> {
            for (DrawerType value : DrawerType.values()) {
                DRAWER_TYPES.get((Object)value).forEach(blockRegistryObject -> registerRenderers.registerBlockEntityRenderer(((BasicTileBlock)blockRegistryObject.get()).getTileEntityType(), p_173571_ -> new DrawerRenderer()));
            }
            registerRenderers.registerBlockEntityRenderer(((BasicTileBlock)COMPACTING_DRAWER.get()).getTileEntityType(), p_173571_ -> new CompactingDrawerRenderer());
            registerRenderers.registerBlockEntityRenderer(((BasicTileBlock)DRAWER_CONTROLLER.get()).getTileEntityType(), p -> new ControllerRenderer());
            registerRenderers.registerBlockEntityRenderer(((BasicTileBlock)ENDER_DRAWER.get()).getTileEntityType(), p_173571_ -> new EnderDrawerRenderer());
        }).subscribe();
        EventManager.mod(ColorHandlerEvent.Item.class).process(item -> {
            item.getItemColors().m_92689_((stack, tint) -> {
                CompoundTag tag = stack.m_41784_();
                LinkingToolItem.LinkingMode linkingMode = LinkingToolItem.getLinkingMode(stack);
                LinkingToolItem.ActionMode linkingAction = LinkingToolItem.getActionMode(stack);
                if (tint != 0 && stack.m_41784_().m_128441_("Ender")) {
                    return new Color(44, 150, 88).getRGB();
                }
                if (tint == 3 && tag.m_128441_("Controller")) {
                    return Color.RED.getRGB();
                }
                if (tint == 1) {
                    return linkingMode.getColor().m_131265_();
                }
                if (tint == 2) {
                    return linkingAction.getColor().m_131265_();
                }
                return 0xFFFFFF;
            }, new ItemLike[]{(ItemLike)LINKING_TOOL.get()});
            item.getItemColors().m_92689_((stack, tint) -> {
                ConfigurationToolItem.ConfigurationAction action = ConfigurationToolItem.getAction(stack);
                if (tint == 1) {
                    return action.getColor().m_131265_();
                }
                return 0xFFFFFF;
            }, new ItemLike[]{(ItemLike)CONFIGURATION_TOOL.get()});
        }).subscribe();
        EventManager.mod(FMLClientSetupEvent.class).process(event -> {
            for (DrawerType value : DrawerType.values()) {
                for (RegistryObject<Block> blockRegistryObject : DRAWER_TYPES.get((Object)value)) {
                    ItemBlockRenderTypes.setRenderLayer((Block)((Block)blockRegistryObject.get()), (RenderType)RenderType.m_110463_());
                }
            }
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)COMPACTING_DRAWER.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ENDER_DRAWER.get()), (RenderType)RenderType.m_110463_());
        }).subscribe();
        EventManager.forge(RenderTooltipEvent.Pre.class).process(itemTooltipEvent -> {
            if (itemTooltipEvent.getItemStack().m_41720_().equals(((Block)ENDER_DRAWER.get()).m_5456_()) && itemTooltipEvent.getItemStack().m_41782_()) {
                TooltipUtil.renderItems(itemTooltipEvent.getPoseStack(), EnderDrawerBlock.getFrequencyDisplay(itemTooltipEvent.getItemStack().m_41783_().m_128469_("BlockEntityTag").m_128461_("frequency")), itemTooltipEvent.getX() + 14, itemTooltipEvent.getY() + 11);
            }
            if (itemTooltipEvent.getItemStack().m_150930_((Item)LINKING_TOOL.get()) && itemTooltipEvent.getItemStack().m_41784_().m_128441_("Ender")) {
                TooltipUtil.renderItems(itemTooltipEvent.getPoseStack(), EnderDrawerBlock.getFrequencyDisplay(itemTooltipEvent.getItemStack().m_41784_().m_128461_("Ender")), itemTooltipEvent.getX() + 14, itemTooltipEvent.getY() + 11);
            }
            itemTooltipEvent.getItemStack().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iItemHandler -> {
                if (iItemHandler instanceof DrawerStackItemHandler) {
                    int i = 0;
                    for (BigInventoryHandler.BigStack storedStack : ((DrawerStackItemHandler)iItemHandler).getStoredStacks()) {
                        TooltipUtil.renderItemAdvanced(itemTooltipEvent.getPoseStack(), storedStack.getStack(), itemTooltipEvent.getX() + 20 + 26 * i, itemTooltipEvent.getY() + 11, 512, NumberUtils.getFormatedBigNumber(storedStack.getAmount()) + "/" + NumberUtils.getFormatedBigNumber(iItemHandler.getSlotLimit(i)));
                        ++i;
                    }
                }
            });
        }).subscribe();
    }

    public void addDataProvider(GatherDataEvent event) {
        final NonNullLazy blocksToProcess = NonNullLazy.of(() -> ForgeRegistries.BLOCKS.getValues().stream().filter(basicBlock -> Optional.ofNullable(basicBlock.getRegistryName()).map(ResourceLocation::m_135827_).filter(MOD_ID::equalsIgnoreCase).isPresent()).collect(Collectors.toList()));
        event.getGenerator().m_123914_((DataProvider)new BlockItemModelGeneratorProvider(event.getGenerator(), MOD_ID, blocksToProcess));
        event.getGenerator().m_123914_((DataProvider)new FunctionalStorageBlockstateProvider(event.getGenerator(), event.getExistingFileHelper(), (NonNullLazy<List<Block>>)blocksToProcess));
        event.getGenerator().m_123914_((DataProvider)new TitaniumLootTableProvider(event.getGenerator(), blocksToProcess));
        event.getGenerator().m_123914_((DataProvider)new TitaniumRecipeProvider(event.getGenerator()){

            public void register(Consumer<FinishedRecipe> consumer) {
                ((List)blocksToProcess.get()).stream().map(block -> (BasicBlock)block).forEach(basicBlock -> basicBlock.registerRecipe(consumer));
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())).m_126130_("III").m_126130_("IDI").m_126130_("III").m_126121_(Character.valueOf('I'), (Tag)Tags.Items.INGOTS_IRON).m_126121_(Character.valueOf('D'), StorageTags.DRAWER).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)VOID_UPGRADE.get())).m_126130_("III").m_126130_("IDI").m_126130_("III").m_126121_(Character.valueOf('I'), (Tag)Tags.Items.OBSIDIAN).m_126121_(Character.valueOf('D'), StorageTags.DRAWER).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)CONFIGURATION_TOOL.get())).m_126130_("PPG").m_126130_("PDG").m_126130_("PEP").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126121_(Character.valueOf('G'), (Tag)Tags.Items.INGOTS_GOLD).m_126121_(Character.valueOf('D'), StorageTags.DRAWER).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42616_).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)LINKING_TOOL.get())).m_126130_("PPG").m_126130_("PDG").m_126130_("PEP").m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_).m_126121_(Character.valueOf('G'), (Tag)Tags.Items.INGOTS_GOLD).m_126121_(Character.valueOf('D'), StorageTags.DRAWER).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42415_).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.COPPER).get())).m_126130_("IBI").m_126130_("CDC").m_126130_("IBI").m_126127_(Character.valueOf('I'), (ItemLike)Items.f_151052_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_151000_).m_126121_(Character.valueOf('C'), (Tag)Tags.Items.CHESTS_WOODEN).m_126121_(Character.valueOf('D'), StorageTags.DRAWER).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.GOLD).get())).m_126130_("IBI").m_126130_("CDC").m_126130_("BIB").m_126121_(Character.valueOf('I'), (Tag)Tags.Items.INGOTS_GOLD).m_126121_(Character.valueOf('B'), (Tag)Tags.Items.STORAGE_BLOCKS_GOLD).m_126121_(Character.valueOf('C'), (Tag)Tags.Items.CHESTS_WOODEN).m_126127_(Character.valueOf('D'), (ItemLike)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.COPPER).get()).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.DIAMOND).get())).m_126130_("IBI").m_126130_("CDC").m_126130_("BBB").m_126121_(Character.valueOf('I'), (Tag)Tags.Items.GEMS_DIAMOND).m_126121_(Character.valueOf('B'), (Tag)Tags.Items.STORAGE_BLOCKS_DIAMOND).m_126121_(Character.valueOf('C'), (Tag)Tags.Items.CHESTS_WOODEN).m_126127_(Character.valueOf('D'), (ItemLike)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.GOLD).get()).m_176498_(consumer);
                UpgradeRecipeBuilder.m_126385_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.DIAMOND).get()}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), (Item)((Item)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.NETHERITE).get())).m_126389_("has_netherite_ingot", (CriterionTriggerInstance)1.m_125977_((ItemLike)Items.f_42418_)).m_126395_(consumer, ((Item)STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.NETHERITE).get()).getRegistryName());
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)DRAWER_CONTROLLER.get())).m_126130_("IBI").m_126130_("CDC").m_126130_("IBI").m_126121_(Character.valueOf('I'), (Tag)Tags.Items.STONE).m_126121_(Character.valueOf('B'), (Tag)Tags.Items.STORAGE_BLOCKS_QUARTZ).m_126121_(Character.valueOf('C'), StorageTags.DRAWER).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42351_).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)ARMORY_CABINET.get())).m_126130_("ICI").m_126130_("CDC").m_126130_("IBI").m_126121_(Character.valueOf('I'), (Tag)Tags.Items.STONE).m_126121_(Character.valueOf('B'), (Tag)Tags.Items.INGOTS_NETHERITE).m_126121_(Character.valueOf('C'), StorageTags.DRAWER).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42351_).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)PULLING_UPGRADE.get())).m_126130_("ICI").m_126130_("IDI").m_126130_("IBI").m_126121_(Character.valueOf('I'), (Tag)Tags.Items.STONE).m_126121_(Character.valueOf('B'), (Tag)Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42155_).m_126121_(Character.valueOf('D'), StorageTags.DRAWER).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)PUSHING_UPGRADE.get())).m_126130_("IBI").m_126130_("IDI").m_126130_("IRI").m_126121_(Character.valueOf('I'), (Tag)Tags.Items.STONE).m_126121_(Character.valueOf('B'), (Tag)Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42155_).m_126121_(Character.valueOf('D'), StorageTags.DRAWER).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)COLLECTOR_UPGRADE.get())).m_126130_("IBI").m_126130_("RDR").m_126130_("IBI").m_126121_(Character.valueOf('I'), (Tag)Tags.Items.STONE).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42155_).m_126121_(Character.valueOf('R'), (Tag)Tags.Items.DUSTS_REDSTONE).m_126121_(Character.valueOf('D'), StorageTags.DRAWER).m_176498_(consumer);
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)ENDER_DRAWER.get())).m_126130_("PPP").m_126130_("LCL").m_126130_("PPP").m_126121_(Character.valueOf('P'), (Tag)ItemTags.f_13168_).m_126121_(Character.valueOf('C'), (Tag)Tags.Items.CHESTS_ENDER).m_126121_(Character.valueOf('L'), StorageTags.DRAWER).m_176498_(consumer);
            }
        });
        event.getGenerator().m_123914_((DataProvider)new FunctionalStorageItemTagsProvider(event.getGenerator(), new BlockTagsProvider(event.getGenerator()), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().m_123914_((DataProvider)new FunctionalStorageLangProvider(event.getGenerator(), MOD_ID, "en_us"));
        event.getGenerator().m_123914_((DataProvider)new FunctionalStorageBlockTagsProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().m_123914_((DataProvider)new ItemModelProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()){

            protected void registerModels() {
                for (StorageUpgradeItem.StorageTier storageTier : STORAGE_UPGRADES.keySet()) {
                    this.item((Item)STORAGE_UPGRADES.get((Object)storageTier).get());
                }
                this.item((Item)COLLECTOR_UPGRADE.get());
                this.item((Item)PULLING_UPGRADE.get());
                this.item((Item)PUSHING_UPGRADE.get());
                this.item((Item)VOID_UPGRADE.get());
            }

            private void item(Item item) {
                this.singleTexture(item.getRegistryName().m_135815_(), new ResourceLocation("minecraft:item/generated"), "layer0", new ResourceLocation(MOD_ID, "items/" + item.getRegistryName().m_135815_()));
            }
        });
        event.getGenerator().m_123914_((DataProvider)new BlockModelProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()){

            protected void registerModels() {
                for (DrawerType value : DrawerType.values()) {
                    for (RegistryObject<Block> blockRegistryObject : DRAWER_TYPES.get((Object)value)) {
                        ((BlockModelBuilder)this.withExistingParent(((Block)blockRegistryObject.get()).getRegistryName().m_135815_() + "_locked", this.modLoc(((Block)blockRegistryObject.get()).getRegistryName().m_135815_()))).texture("lock_icon", this.modLoc("blocks/lock"));
                    }
                }
                ((BlockModelBuilder)this.withExistingParent(((Block)COMPACTING_DRAWER.get()).getRegistryName().m_135815_() + "_locked", this.modLoc(((Block)COMPACTING_DRAWER.get()).getRegistryName().m_135815_()))).texture("lock_icon", this.modLoc("blocks/lock"));
                ((BlockModelBuilder)this.withExistingParent(((Block)ENDER_DRAWER.get()).getRegistryName().m_135815_() + "_locked", this.modLoc(((Block)ENDER_DRAWER.get()).getRegistryName().m_135815_()))).texture("lock_icon", this.modLoc("blocks/lock"));
            }
        });
    }

    private static /* synthetic */ Item lambda$initModules$7(StorageUpgradeItem.StorageTier value) {
        return new StorageUpgradeItem(value);
    }

    static {
        NETWORK.registerMessage(EnderDrawerSyncMessage.class);
        LOGGER = LogManager.getLogger();
        WOOD_TYPES = new ArrayList<IWoodType>();
        DRAWER_TYPES = new HashMap();
        STORAGE_UPGRADES = new HashMap();
        TAB = new AdvancedTitaniumTab("functionalstorage", true);
    }

    public static enum DrawerType {
        X_1(1, 2048, "1x1"),
        X_2(2, 1024, "1x2"),
        X_4(4, 512, "2x2");

        private final int slots;
        private final int slotAmount;
        private final String displayName;

        private DrawerType(int slots, int slotAmount, String displayName) {
            this.slots = slots;
            this.slotAmount = slotAmount;
            this.displayName = displayName;
        }

        public int getSlots() {
            return this.slots;
        }

        public int getSlotAmount() {
            return this.slotAmount;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

