/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.EnderDrawerTile;
import com.buuz135.functionalstorage.client.DrawerRenderer;
import com.buuz135.functionalstorage.inventory.EnderInventoryHandler;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.world.EnderSavedData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix3f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;

public class EnderDrawerRenderer
implements BlockEntityRenderer<EnderDrawerTile> {
    private static final Matrix3f FAKE_NORMALS;

    public void render(EnderDrawerTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.m_85836_();
        Direction facing = tile.getFacingDirection();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-180.0f));
        if (facing != Direction.SOUTH) {
            matrixStack.m_85850_().m_85864_().m_8169_(FAKE_NORMALS);
        }
        if (facing == Direction.NORTH) {
            matrixStack.m_85837_(-1.0, 0.0, 0.0);
        }
        if (facing == Direction.EAST) {
            matrixStack.m_85837_(-1.0, 0.0, -1.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        }
        if (facing == Direction.SOUTH) {
            matrixStack.m_85837_(0.0, 0.0, -1.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-180.0f));
        }
        if (facing == Direction.WEST) {
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        }
        matrixStack.m_85837_(0.0, 0.0, -0.03125);
        combinedLightIn = LevelRenderer.m_109541_((BlockAndTintGetter)tile.m_58904_(), (BlockPos)tile.m_58899_().m_142300_(facing));
        EnderDrawerRenderer.renderUpgrades(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        this.render1Slot(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, tile);
        matrixStack.m_85849_();
    }

    public static void renderUpgrades(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, ControllableDrawerTile<?> tile) {
        float scale = 0.0625f;
        if (tile.getDrawerOptions().isActive(ConfigurationToolItem.ConfigurationAction.TOGGLE_UPGRADES)) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.031, (double)0.031f, 0.0295);
            for (int i = 0; i < tile.getStorageUpgrades().getSlots(); ++i) {
                ItemStack stack = tile.getStorageUpgrades().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                matrixStack.m_85836_();
                matrixStack.m_85841_(scale, scale, scale);
                Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.NONE, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
                matrixStack.m_85849_();
                matrixStack.m_85837_((double)scale, 0.0, 0.0);
            }
            matrixStack.m_85849_();
        }
        if (tile.isVoid()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.969, (double)0.031f, 0.0293125);
            matrixStack.m_85841_(scale, scale, scale);
            Minecraft.m_91087_().m_91291_().m_174269_(new ItemStack((ItemLike)FunctionalStorage.VOID_UPGRADE.get()), ItemTransforms.TransformType.NONE, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
            matrixStack.m_85849_();
        }
    }

    private void render1Slot(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, EnderDrawerTile tile) {
        EnderInventoryHandler inventoryHandler = EnderSavedData.getInstance((LevelAccessor)tile.m_58904_()).getFrequency(tile.getFrequency());
        if (!inventoryHandler.getStoredStacks().get(0).getStack().m_41619_()) {
            matrixStack.m_85837_(0.5, 0.5, (double)5.0E-4f);
            ItemStack stack = inventoryHandler.getStoredStacks().get(0).getStack();
            DrawerRenderer.renderStack(matrixStack, bufferIn, combinedLightIn, combinedOverlayIn, stack, inventoryHandler.getStoredStacks().get(0).getAmount(), 0.015f, tile.getDrawerOptions());
        }
    }

    static {
        Vector3f NORMAL = new Vector3f(1.0f, 1.0f, 1.0f);
        NORMAL.m_122278_();
        FAKE_NORMALS = new Matrix3f(new Quaternion(NORMAL, 0.0f, true));
    }
}

