/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.data;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.text.WordUtils;

public class FunctionalStorageLangProvider
extends LanguageProvider {
    public FunctionalStorageLangProvider(DataGenerator gen, String modid, String locale) {
        super(gen, modid, locale);
    }

    protected void addTranslations() {
        this.add("itemGroup.functionalstorage", "Functional Storage");
        for (FunctionalStorage.DrawerType drawerType : FunctionalStorage.DRAWER_TYPES.keySet()) {
            for (RegistryObject<Block> blockRegistryObject : FunctionalStorage.DRAWER_TYPES.get((Object)drawerType)) {
                DrawerBlock drawerBlock = (DrawerBlock)blockRegistryObject.get();
                this.add((Block)drawerBlock, WordUtils.capitalize((String)drawerBlock.getWoodType().getName().replace('_', ' ').toLowerCase()) + " Drawer (" + drawerBlock.getType().getDisplayName() + ")");
            }
        }
        this.add((Block)FunctionalStorage.COMPACTING_DRAWER.get(), "Compacting Drawer");
        this.add((Block)FunctionalStorage.ENDER_DRAWER.get(), "Ender Drawer");
        this.add("linkingtool.linkingmode", "Linking Mode: ");
        this.add("linkingtool.linkingmode.single", "Single");
        this.add("linkingtool.linkingmode.single.desc", "Links a drawer to a controller");
        this.add("linkingtool.linkingmode.multiple", "Multiple");
        this.add("linkingtool.linkingmode.multiple.desc", "Links multiple drawers between 2 points");
        this.add("linkingtool.controller", "Controller: ");
        this.add("linkingtool.linkingaction", "Linking Action: ");
        this.add("linkingtool.use", "* Sneak + Right Click in the air to change modes or to clear frequency. \n* Left Click an Ender Drawer to store its Frequency. \n* Right Click in the air to change actions. \n\nRight click a controller to setup the tool then use it nearby drawers to link. \n\nWhile holding the tool it will show the connected drawers to the selected controller.");
        this.add("linkingtool.linkingaction.add", "Add");
        this.add("linkingtool.linkingaction.remove", "Remove");
        this.add("key.categories.utility", "Utility");
        this.add("key.categories.storage", "Storage");
        this.add((Item)FunctionalStorage.LINKING_TOOL.get(), "Linking Tool");
        this.add((Block)FunctionalStorage.DRAWER_CONTROLLER.get(), "Storage Controller");
        this.add("storageupgrade.desc", "Multiplies the block storage by ");
        for (StorageUpgradeItem.StorageTier storageTier : FunctionalStorage.STORAGE_UPGRADES.keySet()) {
            this.add((Item)FunctionalStorage.STORAGE_UPGRADES.get((Object)storageTier).get(), WordUtils.capitalize((String)storageTier.name().toLowerCase()) + (storageTier == StorageUpgradeItem.StorageTier.IRON ? " Downgrade" : " Upgrade"));
        }
        this.add((Item)FunctionalStorage.COLLECTOR_UPGRADE.get(), WordUtils.capitalize((String)((Item)FunctionalStorage.COLLECTOR_UPGRADE.get()).getRegistryName().m_135815_().replace('_', ' ').toLowerCase()));
        this.add((Item)FunctionalStorage.PULLING_UPGRADE.get(), WordUtils.capitalize((String)((Item)FunctionalStorage.PULLING_UPGRADE.get()).getRegistryName().m_135815_().replace('_', ' ').toLowerCase()));
        this.add((Item)FunctionalStorage.PUSHING_UPGRADE.get(), WordUtils.capitalize((String)((Item)FunctionalStorage.PUSHING_UPGRADE.get()).getRegistryName().m_135815_().replace('_', ' ').toLowerCase()));
        this.add((Item)FunctionalStorage.VOID_UPGRADE.get(), WordUtils.capitalize((String)((Item)FunctionalStorage.VOID_UPGRADE.get()).getRegistryName().m_135815_().replace('_', ' ').toLowerCase()));
        this.add((Block)FunctionalStorage.ARMORY_CABINET.get(), "Armory Cabinet");
        this.add((Item)FunctionalStorage.CONFIGURATION_TOOL.get(), "Configuration Tool");
        this.add("item.utility.downgrade", "Downgrades the slots to a max of 64 items");
        this.add("item.utility.direction", "Direction: ");
        this.add("item.utility.direction.desc", "Right click in a GUI to change direction");
        this.add("configurationtool.configmode", "Config Mode: ");
        this.add("configurationtool.configmode.locking", "Locking");
        this.add("configurationtool.configmode.toggle_numbers", "Hide/Show Amounts");
        this.add("configurationtool.configmode.toggle_render", "Hide/Show Item Renders");
        this.add("configurationtool.configmode.toggle_upgrades", "Hide/Show Upgrade Renders");
        this.add("configurationtool.use", "Sneak + Right Click in the air to change modes. Right click a drawer to toggle the option.");
        this.add("upgrade.type", "Type: ");
        this.add("upgrade.type.storage", "Storage");
        this.add("upgrade.type.utility", "Utility");
        this.add("linkingtool.ender.frequency", "Frequency: ");
        this.add("linkingtool.ender.clear", "Sneak + Right Click in the air to clear frequency.");
        this.add("drawer.block.contents", "Contents: ");
    }
}

