/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.inventory;

import com.buuz135.functionalstorage.FunctionalStorage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class BigInventoryHandler
implements IItemHandler,
INBTSerializable<CompoundTag> {
    public static String BIG_ITEMS = "BigItems";
    public static String STACK = "Stack";
    public static String AMOUNT = "Amount";
    private final FunctionalStorage.DrawerType type;
    private List<BigStack> storedStacks;

    public BigInventoryHandler(FunctionalStorage.DrawerType type) {
        this.type = type;
        this.storedStacks = new ArrayList<BigStack>();
        for (int i = 0; i < type.getSlots(); ++i) {
            this.storedStacks.add(i, new BigStack(ItemStack.f_41583_, 0));
        }
    }

    public int getSlots() {
        return this.type.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        BigStack bigStack = this.storedStacks.get(slot);
        ItemStack copied = bigStack.getStack().m_41777_();
        copied.m_41764_(bigStack.getAmount());
        return copied;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.isValid(slot, stack)) {
            BigStack bigStack = this.storedStacks.get(slot);
            int inserted = Math.min(this.getSlotLimit(slot) - bigStack.getAmount(), stack.m_41613_());
            if (!simulate) {
                if (bigStack.getStack().m_41619_()) {
                    bigStack.setStack(stack);
                }
                bigStack.setAmount(Math.min(bigStack.getAmount() + inserted, this.getSlotLimit(slot)));
                this.onChange();
            }
            if (inserted == stack.m_41613_() || this.isVoid()) {
                return ItemStack.f_41583_;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - inserted));
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        if (slot < this.type.getSlots()) {
            BigStack bigStack = this.storedStacks.get(slot);
            if (bigStack.getStack().m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (bigStack.getAmount() <= amount) {
                ItemStack out = bigStack.getStack().m_41777_();
                int newAmount = bigStack.getAmount();
                if (!simulate) {
                    if (!this.isLocked()) {
                        bigStack.setStack(ItemStack.f_41583_);
                    }
                    bigStack.setAmount(0);
                    this.onChange();
                }
                out.m_41764_(newAmount);
                return out;
            }
            if (!simulate) {
                bigStack.setAmount(bigStack.getAmount() - amount);
                this.onChange();
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)bigStack.getStack(), (int)amount);
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        double stackSize = 1.0;
        if (!this.getStoredStacks().get(slot).getStack().m_41619_()) {
            stackSize = (double)this.getStoredStacks().get(slot).getStack().m_41741_() / 64.0;
        }
        if (this.hasDowngrade()) {
            return (int)Math.floor(64.0 * stackSize);
        }
        return (int)Math.floor((double)Math.min(Integer.MAX_VALUE, (long)this.type.getSlotAmount() * (long)this.getMultiplier()) * stackSize);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return !stack.m_41619_();
    }

    private boolean isValid(int slot, @Nonnull ItemStack stack) {
        if (slot < this.type.getSlots()) {
            BigStack bigStack = this.storedStacks.get(slot);
            ItemStack fl = bigStack.getStack();
            return fl.m_41619_() || fl.m_41656_(stack) && ItemStack.m_41658_((ItemStack)fl, (ItemStack)stack);
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        CompoundTag items = new CompoundTag();
        for (int i = 0; i < this.storedStacks.size(); ++i) {
            CompoundTag bigStack = new CompoundTag();
            bigStack.m_128365_(STACK, (Tag)this.storedStacks.get(i).getStack().serializeNBT());
            bigStack.m_128405_(AMOUNT, this.storedStacks.get(i).getAmount());
            items.m_128365_("" + i, (Tag)bigStack);
        }
        compoundTag.m_128365_(BIG_ITEMS, (Tag)items);
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (String allKey : nbt.m_128469_(BIG_ITEMS).m_128431_()) {
            this.storedStacks.get(Integer.parseInt(allKey)).setStack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_(BIG_ITEMS).m_128469_(allKey).m_128469_(STACK)));
            this.storedStacks.get(Integer.parseInt(allKey)).setAmount(nbt.m_128469_(BIG_ITEMS).m_128469_(allKey).m_128451_(AMOUNT));
        }
    }

    public abstract void onChange();

    public abstract int getMultiplier();

    public abstract boolean isVoid();

    public abstract boolean hasDowngrade();

    public abstract boolean isLocked();

    public List<BigStack> getStoredStacks() {
        return this.storedStacks;
    }

    public static class BigStack {
        private ItemStack stack;
        private int amount;

        public BigStack(ItemStack stack, int amount) {
            this.stack = stack.m_41777_();
            this.amount = amount;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack.m_41777_();
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }
    }
}

