/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.inventory;

import com.buuz135.functionalstorage.block.tile.DrawerControllerTile;
import java.util.Iterator;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ControllerInventoryHandler
implements IItemHandler {
    public int getSlots() {
        return this.getDrawers().getHandlers().stream().map(IItemHandler::getSlots).mapToInt(Integer::intValue).sum();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        int index = 0;
        Iterator<IItemHandler> iterator = this.getDrawers().getHandlers().iterator();
        while (iterator.hasNext()) {
            int relativeIndex = slot - index;
            IItemHandler handler = iterator.next();
            if (relativeIndex < handler.getSlots()) {
                return handler.getStackInSlot(relativeIndex);
            }
            index += handler.getSlots();
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        int index = 0;
        Iterator<IItemHandler> iterator = this.getDrawers().getHandlers().iterator();
        while (iterator.hasNext()) {
            int relativeIndex = slot - index;
            IItemHandler handler = iterator.next();
            if (relativeIndex < handler.getSlots()) {
                return handler.insertItem(relativeIndex, stack, simulate);
            }
            index += handler.getSlots();
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int index = 0;
        Iterator<IItemHandler> iterator = this.getDrawers().getHandlers().iterator();
        while (iterator.hasNext()) {
            int relativeIndex = slot - index;
            IItemHandler handler = iterator.next();
            if (relativeIndex < handler.getSlots()) {
                return handler.extractItem(relativeIndex, amount, simulate);
            }
            index += handler.getSlots();
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        int index = 0;
        Iterator<IItemHandler> iterator = this.getDrawers().getHandlers().iterator();
        while (iterator.hasNext()) {
            int relativeIndex = slot - index;
            IItemHandler handler = iterator.next();
            if (relativeIndex < handler.getSlots()) {
                return handler.getSlotLimit(relativeIndex);
            }
            index += handler.getSlots();
        }
        return 0;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        int index = 0;
        Iterator<IItemHandler> iterator = this.getDrawers().getHandlers().iterator();
        while (iterator.hasNext()) {
            int relativeIndex = slot - index;
            IItemHandler handler = iterator.next();
            if (relativeIndex < handler.getSlots()) {
                return handler.isItemValid(relativeIndex, stack);
            }
            index += handler.getSlots();
        }
        return false;
    }

    public abstract DrawerControllerTile.ConnectedDrawers getDrawers();
}

