/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.hrznstudio.titanium.item.BasicItem;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;

public class UpgradeItem
extends BasicItem {
    private final Type type;

    public static Direction getDirection(ItemStack stack) {
        Item item;
        if (stack.m_41782_() && ((item = stack.m_41720_()).equals(FunctionalStorage.PULLING_UPGRADE.get()) || item.equals(FunctionalStorage.PUSHING_UPGRADE.get()) || item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get()))) {
            return Direction.m_122402_((String)stack.m_41784_().m_128461_("Direction"));
        }
        return Direction.NORTH;
    }

    public UpgradeItem(Item.Properties properties, Type type) {
        super(properties.m_41491_((CreativeModeTab)FunctionalStorage.TAB));
        this.type = type;
    }

    public void m_7836_(ItemStack p_41447_, Level p_41448_, Player p_41449_) {
        super.m_7836_(p_41447_, p_41448_, p_41449_);
        this.initNbt(p_41447_);
    }

    private ItemStack initNbt(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item.equals(FunctionalStorage.PULLING_UPGRADE.get()) || item.equals(FunctionalStorage.PUSHING_UPGRADE.get()) || item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get())) {
            stack.m_41784_().m_128359_("Direction", Direction.values()[0].name());
        }
        return stack;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)this.initNbt(new ItemStack((ItemLike)this)));
        }
    }

    public Type getType() {
        return this.type;
    }

    public boolean m_142305_(ItemStack first, ItemStack second, Slot p_150894_, ClickAction clickAction, Player p_150896_, SlotAccess p_150897_) {
        Item item;
        if (clickAction == ClickAction.SECONDARY && first.m_41613_() == 1 && ((item = first.m_41720_()).equals(FunctionalStorage.PULLING_UPGRADE.get()) || item.equals(FunctionalStorage.PUSHING_UPGRADE.get()) || item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get()))) {
            Direction direction = UpgradeItem.getDirection(first);
            Direction next = Direction.values()[(Arrays.asList(Direction.values()).indexOf(direction) + 1) % Direction.values().length];
            first.m_41784_().m_128359_("Direction", next.name());
            p_150896_.m_5496_(SoundEvents.f_12490_, 0.5f, 1.0f);
            return true;
        }
        return super.m_142305_(first, second, p_150894_, clickAction, p_150896_, p_150897_);
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        tooltip.add((Component)new TranslatableComponent("upgrade.type").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TranslatableComponent("upgrade.type." + this.getType().name().toLowerCase(Locale.ROOT)).m_130940_(ChatFormatting.WHITE)));
        Item item = stack.m_41720_();
        if (item.equals(FunctionalStorage.PULLING_UPGRADE.get()) || item.equals(FunctionalStorage.PUSHING_UPGRADE.get()) || item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get())) {
            tooltip.add((Component)new TranslatableComponent("item.utility.direction").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TranslatableComponent(WordUtils.capitalize((String)UpgradeItem.getDirection(stack).name().toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.WHITE)));
            tooltip.add((Component)new TextComponent(""));
            tooltip.add((Component)new TranslatableComponent("item.utility.direction.desc").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public static enum Type {
        STORAGE,
        UTILITY;

    }
}

