/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.assets.types.ITankAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BucketItem;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TankScreenAddon
extends BasicScreenAddon {
    private IFluidTank tank;
    private ITankAsset asset;
    private FluidTankComponent.Type type;

    public TankScreenAddon(int posX, int posY, IFluidTank tank, FluidTankComponent.Type type) {
        super(posX, posY);
        this.tank = tank;
        this.type = type;
    }

    @Override
    public void drawBackgroundLayer(PoseStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.asset = IAssetProvider.getAsset(provider, this.type.getAssetType());
        Rectangle area = this.asset.getArea();
        if (!this.tank.getFluid().isEmpty()) {
            TextureAtlasSprite sprite;
            AbstractTexture texture;
            FluidStack fluidStack = this.tank.getFluid();
            double stored = this.tank.getFluidAmount();
            double capacity = this.tank.getCapacity();
            int topBottomPadding = this.asset.getFluidRenderPadding(Direction.UP) + this.asset.getFluidRenderPadding(Direction.DOWN);
            int offset = (int)(stored / capacity * (double)(area.height - topBottomPadding));
            ResourceLocation flowing = fluidStack.getFluid().getAttributes().getStillTexture(fluidStack);
            if (flowing != null && (texture = screen.getMinecraft().m_91097_().m_118506_(TextureAtlas.f_118259_)) instanceof TextureAtlas && (sprite = ((TextureAtlas)texture).m_118316_(flowing)) != null) {
                screen.getMinecraft().m_91097_().m_174784_(TextureAtlas.f_118259_);
                Color color = new Color(fluidStack.getFluid().getAttributes().getColor(fluidStack));
                RenderSystem.m_157429_((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
                RenderSystem.m_69478_();
                Screen.m_93200_((PoseStack)stack, (int)(this.getPosX() + guiX + this.asset.getFluidRenderPadding(Direction.WEST)), (int)(this.getPosY() + guiY + this.asset.getFluidRenderPadding(Direction.UP) + (fluidStack.getFluid().getAttributes().isGaseous() ? 0 : area.height - topBottomPadding - offset)), (int)0, (int)((int)(area.getWidth() - (double)this.asset.getFluidRenderPadding(Direction.EAST) - (double)this.asset.getFluidRenderPadding(Direction.WEST))), (int)offset, (TextureAtlasSprite)sprite);
                RenderSystem.m_69461_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ITankAsset asset = IAssetProvider.getAsset(provider, this.type.getAssetType());
        AssetUtil.drawAsset(stack, screen, asset, guiX + this.getPosX(), guiY + this.getPosY());
    }

    @Override
    public void drawForegroundLayer(PoseStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public List<Component> getTooltipLines() {
        ArrayList<Component> strings = new ArrayList<Component>();
        strings.add((Component)new TextComponent(ChatFormatting.GOLD + new TranslatableComponent("tooltip.titanium.tank.fluid").getString()).m_7220_((Component)(this.tank.getFluid().isEmpty() ? new TranslatableComponent("tooltip.titanium.tank.empty").m_130940_(ChatFormatting.WHITE) : new TranslatableComponent(this.tank.getFluid().getFluid().getAttributes().getTranslationKey(this.tank.getFluid())))).m_130940_(ChatFormatting.WHITE));
        strings.add((Component)new TranslatableComponent("tooltip.titanium.tank.amount").m_130940_(ChatFormatting.GOLD).m_7220_((Component)new TextComponent(ChatFormatting.WHITE + new DecimalFormat().format(this.tank.getFluidAmount()) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + new DecimalFormat().format(this.tank.getCapacity()) + ChatFormatting.DARK_AQUA + "mb")));
        if (!Minecraft.m_91087_().f_91074_.f_36095_.m_142621_().m_41619_() && Minecraft.m_91087_().f_91074_.f_36095_.m_142621_().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            Minecraft.m_91087_().f_91074_.f_36095_.m_142621_().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(iFluidHandlerItem -> {
                boolean isBucket = Minecraft.m_91087_().f_91074_.f_36095_.m_142621_().m_41720_() instanceof BucketItem;
                int amount = isBucket ? 1000 : Integer.MAX_VALUE;
                boolean canFillFromItem = false;
                boolean canDrainFromItem = false;
                if (isBucket) {
                    canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                    canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                } else {
                    canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                    boolean bl = canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                }
                if (canFillFromItem) {
                    strings.add((Component)new TranslatableComponent("tooltip.titanium.tank.can_fill_from_item").m_130940_(ChatFormatting.BLUE));
                }
                if (canDrainFromItem) {
                    strings.add((Component)new TranslatableComponent("tooltip.titanium.tank.can_drain_from_item").m_130940_(ChatFormatting.GOLD));
                }
                if (canFillFromItem) {
                    strings.add((Component)new TranslatableComponent("tooltip.titanium.tank.action_fill").m_130940_(ChatFormatting.DARK_GRAY));
                }
                if (canDrainFromItem) {
                    strings.add((Component)new TranslatableComponent("tooltip.titanium.tank.action_drain").m_130940_(ChatFormatting.DARK_GRAY));
                }
                if (!canDrainFromItem && !canFillFromItem) {
                    strings.add((Component)new TranslatableComponent("tooltip.titanium.tank.no_action").m_130940_(ChatFormatting.RED));
                }
            });
        } else {
            strings.add((Component)new TranslatableComponent("tooltip.titanium.tank.no_tank").m_130940_(ChatFormatting.DARK_GRAY));
        }
        return strings;
    }

    @Override
    public int getXSize() {
        return this.asset != null ? this.asset.getArea().width : 0;
    }

    @Override
    public int getYSize() {
        return this.asset != null ? this.asset.getArea().height : 0;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Screen screen;
        if (!Minecraft.m_91087_().f_91074_.m_150109_().m_36056_().m_41619_() && Minecraft.m_91087_().f_91074_.m_150109_().m_36056_().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent() && (screen = Minecraft.m_91087_().f_91080_) instanceof AbstractContainerScreen && ((AbstractContainerScreen)screen).m_6262_() instanceof ILocatable) {
            if (!this.m_5953_(mouseX - (double)((AbstractContainerScreen)screen).getGuiLeft(), mouseY - (double)((AbstractContainerScreen)screen).getGuiTop())) {
                return false;
            }
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(SoundEvents.f_12490_, SoundSource.PLAYERS, 1.0f, 1.0f, Minecraft.m_91087_().f_91074_.m_142538_()));
            ILocatable locatable = (ILocatable)((AbstractContainerScreen)screen).m_6262_();
            CompoundTag compoundNBT = new CompoundTag();
            if (this.tank instanceof FluidTankComponent) {
                compoundNBT.m_128359_("Name", ((FluidTankComponent)this.tank).getName());
            } else {
                compoundNBT.m_128379_("Invalid", true);
            }
            Minecraft.m_91087_().f_91074_.f_36095_.m_142621_().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(iFluidHandlerItem -> {
                boolean isBucket = Minecraft.m_91087_().f_91074_.f_36095_.m_142621_().m_41720_() instanceof BucketItem;
                int amount = isBucket ? 1000 : Integer.MAX_VALUE;
                boolean canFillFromItem = false;
                boolean canDrainFromItem = false;
                if (isBucket) {
                    canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                    canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) == 1000;
                } else {
                    canFillFromItem = this.tank.fill(iFluidHandlerItem.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                    boolean bl = canDrainFromItem = iFluidHandlerItem.fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE) > 0;
                }
                if (canFillFromItem && button == 0) {
                    compoundNBT.m_128379_("Fill", true);
                }
                if (canDrainFromItem && button == 1) {
                    compoundNBT.m_128379_("Fill", false);
                }
            });
            Titanium.NETWORK.get().sendToServer((Object)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), -3, compoundNBT));
            return true;
        }
        return false;
    }
}

